/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor;

import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.dto.PlanDto;
import com.atlassian.migration.agent.dto.ProgressDto;
import com.atlassian.migration.agent.entity.AbstractSpaceTask;
import com.atlassian.migration.agent.entity.ConfluenceSpaceTask;
import com.atlassian.migration.agent.entity.ExecutionStatus;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.entity.Progress;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.logging.LoggingContextBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.catalogue.PlatformService;
import com.atlassian.migration.agent.service.impl.DefaultPlanService;
import com.atlassian.migration.agent.service.impl.PlanConverter;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.log.MigrationLogService;
import com.atlassian.migration.agent.service.planning.StepPlanningEngine;
import com.atlassian.migration.agent.service.planning.StepPlanningEngines;
import com.atlassian.migration.agent.service.planning.TaskPlanningEngine;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.user.UserMappingsFileManager;
import com.atlassian.migration.agent.store.PlanStore;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.TaskStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.migration.app.DefaultRegistrar;
import com.atlassian.migration.app.dto.AppContainerDetails;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class ProgressTracker {
    private static final Logger log = ContextLoggerFactory.getLogger(ProgressTracker.class);
    private final PluginTransactionTemplate ptx;
    private final StepPlanningEngines planningEngines;
    private final StepStore stepStore;
    private final TaskStore taskStore;
    private final PlanStore planStore;
    private final TaskPlanningEngine taskPlanningEngine;
    private final DefaultRegistrar cloudMigrationRegistrar;
    private final PlatformService platformService;
    private final AnalyticsEventService analyticsEventService;
    private final AnalyticsEventBuilder analyticsEventBuilder;
    private final PlanConverter planConverter;
    private final MigrationDarkFeaturesManager darkFeaturesManager;
    private final UserMappingsFileManager userMappingsFileManager;
    private final MigrationLogService migrationLogService;

    public ProgressTracker(PluginTransactionTemplate ptx, List<StepPlanningEngine<?>> planningEngines, StepStore stepStore, TaskStore taskStore, PlanStore planStore, TaskPlanningEngine taskPlanningEngine, DefaultRegistrar cloudMigrationRegistrar, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, PlanConverter planConverter, PlatformService platformService, MigrationDarkFeaturesManager darkFeaturesManager, UserMappingsFileManager userMappingsFileManager, MigrationLogService migrationLogService) {
        this.ptx = ptx;
        this.planningEngines = new StepPlanningEngines(planningEngines);
        this.stepStore = stepStore;
        this.taskStore = taskStore;
        this.planStore = planStore;
        this.taskPlanningEngine = taskPlanningEngine;
        this.cloudMigrationRegistrar = cloudMigrationRegistrar;
        this.platformService = platformService;
        this.analyticsEventService = analyticsEventService;
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.planConverter = planConverter;
        this.darkFeaturesManager = darkFeaturesManager;
        this.userMappingsFileManager = userMappingsFileManager;
        this.migrationLogService = migrationLogService;
    }

    public void started(String stepId, String message) {
        Objects.requireNonNull(stepId);
        this.withStepAndWriteTx(stepId, step -> this.started((Step)step, message));
    }

    public void started(Step step, String message) {
        Objects.requireNonNull(step);
        Objects.requireNonNull(message);
        log.info("Step started: {}, message: {}", (Object)step.getId(), (Object)message);
        step.setProgress(step.getProgress().copy().started(message));
        this.stepStore.update(step);
        Task task = step.getTask();
        StepPlanningEngine.PercentRange percentRange = this.getStepPercentRange(step);
        ExecutionStatus status = task.getProgress().getStatus();
        if (percentRange.isFirst() && status != ExecutionStatus.RUNNING) {
            task.setProgress(task.getProgress().copy().started(message));
            this.saveTaskAnalyticsEvent(task, status);
        } else {
            task.setProgress(task.getProgress().copy().progress(percentRange.from, message));
        }
        this.taskStore.update(task);
    }

    public void progress(String stepId, int percent, @Nullable String message) {
        Objects.requireNonNull(stepId);
        this.withStepAndWriteTx(stepId, step -> {
            StepPlanningEngine.PercentRange percentRange;
            step.setProgress(step.getProgress().copy().progress(percent, message));
            this.stepStore.update((Step)step);
            try {
                percentRange = this.getStepPercentRange((Step)step);
            }
            catch (IllegalStateException e) {
                log.error("Cannot get step range, skipping update of task", (Throwable)e);
                return;
            }
            Task task = step.getTask();
            int newPercent = percentRange.from + (percentRange.to - percentRange.from) * percent / 100;
            task.setProgress(task.getProgress().copy().progress(newPercent, message));
            this.taskStore.update(task);
        });
    }

    public void completed(String stepId, StepResult result) {
        Objects.requireNonNull(stepId);
        this.withStepAndWriteTx(stepId, step -> this.completed((Step)step, result));
    }

    public void completed(Step step, StepResult result) {
        Objects.requireNonNull(step);
        Objects.requireNonNull(result);
        if (result.isSuccess()) {
            this.done(step, result.getMessage(), result.getResult());
        } else if (result.isStopped()) {
            this.stopped(step);
        } else {
            this.failed(step, result.getMessage(), result.getException());
        }
        this.sendStandardisedStepCompletionEvents(step, step.getProgress().getStatus());
    }

    private StepPlanningEngine.PercentRange getStepPercentRange(Step step) {
        Task task = step.getTask();
        StepPlanningEngine<? extends Task> engine = this.planningEngines.of(task).orElseThrow(() -> new IllegalStateException("Unknown task type " + task.getClass()));
        Optional<StepPlanningEngine.PercentRange> maybeRange = engine.getStepPercentRange(step);
        return maybeRange.orElseThrow(() -> new IllegalStateException("Unknown step type " + step.getType()));
    }

    private void updatePlanWhenStepDone(Task task) {
        String planId = task.getPlan().getId();
        Plan plan = this.planStore.getPlanAndLock(planId);
        Progress planProgress = plan.getProgress();
        if (planProgress.getStatus().isCompleted()) {
            log.debug("Plan is completed, progress will not be updated further");
            return;
        }
        Progress newProgress = planProgress.copy().progress(this.taskStore.calculatePlanPercent(planId));
        plan.setProgress(newProgress);
        if (this.darkFeaturesManager.isSchedulerFixEnabled() && this.taskPlanningEngine.hasReachedTerminalState(planId)) {
            this.setPlanAsComplete(plan);
            this.planStore.updatePlan(plan);
            this.savePlanAnalyticsEvents(planId, plan.getProgress().getStatus() == ExecutionStatus.DONE);
        } else {
            this.planStore.updatePlan(plan);
        }
    }

    @Deprecated
    public void stopPlan(String planId) {
        this.ptx.write(() -> {
            Plan plan = this.planStore.getPlanAndLock(planId);
            Progress newProgress = plan.getProgress().copy().stopped();
            plan.setProgress(newProgress);
            this.planStore.updatePlan(plan);
        });
        this.savePlanAnalyticsEvents(planId, false);
        this.cleanupUserMappings(planId);
    }

    private void setPlanAsComplete(Plan plan) {
        Progress newProgress;
        Optional<Task> failedTask = this.taskStore.findFirstTaskWithStatusForPlan(plan.getId(), ExecutionStatus.FAILED);
        boolean hasSuccessfulSpaceTask = this.taskStore.existTaskByStatusByTypeInPlan(plan.getId(), ExecutionStatus.DONE, ConfluenceSpaceTask.class);
        if (failedTask.isPresent() && !hasSuccessfulSpaceTask) {
            String message = failedTask.get().getProgress().getMessage();
            newProgress = plan.getProgress().copy().failed(message);
        } else {
            newProgress = plan.getProgress().getStatus() == ExecutionStatus.STOPPING ? plan.getProgress().copy().stopped() : (failedTask.isPresent() ? plan.getProgress().copy().incomplete(failedTask.get().getProgress().getMessage()) : plan.getProgress().copy().done());
        }
        plan.setProgress(newProgress);
    }

    public void failPlan(String planId, String message) {
        Plan updatedPlan = this.ptx.write(() -> {
            Plan plan = this.planStore.getPlanAndLock(planId);
            Progress newProgress = plan.getProgress().copy().failed(message);
            plan.setProgress(newProgress);
            this.planStore.updatePlan(plan);
            return plan;
        });
        this.savePlanAnalyticsEvents(planId, false);
        this.cleanupUserMappings(planId);
        this.uploadMigrationLogZipToMCS(updatedPlan.getCloudSite().getCloudId(), updatedPlan.getMigrationId());
    }

    public void failTask(String taskId, String message) {
        this.ptx.write(() -> {
            Task task = this.taskStore.getTask(taskId);
            ExecutionStatus status = task.getProgress().getStatus();
            task.setProgress(task.getProgress().copy().failed(message));
            this.taskStore.update(task);
            this.stepStore.getStepsByTaskId(taskId).stream().filter(step -> !step.getProgress().getStatus().isCompleted()).forEach(step -> {
                step.setProgress(step.getProgress().copy().failed(message));
                this.stepStore.update((Step)step);
            });
            this.saveTaskAnalyticsEvent(task, status);
            this.updatePlanWhenStepDone(task);
        });
    }

    @Deprecated
    public void succeedPlan(String planId) {
        this.ptx.write(() -> {
            Plan plan = this.planStore.getPlanAndLock(planId);
            Progress newProgress = plan.getProgress().copy().done();
            plan.setProgress(newProgress);
            this.planStore.updatePlan(plan);
            if (DefaultPlanService.getMigrateAppsTask(plan).isPresent()) {
                Set<AppContainerDetails> appContainerDetails = this.platformService.getAppContainers(plan.getCloudSite().getCloudId(), plan.getMigrationId());
                this.cloudMigrationRegistrar.startMigration(plan.getCloudSite().getCloudId(), plan.getMigrationId(), appContainerDetails);
            }
        });
        this.savePlanAnalyticsEvents(planId, true);
        this.cleanupUserMappings(planId);
    }

    private void done(Step step, @Nullable String message, @Nullable String result) {
        StepPlanningEngine.PercentRange percentRange;
        log.debug("Step done, message: {}", (Object)message);
        try {
            percentRange = this.getStepPercentRange(step);
        }
        catch (IllegalStateException e) {
            this.failed(step, "Failed to get the step percent, just try to mark it fail", e);
            return;
        }
        step.setProgress(step.getProgress().copy().done(message, result));
        this.stepStore.update(step);
        Task task = step.getTask();
        ExecutionStatus status = task.getProgress().getStatus();
        if (percentRange.isLast()) {
            task.setProgress(task.getProgress().copy().done(message, null));
            this.saveTaskAnalyticsEvent(task, status);
        } else if (step.getPlan().getProgress().getStatus() == ExecutionStatus.STOPPING) {
            task.setProgress(task.getProgress().copy().stopped());
            this.saveTaskAnalyticsEvent(task, status);
        } else {
            task.setProgress(task.getProgress().copy().progress(percentRange.to, message));
        }
        this.taskStore.update(task);
        this.updatePlanWhenStepDone(task);
    }

    private void stopped(Step step) {
        log.debug("Step stopped");
        step.setProgress(step.getProgress().copy().stopped());
        this.stepStore.update(step);
        Task task = step.getTask();
        ExecutionStatus status = task.getProgress().getStatus();
        task.setProgress(task.getProgress().copy().stopped());
        this.taskStore.update(task);
        this.saveTaskAnalyticsEvent(task, status);
        this.updatePlanWhenStepDone(task);
    }

    private void failed(Step step, String message, @Nullable Throwable e) {
        log.error("Step failed, message: {}", (Object)message, (Object)e);
        step.setProgress(step.getProgress().copy().failed(message));
        this.stepStore.update(step);
        Task task = step.getTask();
        ExecutionStatus status = task.getProgress().getStatus();
        task.setProgress(task.getProgress().copy().failed(message));
        this.taskStore.update(task);
        this.saveTaskAnalyticsEvent(task, status);
        this.updatePlanWhenStepDone(task);
        this.saveToLogFile(step, message, e);
    }

    void savePlanAnalyticsEvents(String planId, boolean success) {
        try {
            this.ptx.write(() -> {
                Plan plan = this.planStore.getPlanAndLock(planId);
                ExecutionStatus status = plan.getProgress().getStatus();
                PlanDto planDto = this.planConverter.entityToDto(plan, true);
                this.analyticsEventService.sendAnalyticsEvents(() -> ImmutableList.of((Object)this.analyticsEventBuilder.buildUpdatedPlanStatusAnalyticEvent(planDto, ProgressDto.convertStatus(status, null)), (Object)this.analyticsEventBuilder.buildCompletedPlanAnalyticsEvent(planDto), (Object)this.analyticsEventBuilder.buildMetricEventForConfluenceMigration(success), (Object)this.analyticsEventBuilder.buildPlatformPlanCompletionOperationalEvent(planDto, plan.getMigrationScopeId(), status), (Object)this.analyticsEventBuilder.buildPlatformPlanCompletionMetricEvent(status)));
            });
        }
        catch (Exception e) {
            log.error("Failed to save analytics", (Throwable)e);
        }
    }

    private void sendStandardisedStepCompletionEvents(Step currentStep, ExecutionStatus status) {
        if (currentStep.getType().equals(StepType.CONFLUENCE_EXPORT.name()) && status == ExecutionStatus.DONE) {
            return;
        }
        this.analyticsEventService.sendAnalyticsEvents(() -> ImmutableList.of((Object)this.analyticsEventBuilder.buildPlatformStepCompletionOperationalEvent(currentStep, status), (Object)this.analyticsEventBuilder.buildPlatformStepCompletionMetricEvent(currentStep.getType(), status), (Object)this.analyticsEventBuilder.buildPlatformStepCompletionExtendedMetricEvent(currentStep.getType(), status)));
    }

    void saveTaskAnalyticsEvent(Task task, ExecutionStatus status) {
        boolean abstractSpaceTask = task instanceof AbstractSpaceTask;
        this.analyticsEventService.saveAnalyticsEventAsync(() -> this.analyticsEventBuilder.buildUpdatedTaskStatusAnalyticEvent(task.getPlan().getId(), task.getId(), task.getAnalyticsEventType(), ProgressDto.convertStatus(status, null), ProgressDto.convertStatus(task.getProgress().getStatus(), null), abstractSpaceTask ? ((AbstractSpaceTask)task).getSpaceKey() : null));
    }

    private void withStepAndWriteTx(String stepId, Consumer<Step> consumer) {
        this.ptx.write(() -> {
            Step step = this.stepStore.getAndLock(stepId);
            LoggingContextBuilder.logCtx().withStep(step).execute(() -> consumer.accept(step));
        });
    }

    @Deprecated
    private void cleanupUserMappings(String planId) {
        log.info("Cleaning up user mappings for plan {}", (Object)planId);
        this.userMappingsFileManager.cleanupUserMappingsFile(planId);
    }

    private void saveToLogFile(Step step, String reason, @Nullable Throwable exception) {
        this.migrationLogService.saveToLogFile(step, reason, exception);
    }

    @Deprecated
    private void uploadMigrationLogZipToMCS(String cloudId, String migrationId) {
        this.migrationLogService.uploadMigrationLogZipToMCS(cloudId, migrationId);
    }
}

