/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.planning;

import com.atlassian.migration.agent.entity.MigrateAppsTask;
import com.atlassian.migration.agent.entity.MigrateUsersTask;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.store.TaskStore;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class TaskPlanningEngine {
    private final TaskStore taskStore;

    public TaskPlanningEngine(TaskStore taskStore) {
        this.taskStore = taskStore;
    }

    public List<Task> getTasksOfPlan(String planId) {
        return this.taskStore.getTasksForPlan(planId);
    }

    public List<Task> getFirstTasks(String planId) {
        List<Task> tasks = this.taskStore.getTasksForPlan(planId);
        Optional<Task> migrateUsers = tasks.stream().filter(task -> task instanceof MigrateUsersTask).findFirst();
        return migrateUsers.map(Collections::singletonList).orElse(tasks);
    }

    public List<Task> getNextTasks(Task task) {
        if (task instanceof MigrateUsersTask) {
            return this.taskStore.getTasksForPlan(task.getPlan().getId()).stream().filter(dbTask -> !(dbTask instanceof MigrateUsersTask) && !(dbTask instanceof MigrateAppsTask)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public boolean hasReachedTerminalState(String planId) {
        return this.taskStore.areTasksInTerminalState(planId);
    }
}

