/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.log;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.log.MigrationLogException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.ParametersAreNonnullByDefault;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class MigrationLogDirManager {
    private static final Logger log = ContextLoggerFactory.getLogger(MigrationLogDirManager.class);
    private static final String MIGRATION_PATH = "migration";
    private static final String LOG_PATH = "log";
    private static final String MIGRATION_ERROR_LOG_SUFFIX = "-migration-error-logs";
    private static final String LOG_EXTENSION = ".log";
    private static final String ZIP_EXTENSION = ".zip";
    private final BootstrapManager bootstrapManager;

    public MigrationLogDirManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void saveToFile(String migrationId, String message) {
        log.info("Saving migration log message for migrationId: {} to file", (Object)migrationId);
        try {
            FileUtils.writeStringToFile((File)this.getMigrationLogFile(migrationId).toFile(), (String)message, (Charset)StandardCharsets.UTF_8, (boolean)true);
        }
        catch (IOException e) {
            throw new MigrationLogException("Can't save migration logs to file for migrationId: " + migrationId, e);
        }
    }

    public void zipLogFile(String migrationId) {
        log.info("Zipping migration log file for migrationId: {}", (Object)migrationId);
        Path migrationLogFile = this.getMigrationLogFile(migrationId);
        Path zipfilePath = this.getMigrationLogZipFile(migrationId);
        ZipFile zip = new ZipFile(zipfilePath.toFile());
        try {
            zip.addFile(migrationLogFile.toFile());
        }
        catch (ZipException e) {
            throw new MigrationLogException("Can't zip migration log file for migrationId: " + migrationId, e);
        }
        finally {
            this.cleanupMigrationLogFile(migrationId);
        }
    }

    public Path getMigrationLogZipFile(String file) {
        return this.getMigrationLogPath().resolve(file + MIGRATION_ERROR_LOG_SUFFIX + ZIP_EXTENSION);
    }

    public void cleanupMigrationLogZipFile(String file) {
        try {
            Files.delete(this.getMigrationLogZipFile(file));
        }
        catch (IOException e) {
            log.error("Failed to clean up migration log file. Reason: " + e.getMessage(), (Throwable)e);
        }
    }

    @VisibleForTesting
    Path getMigrationLogFile(String file) {
        return this.getMigrationLogPath().resolve(file + MIGRATION_ERROR_LOG_SUFFIX + LOG_EXTENSION);
    }

    @VisibleForTesting
    void cleanupMigrationLogFile(String file) {
        try {
            Files.delete(this.getMigrationLogFile(file));
        }
        catch (IOException e) {
            log.error("Failed to clean up migration log file. Reason: " + e.getMessage(), (Throwable)e);
        }
    }

    private Path getMigrationLogPath() {
        Path path = Paths.get(this.bootstrapManager.getSharedHome().getAbsolutePath(), MIGRATION_PATH, LOG_PATH);
        if (!path.toFile().exists()) {
            try {
                return Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MigrationLogException("Unable to create migration logs directory", e);
            }
        }
        return path;
    }
}

