/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.migration.agent.entity.WorkItem;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.store.impl.WorkItemStore;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;

@Deprecated
public class WorkItemQueue {
    private static final Logger log = ContextLoggerFactory.getLogger(WorkItemQueue.class);
    static final String CLUSTER_LOCK = "WorkItemQueueLock";
    private final WorkItemStore workItemStore;
    private final ClusterLockService clusterLockService;

    public WorkItemQueue(WorkItemStore workItemStore, ClusterLockService clusterLockService) {
        this.workItemStore = workItemStore;
        this.clusterLockService = clusterLockService;
    }

    public <T> T performWithLocking(Callable<T> callable) {
        ClusterLock workItemLock = this.clusterLockService.getLockForName(CLUSTER_LOCK);
        workItemLock.lock();
        try {
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            workItemLock.unlock();
        }
    }

    public Long enqueue(String refId, String groupId, String itemType) {
        WorkItem workItem = WorkItem.newReadyItem(refId, groupId, itemType);
        Long workItemId = this.workItemStore.createWorkItem(workItem);
        log.debug("Created new work item with ID {}", (Object)workItem);
        return workItemId;
    }

    public List<WorkItem> getBatchByType(String itemType, int batchSize) {
        return this.workItemStore.getBatchByType(itemType, batchSize);
    }

    public void claim(String refId, String jobId) {
        WorkItem workItem = this.workItemStore.getAndLockWorkItemByRefId(refId);
        workItem.setStatus(WorkItem.Status.STARTED);
        workItem.setJobId(jobId);
        this.workItemStore.updateWorkItem(workItem);
        log.debug("Job {} successfully claimed work item with ID {}", (Object)jobId, (Object)workItem.getItemId());
    }

    public void dequeue(String refId) {
        this.workItemStore.deleteWorkItemByRefId(refId);
        log.debug("Successfully removed work item with ref ID {}", (Object)refId);
    }

    public int incrementAndGetFailureCount(String refId) {
        WorkItem workItem = this.workItemStore.getAndLockWorkItemByRefId(refId);
        int currentRetryCount = workItem.getRetryCount();
        workItem.setRetryCount(currentRetryCount + 1);
        this.workItemStore.updateWorkItem(workItem);
        log.debug("Updated retry count for ref ID {} from {} to {}", new Object[]{refId, currentRetryCount, workItem.getRetryCount()});
        return workItem.getRetryCount();
    }

    public void resetFailureCount(String refId) {
        WorkItem workItem = this.workItemStore.getAndLockWorkItemByRefId(refId);
        int currentRetryCount = workItem.getRetryCount();
        workItem.setRetryCount(0);
        this.workItemStore.updateWorkItem(workItem);
        log.debug("Reset retry count for ref ID {} from {} to {}", new Object[]{refId, currentRetryCount, workItem.getRetryCount()});
    }

    public List<WorkItem> dequeueReadyItemsInGroup(String groupId) {
        List<WorkItem> workItems = this.workItemStore.getWorkItemsByGroupIdWithStatus(groupId, WorkItem.Status.READY);
        this.workItemStore.deleteWorkItemsByGroupIdWithStatus(groupId, WorkItem.Status.READY);
        return workItems;
    }

    public List<WorkItem> dequeueAllItemsInGroup(String groupId) {
        return this.performWithLocking(() -> {
            List<WorkItem> workItems = this.workItemStore.getWorkItemsByGroupId(groupId);
            this.workItemStore.deleteWorkItemsByGroupId(groupId);
            return workItems;
        });
    }

    public boolean hasItemsInGroup(String groupId) {
        return this.workItemStore.hasItemsInGroup(groupId);
    }
}

