/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.check.PreflightService;
import com.atlassian.migration.agent.service.impl.AppMigrationDevelopmentService;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;

@Path(value="app-migration")
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AppMigrationResource {
    private final AppMigrationDevelopmentService appMigrationDevelopmentService;
    private final PreflightService preflightService;
    private static final Logger log = ContextLoggerFactory.getLogger(AppMigrationResource.class);

    @Inject
    public AppMigrationResource(AppMigrationDevelopmentService appMigrationDevelopmentService, PreflightService preflightService) {
        this.appMigrationDevelopmentService = appMigrationDevelopmentService;
        this.preflightService = preflightService;
    }

    @GET
    @Path(value="/rerun/{planId}")
    @Consumes(value={"*/*"})
    public Response startMigration(@PathParam(value="planId") String planId) {
        try {
            this.appMigrationDevelopmentService.rerunAppMigrationForPlan(planId);
        }
        catch (Exception e) {
            log.warn("Exception:", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.noContent().build();
    }

    @GET
    @Path(value="/check/{planId}/run/{appKey}")
    @Consumes(value={"*/*"})
    public Response executeAppOwnedPreflightCheck(@PathParam(value="appKey") String serverAppKey, @PathParam(value="planId") String planId) {
        try {
            this.preflightService.executeAllAppVendorChecksForApp(planId, serverAppKey);
        }
        catch (Exception e) {
            log.warn("Exception:", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.noContent().build();
    }
}

