/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.queue;

public class QueueConsumerConfiguration {
    private final String consumerType;
    private final int concurrencyLevel;

    private QueueConsumerConfiguration(String consumerType, int concurrencyLevel) {
        this.consumerType = consumerType;
        this.concurrencyLevel = concurrencyLevel;
    }

    public static QueueConsumerConfigurationBuilder builder(String consumerType) {
        return new QueueConsumerConfigurationBuilder(consumerType);
    }

    public String getConsumerType() {
        return this.consumerType;
    }

    public int getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    public static class QueueConsumerConfigurationBuilder {
        private int concurrencyLevel;
        private String consumerType;

        public QueueConsumerConfiguration build() {
            return new QueueConsumerConfiguration(this.consumerType, this.concurrencyLevel);
        }

        public QueueConsumerConfigurationBuilder(String consumerType) {
            this.consumerType = consumerType;
        }

        public QueueConsumerConfigurationBuilder withConcurrencyLevel(int concurrencyLevel) {
            this.concurrencyLevel = concurrencyLevel;
            return this;
        }
    }
}

