/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.space;

import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.stepexecutor.space.ContentIdsXmlExtractor;
import com.atlassian.migration.agent.service.stepexecutor.space.InlineTaskStore;
import com.atlassian.migration.agent.service.stepexecutor.space.PostprocessingIOUtil;
import com.atlassian.migration.agent.service.stepexecutor.space.helper.XMLHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class InlineTasksPostprocessor {
    private static final Logger log = ContextLoggerFactory.getLogger(InlineTasksPostprocessor.class);
    private static final String ENTITIES_XML_ZIP_ENTRY_NAME = "entities.xml";
    private static final String EXPORT_DESCRIPTOR_ENTRY_NAME = "exportDescriptor.properties";
    private static final String NEW_LINE = "\n";
    private final InlineTaskStore inlineTaskStore;
    private final ContentIdsXmlExtractor contentIdsXmlExtractor;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final String serverUrl;
    private final MigrationAgentConfiguration migrationAgentConfiguration;

    public InlineTasksPostprocessor(InlineTaskStore inlineTaskStore, ContentIdsXmlExtractor contentIdsXmlExtractor, MigrationDarkFeaturesManager migrationDarkFeaturesManager, SystemInformationService sysInfoService, MigrationAgentConfiguration migrationAgentConfiguration) {
        this.inlineTaskStore = inlineTaskStore;
        this.contentIdsXmlExtractor = contentIdsXmlExtractor;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.serverUrl = sysInfoService.getConfluenceInfo().getBaseUrl();
        this.migrationAgentConfiguration = migrationAgentConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void postprocess(Path exportFile, boolean usersCreatedInUMS) {
        Path modifiedExportFile = null;
        modifiedExportFile = Files.createTempFile(exportFile.getParent(), null, null, new FileAttribute[0]);
        try (ZipFile zipFile = new ZipFile(exportFile.toFile());
             ZipOutputStream zipOS = new ZipOutputStream(IOUtils.buffer((OutputStream)Files.newOutputStream(modifiedExportFile, new OpenOption[0])));){
            ZipContents zipContents = this.segregateZipEntries(zipFile);
            List<Long> contentIds = this.extractContentIdsFromEntityFile(zipFile, zipOS, zipContents);
            this.addInlineTasksFileToZip(zipOS, contentIds);
            this.copyOtherFiles(zipFile, zipOS, zipContents);
            this.updateDescriptorFile(zipFile, zipOS, zipContents, usersCreatedInUMS || this.migrationDarkFeaturesManager.shouldHandleInvalidAndDuplicateEmailUsers());
        }
        Files.move(modifiedExportFile, exportFile, StandardCopyOption.REPLACE_EXISTING);
        if (modifiedExportFile == null) return;
        try {
            Files.deleteIfExists(modifiedExportFile);
            return;
        }
        catch (IOException e) {
            log.warn("Couldn't delete temp file", (Throwable)e);
        }
        return;
        catch (Exception e) {
            try {
                log.error("Couldn't postprocess space export file for extracting inline tasks.", (Throwable)e);
                if (modifiedExportFile == null) return;
            }
            catch (Throwable throwable) {
                if (modifiedExportFile == null) throw throwable;
                try {
                    Files.deleteIfExists(modifiedExportFile);
                    throw throwable;
                }
                catch (IOException e2) {
                    log.warn("Couldn't delete temp file", (Throwable)e2);
                }
                throw throwable;
            }
            try {
                Files.deleteIfExists(modifiedExportFile);
                return;
            }
            catch (IOException e3) {
                log.warn("Couldn't delete temp file", (Throwable)e3);
            }
            return;
        }
    }

    private ZipContents segregateZipEntries(ZipFile zipFile) {
        ZipContents zipContents = new ZipContents();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (ENTITIES_XML_ZIP_ENTRY_NAME.equals(entry.getName())) {
                zipContents.entitiesFile = entry;
                continue;
            }
            if (EXPORT_DESCRIPTOR_ENTRY_NAME.equals(entry.getName())) {
                zipContents.descriptor = entry;
                continue;
            }
            zipContents.otherFiles.add(entry);
        }
        return zipContents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Long> extractContentIdsFromEntityFile(ZipFile zipFile, ZipOutputStream zipOS, ZipContents zipContents) throws Exception {
        ArrayList<Long> contentIds = new ArrayList<Long>();
        zipOS.putNextEntry(PostprocessingIOUtil.copyEntry(zipContents.entitiesFile));
        InputStream entryIS = zipFile.getInputStream(zipContents.entitiesFile);
        try {
            contentIds.addAll(this.contentIdsXmlExtractor.extractContentIds(XMLHelper.getXmlInputStream(entryIS), zipOS));
        }
        finally {
            PostprocessingIOUtil.runQuietly(entryIS::close);
        }
        zipOS.closeEntry();
        return contentIds;
    }

    private void addInlineTasksFileToZip(ZipOutputStream zipOS, List<Long> contentIds) throws IOException {
        ZipEntry inlineTasksFile = new ZipEntry("AO_BAF3AA_AOINLINE_TASK.csv");
        zipOS.putNextEntry(inlineTasksFile);
        this.inlineTaskStore.exportTasksToStream(contentIds, zipOS);
        zipOS.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyOtherFiles(ZipFile zipFile, ZipOutputStream zipOS, ZipContents zipContents) throws IOException {
        for (ZipEntry otherFile : zipContents.otherFiles) {
            zipOS.putNextEntry(PostprocessingIOUtil.copyEntry(otherFile));
            InputStream entryIS = zipFile.getInputStream(otherFile);
            try {
                IOUtils.copy((InputStream)entryIS, (OutputStream)zipOS);
            }
            finally {
                PostprocessingIOUtil.runQuietly(entryIS::close);
            }
            zipOS.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDescriptorFile(ZipFile zipFile, ZipOutputStream zipOS, ZipContents zipContents, boolean usersCreatedInUMS) throws IOException {
        zipOS.putNextEntry(PostprocessingIOUtil.copyEntry(zipContents.descriptor));
        InputStream entryIS = zipFile.getInputStream(zipContents.descriptor);
        try {
            IOUtils.copy((InputStream)entryIS, (OutputStream)zipOS);
            String migrationProperties = NEW_LINE + "inlineTasksFileIncluded=true" + NEW_LINE + "confluence.server.url=" + this.serverUrl + NEW_LINE + "usersCreatedInUMS=" + Boolean.valueOf(usersCreatedInUMS) + NEW_LINE + "timezone=" + this.migrationAgentConfiguration.getServerTimezone() + NEW_LINE;
            zipOS.write(migrationProperties.getBytes(StandardCharsets.ISO_8859_1));
        }
        finally {
            PostprocessingIOUtil.runQuietly(entryIS::close);
        }
        zipOS.closeEntry();
    }

    private static final class ZipContents {
        List<ZipEntry> otherFiles = new ArrayList<ZipEntry>();
        ZipEntry descriptor;
        ZipEntry entitiesFile;

        private ZipContents() {
        }
    }
}

