/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.free;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.cmpt.check.mapper.CheckResultMapper;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.check.CheckContextProvider;
import com.atlassian.migration.agent.service.check.CheckRegistration;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.migration.agent.service.check.free.CloudFreeConflictCheckContextProvider;
import com.atlassian.migration.agent.service.check.free.CloudFreeUsersConflictChecker;
import com.atlassian.migration.agent.service.check.free.CloudFreeUsersConflictContext;
import com.atlassian.migration.agent.service.check.free.CloudFreeUsersConflictMapper;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.service.user.RetryingUsersMigrationService;
import com.atlassian.migration.agent.service.user.UsersMigrationRequestBuilder;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class CloudFreeUsersConflictCheckRegistration
implements CheckRegistration<CloudFreeUsersConflictContext> {
    private final CloudFreeUsersConflictChecker checker;
    private final CloudFreeConflictCheckContextProvider contextProvider;
    private final CloudFreeUsersConflictMapper resultMapper;
    private final AnalyticsEventBuilder analyticsEventBuilder;

    public CloudFreeUsersConflictCheckRegistration(AnalyticsEventBuilder analyticsEventBuilder, CloudSiteService cloudSiteService, SystemInformationService systemInformationService, RetryingUsersMigrationService usersMigrationService, UsersMigrationRequestBuilder usersMigrationRequestBuilder) {
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.checker = new CloudFreeUsersConflictChecker(cloudSiteService, usersMigrationService, usersMigrationRequestBuilder, systemInformationService);
        this.resultMapper = new CloudFreeUsersConflictMapper();
        this.contextProvider = new CloudFreeConflictCheckContextProvider();
    }

    @Override
    public CheckType getCheckType() {
        return CheckType.CLOUD_FREE_USERS_CONFLICT;
    }

    @Override
    public Checker<CloudFreeUsersConflictContext> getChecker() {
        return this.checker;
    }

    @Override
    public CheckContextProvider<CloudFreeUsersConflictContext> getCheckContextProvider() {
        return this.contextProvider;
    }

    @Override
    public CheckResultMapper getCheckResultMapper() {
        return this.resultMapper;
    }

    @Override
    public EventDto getAnalyticsEventModel(CheckResult checkResult, long totalTime) {
        return this.analyticsEventBuilder.buildPreflightCloudFreeUsersCheck(checkResult.success, totalTime);
    }

    @Override
    public String getFailedToExecuteAnalyticsEventName() {
        return "cloudFreeUsersConflictCheck";
    }
}

