/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.newexport;

import com.ctc.wstx.api.WstxInputProperties;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class XmlIdExtractor {
    private static final Logger log = LoggerFactory.getLogger(XmlIdExtractor.class);

    public void extractIdsAndKeys(String sourceXmlFile, String outputFile) throws FileNotFoundException, XMLStreamException {
        ArrayList<Long> ids = new ArrayList<Long>();
        ArrayList<String> userKeys = new ArrayList<String>();
        ArrayList<String> compositeIds = new ArrayList<String>();
        XMLStreamReader streamReader = this.configureXmlStreamReader(sourceXmlFile);
        this.extractObjectPrimaryKeysFromXml(ids, userKeys, compositeIds, streamReader);
        this.serializePrimaryKeys(outputFile, ids, userKeys, compositeIds);
    }

    private void extractObjectPrimaryKeysFromXml(List<Long> ids, List<String> keys, List<String> propertySetItemIds, XMLStreamReader streamReader) throws XMLStreamException {
        while (streamReader.hasNext()) {
            streamReader.next();
            if (streamReader.getEventType() != 1 || !streamReader.getLocalName().equalsIgnoreCase("object")) continue;
            this.readUntilStartElem(streamReader);
            if (streamReader.getLocalName().equalsIgnoreCase("id")) {
                String idStr = streamReader.getElementText();
                if (this.isNumber(idStr)) {
                    ids.add(Long.valueOf(idStr));
                    continue;
                }
                keys.add(idStr);
                continue;
            }
            if (!streamReader.getLocalName().equalsIgnoreCase("composite-id")) continue;
            this.readUntilStartElem(streamReader);
            String entityName = streamReader.getElementText();
            this.readUntilStartElem(streamReader);
            String entityId = streamReader.getElementText();
            this.readUntilStartElem(streamReader);
            String key = streamReader.getElementText();
            propertySetItemIds.add(entityName + "," + entityId + "," + key);
        }
    }

    private void readUntilStartElem(XMLStreamReader streamReader) throws XMLStreamException {
        do {
            streamReader.next();
        } while (streamReader.getEventType() != 1);
    }

    private XMLStreamReader configureXmlStreamReader(String sourceXmlFile) throws XMLStreamException, FileNotFoundException {
        File file = new File(sourceXmlFile);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isNamespaceAware", false);
        factory.setProperty("javax.xml.stream.supportDTD", false);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        factory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        factory.setProperty("javax.xml.stream.isCoalescing", false);
        factory.setProperty("com.ctc.wstx.fragmentMode", WstxInputProperties.PARSING_MODE_FRAGMENT);
        return factory.createXMLStreamReader(new FileReader(file));
    }

    private void serializePrimaryKeys(String outputFile, List<Long> ids, List<String> keys, List<String> propertySetItemIds) {
        Collections.sort(ids);
        Collections.sort(keys);
        Collections.sort(propertySetItemIds);
        try (FileWriter writer = new FileWriter(outputFile);
             BufferedWriter bw = new BufferedWriter(writer);){
            for (Long id : ids) {
                bw.write(id + "\n");
            }
            for (String key : keys) {
                bw.write(key + "\n");
            }
            for (String propertyID : propertySetItemIds) {
                bw.write(propertyID + "\n");
            }
        }
        catch (IOException e) {
            log.error("Error producing the primary keys file", (Throwable)e);
        }
    }

    private boolean isNumber(String idStr) {
        try {
            Long.valueOf(idStr);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

