/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.space;

import com.atlassian.cmpt.validation.IdentityAcceptedEmailValidator;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.stepexecutor.space.PostprocessingIOUtil;
import com.atlassian.migration.agent.service.stepexecutor.space.XMLEventUtil;
import com.atlassian.migration.agent.service.stepexecutor.space.helper.XMLHelper;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.jodah.failsafe.function.CheckedFunction;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class SpaceExportEmailValidatorPostProcessor {
    private static final Logger log = ContextLoggerFactory.getLogger(SpaceExportEmailValidatorPostProcessor.class);
    private static final String ENTITIES_XML_ZIP_ENTRY_NAME = "entities.xml";
    private static final String CONFLUENCE_USER_IMPL_CLASS = "ConfluenceUserImpl";
    private static final String PROPERTY_TAG = "property";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String EMAIL_ATTRIBUTE_VALUE = "email";
    private final XMLInputFactory inputFactory;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;

    public SpaceExportEmailValidatorPostProcessor(MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.inputFactory = XMLInputFactory.newFactory();
        this.inputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        this.inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        this.inputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> postprocess(Path exportFile) {
        if (this.migrationDarkFeaturesManager.shouldHandleInvalidAndDuplicateEmailUsers()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        try (ZipFile in = new ZipFile(exportFile.toFile());){
            Enumeration<? extends ZipEntry> entries = in.entries();
            while (entries.hasMoreElements()) {
                InputStream entryInputStream;
                block18: {
                    ZipEntry entry = entries.nextElement();
                    entryInputStream = in.getInputStream(entry);
                    try {
                        if (!ENTITIES_XML_ZIP_ENTRY_NAME.equals(entry.getName())) break block18;
                        result.addAll(this.processEntities(XMLHelper.getXmlInputStream(entryInputStream)));
                    }
                    catch (Throwable throwable) {
                        PostprocessingIOUtil.runQuietly(entryInputStream::close);
                        throw throwable;
                        return result;
                    }
                }
                PostprocessingIOUtil.runQuietly(entryInputStream::close);
            }
        }
        catch (Exception e) {
            log.error("Couldn't postprocess space export file for validating emails.", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> processEntities(InputStream in) throws Exception {
        XMLEventReader reader = null;
        ArrayList<String> result = new ArrayList<String>();
        try {
            reader = this.inputFactory.createXMLEventReader(in);
            XMLEventProcessor currentProcessor = this::processUntilUserObject;
            ArrayList<String> emails = new ArrayList<String>();
            while (reader.hasNext()) {
                currentProcessor = (XMLEventProcessor)currentProcessor.apply(new ProcessingContext(reader, reader.nextEvent(), emails));
            }
            result.addAll(emails);
        }
        finally {
            if (reader != null) {
                PostprocessingIOUtil.runQuietly(reader::close);
            }
        }
        return result;
    }

    private XMLEventProcessor processUntilUserObject(ProcessingContext ctx) throws XMLStreamException {
        StartElement element;
        if (ctx.event.isStartElement() && XMLEventUtil.hasLocalName(element = ctx.event.asStartElement(), "object") && XMLEventUtil.hasAttribute(element, "class", CONFLUENCE_USER_IMPL_CLASS)) {
            return this.processUserObject(ctx);
        }
        return this::processUntilUserObject;
    }

    private XMLEventProcessor processUserObject(ProcessingContext processingContext) throws XMLStreamException {
        XMLEvent xmlEvent = processingContext.event;
        if (xmlEvent.isStartElement() && XMLEventUtil.hasLocalName(xmlEvent.asStartElement(), PROPERTY_TAG) && XMLEventUtil.hasAttribute(xmlEvent.asStartElement(), ATTRIBUTE_NAME, EMAIL_ATTRIBUTE_VALUE)) {
            XMLEvent innerEvent;
            String email;
            if (processingContext.reader.peek().isCharacters() && !(email = (innerEvent = processingContext.reader.nextEvent()).asCharacters().getData()).isEmpty() && !IdentityAcceptedEmailValidator.isValid((String)email)) {
                processingContext.addEmail(email);
            }
        } else if (processingContext.event.isEndElement() && XMLEventUtil.hasLocalName(processingContext.event.asEndElement(), "object")) {
            return this::processUntilUserObject;
        }
        return this::processUserObject;
    }

    private static final class ProcessingContext {
        final XMLEvent event;
        final XMLEventReader reader;
        final List<String> emails;

        ProcessingContext(XMLEventReader reader, XMLEvent event, List<String> emails) {
            this.reader = reader;
            this.event = event;
            this.emails = emails;
        }

        void addEmail(String email) {
            this.emails.add(email);
        }
    }

    private static interface XMLEventProcessor
    extends CheckedFunction<ProcessingContext, XMLEventProcessor> {
    }
}

