/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.execution;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.event.Event;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.ClusterInformationService;
import com.atlassian.migration.agent.service.LoggingContextProvider;
import com.atlassian.migration.agent.service.event.ExecuteStepsEvent;
import com.atlassian.migration.agent.service.event.StepAllocation;
import com.atlassian.migration.agent.service.event.StopPlanEvent;
import com.atlassian.migration.agent.service.execution.PlanExecutionService;
import com.atlassian.migration.agent.service.execution.StepExecutor;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.attachment.AttachmentMigrationExecutor;
import com.atlassian.migration.agent.service.stepexecutor.space.SpaceExportExecutor;
import com.atlassian.migration.agent.service.stepexecutor.space.SpaceImportExecutor;
import com.atlassian.migration.agent.service.stepexecutor.space.SpaceUploadExecutor;
import com.atlassian.migration.agent.service.stepexecutor.user.UsersMigrationExecutor;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.google.common.collect.ImmutableMap;
import java.time.Clock;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;

@Singleton
@Named
@ParametersAreNonnullByDefault
public class StepExecutionService {
    private static final Logger log = ContextLoggerFactory.getLogger(StepExecutionService.class);
    static final long HEARTBEAT_INTERVAL = 20000L;
    private final PluginTransactionTemplate ptx;
    private final PlanExecutionService planExecutionService;
    private final StepStore stepStore;
    private final ImmutableMap<StepType, StepExecutor> stepRunners;
    private final ConcurrentMap<String, StepExecution> currentWork;
    private final ReentrantReadWriteLock workLock;
    private final Lock workInexclusiveLock;
    private final Lock workExclusiveLock;
    private final LoggingContextProvider loggingContextProvider;
    private final ExecutorService stepExecutorService;
    private final EventPublisher eventPublisher;
    private final ClusterInformationService clusterInformationService;
    private final MigrationDarkFeaturesManager darkFeaturesManager;
    private final Timer heartbeatTimer;
    private final Clock clock;

    @Inject
    public StepExecutionService(PluginTransactionTemplate ptx, StepStore stepStore, LoggingContextProvider loggingContextProvider, UsersMigrationExecutor usersMigrationExecutor, AttachmentMigrationExecutor attachmentMigrationExecutor, SpaceExportExecutor spaceExportExecutor, SpaceUploadExecutor spaceUploadExecutor, SpaceImportExecutor spaceImportExecutor, PlanExecutionService planExecutionService, EventPublisher eventPublisher, ClusterInformationService clusterInformationService, MigrationDarkFeaturesManager darkFeaturesManager) {
        this(ptx, stepStore, loggingContextProvider, usersMigrationExecutor, attachmentMigrationExecutor, spaceExportExecutor, spaceUploadExecutor, spaceImportExecutor, planExecutionService, eventPublisher, clusterInformationService, darkFeaturesManager, Executors.newCachedThreadPool(), new ReentrantReadWriteLock(), new Timer(), Clock.systemUTC());
    }

    public StepExecutionService(PluginTransactionTemplate ptx, StepStore stepStore, LoggingContextProvider loggingContextProvider, UsersMigrationExecutor usersMigrationExecutor, AttachmentMigrationExecutor attachmentMigrationExecutor, SpaceExportExecutor spaceExportExecutor, SpaceUploadExecutor spaceUploadExecutor, SpaceImportExecutor spaceImportExecutor, PlanExecutionService planExecutionService, EventPublisher eventPublisher, ClusterInformationService clusterInformationService, MigrationDarkFeaturesManager darkFeaturesManager, ExecutorService stepExecutorService, ReentrantReadWriteLock workLock, Timer heartbeatTimer, Clock clock) {
        this.ptx = ptx;
        this.stepStore = stepStore;
        this.loggingContextProvider = loggingContextProvider;
        this.clusterInformationService = clusterInformationService;
        this.darkFeaturesManager = darkFeaturesManager;
        this.currentWork = new ConcurrentHashMap<String, StepExecution>();
        this.workLock = workLock;
        this.workInexclusiveLock = this.workLock.readLock();
        this.workExclusiveLock = this.workLock.writeLock();
        this.planExecutionService = planExecutionService;
        this.eventPublisher = eventPublisher;
        this.stepRunners = ImmutableMap.of((Object)((Object)usersMigrationExecutor.getStepType()), (Object)usersMigrationExecutor, (Object)((Object)attachmentMigrationExecutor.getStepType()), (Object)attachmentMigrationExecutor, (Object)((Object)spaceExportExecutor.getStepType()), (Object)spaceExportExecutor, (Object)((Object)spaceUploadExecutor.getStepType()), (Object)spaceUploadExecutor, (Object)((Object)spaceImportExecutor.getStepType()), (Object)spaceImportExecutor);
        this.stepExecutorService = stepExecutorService;
        this.heartbeatTimer = heartbeatTimer;
        this.clock = clock;
    }

    @PostConstruct
    public void initialise() {
        this.heartbeatTimer.scheduleAtFixedRate((TimerTask)new HeartbeatTask(), 20000L, 20000L);
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void preDestroy() {
        this.heartbeatTimer.cancel();
        this.eventPublisher.unregister((Object)this);
        this.stepExecutorService.shutdown();
    }

    @EventListener
    public void handleExecuteStepsEvent(ExecuteStepsEvent event) {
        try {
            String thisNodeId = this.clusterInformationService.getCurrentNodeId();
            List<StepAllocation> steps = event.getStepAllocations().stream().filter(step -> step.getNodeId().equals(thisNodeId)).collect(Collectors.toList());
            if (!steps.isEmpty()) {
                this.runStepBatch(steps, thisNodeId);
            }
        }
        catch (Exception e) {
            log.error("Failed to handle ExecuteTasksEvent {}", (Object)event, (Object)e);
            throw e;
        }
    }

    @EventListener
    public void handleStopPlanEvent(StopPlanEvent event) {
        try {
            this.stopStepsForPlan(event.getPlanId());
        }
        catch (Exception e) {
            log.error("Failed to handle StopPlanEvent {}", (Object)event, (Object)e);
            throw e;
        }
    }

    @EventListener
    public void handleClusteredEvent(ClusterEventWrapper clusterEventWrapper) {
        Event wrappedEvent = clusterEventWrapper.getEvent();
        if (wrappedEvent instanceof ExecuteStepsEvent) {
            this.handleExecuteStepsEvent((ExecuteStepsEvent)wrappedEvent);
        } else if (wrappedEvent instanceof StopPlanEvent) {
            this.handleStopPlanEvent((StopPlanEvent)wrappedEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runStepBatch(List<StepAllocation> stepBatch, String nodeId) {
        log.info("Running steps: {} on node: {}", stepBatch, (Object)nodeId);
        for (StepAllocation stepAllocation : stepBatch) {
            String stepId = stepAllocation.getStepId();
            this.workInexclusiveLock.lock();
            try {
                Step step = this.ptx.read(() -> this.stepStore.getStep(stepAllocation.getStepId()));
                this.currentWork.compute(stepId, (unused, oldValue) -> {
                    if (oldValue != null) {
                        if (((StepExecution)oldValue).getStepAllocation().getNodeExecutionId().equals(stepAllocation.getNodeExecutionId())) {
                            return oldValue;
                        }
                        log.warn("Step allocator marked the currently running instance of step {} as hung. Stopping the currently running instance of this step (execution {}).", (Object)step.getId(), (Object)((StepExecution)oldValue).stepAllocation.getNodeExecutionId());
                        oldValue.setMarkedAsHung();
                        oldValue.stop();
                    }
                    StepExecution stepExecution = new StepExecution(stepAllocation, StepType.valueOf(step.getType()));
                    stepExecution.start();
                    return stepExecution;
                });
            }
            catch (Exception e) {
                log.error("Failed to execute step: {}", (Object)stepId, (Object)e);
                this.completeStep(stepAllocation, StepResult.failed("Failed to start step.", e), e);
            }
            finally {
                this.workInexclusiveLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopStepsForPlan(String planId) {
        try {
            this.workExclusiveLock.lock();
            List stepIdsForPlan = this.ptx.read(() -> this.stepStore.getStepIdsForPlan(planId));
            for (String stepId : stepIdsForPlan) {
                StepExecution execution = (StepExecution)this.currentWork.get(stepId);
                if (execution == null) continue;
                execution.stop();
            }
        }
        finally {
            this.workExclusiveLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void completeStep(StepAllocation stepAllocation, @Nullable StepResult result, @Nullable Throwable throwable) {
        this.workInexclusiveLock.lock();
        try {
            StepExecution execution = (StepExecution)this.currentWork.get(stepAllocation.getStepId());
            if (execution != null && !execution.isMarkedAsHung().booleanValue()) {
                this.currentWork.remove(stepAllocation.getStepId());
            }
            this.planExecutionService.onStepCompleted(stepAllocation, result, throwable);
        }
        finally {
            this.workInexclusiveLock.unlock();
        }
    }

    @VisibleForTesting
    final class StepExecution {
        private final StepAllocation stepAllocation;
        private final StepType stepType;
        private volatile Future<StepResult> futureStepResult;
        private final AtomicBoolean signalled;
        private final AtomicBoolean started;
        private final AtomicBoolean markedAsHung;

        @VisibleForTesting
        StepExecution(StepAllocation stepAllocation, StepType stepType) {
            this.stepAllocation = stepAllocation;
            this.stepType = stepType;
            this.signalled = new AtomicBoolean(false);
            this.started = new AtomicBoolean(false);
            this.markedAsHung = new AtomicBoolean(false);
        }

        Boolean isMarkedAsHung() {
            return this.markedAsHung.get();
        }

        @VisibleForTesting
        void setMarkedAsHung() {
            this.markedAsHung.compareAndSet(false, true);
        }

        @VisibleForTesting
        AtomicBoolean isStarted() {
            return this.started;
        }

        @VisibleForTesting
        AtomicBoolean isSignalled() {
            return this.signalled;
        }

        @VisibleForTesting
        void start() {
            if (this.started.compareAndSet(false, true)) {
                String stepId = this.stepAllocation.getStepId();
                this.futureStepResult = StepExecutionService.this.stepExecutorService.submit(() -> StepExecutionService.this.loggingContextProvider.forStep(stepId).execute(() -> {
                    if (this.signalled.compareAndSet(false, true)) {
                        StepResult stepResult = null;
                        Throwable throwable = null;
                        try {
                            stepResult = ((StepExecutor)StepExecutionService.this.stepRunners.get((Object)this.stepType)).runStep(stepId);
                        }
                        catch (Throwable t) {
                            throwable = t;
                        }
                        StepExecutionService.this.completeStep(this.stepAllocation, stepResult, throwable);
                        return stepResult;
                    }
                    return StepResult.stopped();
                }));
            }
        }

        private StepAllocation getStepAllocation() {
            return this.stepAllocation;
        }

        @VisibleForTesting
        void stop() {
            if (this.futureStepResult != null) {
                this.futureStepResult.cancel(true);
            }
            if (this.signalled.compareAndSet(false, true)) {
                StepExecutionService.this.completeStep(this.stepAllocation, StepResult.stopped(), null);
            }
        }
    }

    @VisibleForTesting
    final class HeartbeatTask
    extends TimerTask {
        HeartbeatTask() {
        }

        @Override
        public void run() {
            if (StepExecutionService.this.darkFeaturesManager.isSchedulerFixEnabled()) {
                try {
                    List executionIds = StepExecutionService.this.currentWork.values().stream().map(exec -> ((StepExecution)exec).stepAllocation.getNodeExecutionId()).collect(Collectors.toList());
                    if (!executionIds.isEmpty()) {
                        log.info("Writing heart beat for active step executions: {}", executionIds);
                        StepExecutionService.this.ptx.write(() -> StepExecutionService.this.stepStore.setNodeHeartbeat(executionIds, StepExecutionService.this.clock.instant()));
                    }
                }
                catch (Throwable t) {
                    log.error("Failed to heartbeat active tasks.", t);
                }
            }
        }
    }
}

