/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.app.vendorcheck;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.service.check.app.vendorcheck.AppVendorCheckContext;
import com.atlassian.migration.agent.service.check.app.vendorcheck.AppVendorCheckResultDto;
import com.atlassian.migration.agent.service.check.app.vendorcheck.SerializableCsvFileContentDto;
import com.atlassian.migration.agent.service.impl.DisabledCheck;
import com.atlassian.migration.agent.service.impl.MigrationAppAggregatorService;
import com.atlassian.migration.agent.store.CloudSiteStore;
import com.atlassian.migration.app.ContainerType;
import com.atlassian.migration.app.DefaultRegistrar;
import com.atlassian.migration.app.check.Container;
import com.atlassian.migration.app.check.MigrationPlanContext;
import com.atlassian.migration.app.dto.check.AppPreflightCheckResponse;
import com.atlassian.migration.app.dto.check.CheckStatus;
import com.atlassian.migration.app.dto.check.CsvFileContent;
import com.atlassian.migration.app.dto.check.ParentAppPreflightChecksResponse;
import com.atlassian.migration.app.dto.check.ParentPreflightCheckSpec;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class AppVendorChecker
implements Checker<AppVendorCheckContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppVendorChecker.class);
    private static final int ALLOWED_CHECK_LIMIT_PER_APP = 3;
    private final DefaultRegistrar defaultRegistrar;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final CloudSiteStore cloudSiteStore;
    MigrationAppAggregatorService migrationAppAggregatorService;

    public AppVendorChecker(DefaultRegistrar defaultRegistrar, CloudSiteStore cloudSiteStore, MigrationAppAggregatorService migrationAppAggregatorService, MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        this.defaultRegistrar = defaultRegistrar;
        this.cloudSiteStore = cloudSiteStore;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.migrationAppAggregatorService = migrationAppAggregatorService;
    }

    public CheckResult check(AppVendorCheckContext appVendorCheckContext) {
        if (!this.migrationDarkFeaturesManager.appVendorCheckEnabled()) {
            log.info("Returning empty result as App vendor check is disabled.");
            return new CheckResult(true, Collections.emptyMap());
        }
        log.debug("Performing AppVendorCheck");
        Optional<MigrationPlanContext> optionalMigrationPlanContext = this.createMigrationPlanContext(appVendorCheckContext);
        if (!optionalMigrationPlanContext.isPresent()) {
            log.warn("Unable to create MigrationPlanContext from AppVendorCheckContext: {}", (Object)appVendorCheckContext);
            return new CheckResult(true, Collections.emptyMap());
        }
        Set<ParentPreflightCheckSpec> appVendorCheckSpecs = this.getAppsVendorPreflightCheckSpecs(appVendorCheckContext.appKeys);
        if (appVendorCheckSpecs.stream().allMatch(it -> it.getPreflightCheckSpecs().isEmpty())) {
            log.warn("Return empty successful result. No PreflightCheckSpecs retrieved for apps: {}", appVendorCheckContext.appKeys);
            return new CheckResult(true, Collections.emptyMap());
        }
        Set<ParentAppPreflightChecksResponse> parentAppPreflightChecksResponse = this.defaultRegistrar.executeAppVendorPreflightCheck(optionalMigrationPlanContext.get(), appVendorCheckSpecs);
        boolean overallParentAppVendorCheckResponseStatus = parentAppPreflightChecksResponse.stream().allMatch(allAppPreflightCheckResult -> allAppPreflightCheckResult.getAppPreflightCheckResponse().stream().allMatch(it -> it.getStatus().equals((Object)CheckStatus.SUCCESS)));
        Map<String, Object> appVendorCheckResult = this.getAppVendorCheckResult(parentAppPreflightChecksResponse);
        return new CheckResult(overallParentAppVendorCheckResponseStatus, appVendorCheckResult);
    }

    private Optional<MigrationPlanContext> createMigrationPlanContext(AppVendorCheckContext ctx) {
        Set containers = ctx.spaceKeys.stream().map(spaceKey -> new Container(spaceKey, ContainerType.ConfluenceSpace.toString())).collect(Collectors.toSet());
        return this.cloudSiteStore.getByCloudId(ctx.cloudId).map(cloudSite -> {
            try {
                return new MigrationPlanContext(ctx.planId, ctx.planName, new URL(cloudSite.getCloudUrl()), containers);
            }
            catch (MalformedURLException e) {
                log.warn("Retrieved cloudSiteUrl: {} for cloudId: {} is not a valid URL", new Object[]{cloudSite.getCloudUrl(), ctx.cloudId, e});
                return null;
            }
        });
    }

    private Set<ParentPreflightCheckSpec> getAppsVendorPreflightCheckSpecs(Set<String> appKeyList) {
        Set<ParentPreflightCheckSpec> appVendorCheckSpecs;
        Set<ParentPreflightCheckSpec> filteredAppVendorCheckSpecs = appVendorCheckSpecs = this.defaultRegistrar.retrieveAppVendorCheckSpecsFromServerApp(appKeyList);
        if (this.migrationDarkFeaturesManager.appVendorChecksFilterEnabled()) {
            filteredAppVendorCheckSpecs = this.filterDisabledCheckSpecs(appVendorCheckSpecs);
        }
        return filteredAppVendorCheckSpecs.stream().map(this::applyCheckNumberLimitOnAppChecks).collect(Collectors.toSet());
    }

    private Set<ParentPreflightCheckSpec> filterDisabledCheckSpecs(Set<ParentPreflightCheckSpec> appVendorCheckSpecs) {
        Set<DisabledCheck> disabledChecks = this.migrationAppAggregatorService.getDisabledChecksFromAppAggregator(appVendorCheckSpecs.stream().map(ParentPreflightCheckSpec::getServerAppKey).collect(Collectors.toSet()));
        Map disabledChecksMap = disabledChecks.stream().collect(Collectors.groupingBy(DisabledCheck::getServerAppKey, Collectors.toSet()));
        return appVendorCheckSpecs.stream().map(appChecks -> {
            Set disabledChecksOfApp = (Set)disabledChecksMap.get(appChecks.getServerAppKey());
            Set enabledChecks = disabledChecksOfApp != null && !disabledChecksOfApp.isEmpty() ? appChecks.getPreflightCheckSpecs().stream().filter(eachCheck -> disabledChecksOfApp.stream().noneMatch(disabledCheck -> disabledCheck.getCheckIds().contains(eachCheck.getPreflightCheckId()))).collect(Collectors.toSet()) : appChecks.getPreflightCheckSpecs();
            return new ParentPreflightCheckSpec(appChecks.getServerAppKey(), enabledChecks);
        }).collect(Collectors.toSet());
    }

    private ParentPreflightCheckSpec applyCheckNumberLimitOnAppChecks(ParentPreflightCheckSpec parentPreflightCheckSpec) {
        Set checksIncluded = parentPreflightCheckSpec.getPreflightCheckSpecs().stream().limit(3L).collect(Collectors.toSet());
        HashSet checksSkipped = new HashSet();
        parentPreflightCheckSpec.getPreflightCheckSpecs().removeIf(preflightCheckSpec -> {
            if (!checksIncluded.contains(preflightCheckSpec)) {
                checksSkipped.add(preflightCheckSpec);
                return true;
            }
            return false;
        });
        if (!checksSkipped.isEmpty()) {
            log.warn("App [{}] has provided more checks [{}] than allowed limit: {}. Some checks may not run..", new Object[]{parentPreflightCheckSpec.getServerAppKey(), parentPreflightCheckSpec.getPreflightCheckSpecs().size(), 3});
            log.warn("App [{}] : checks skipped {} ", (Object)parentPreflightCheckSpec.getServerAppKey(), checksSkipped);
        }
        log.debug("App [{}] : checks included: {} ", (Object)parentPreflightCheckSpec.getServerAppKey(), checksIncluded);
        return new ParentPreflightCheckSpec(parentPreflightCheckSpec.getServerAppKey(), checksIncluded);
    }

    private Map<String, Object> getAppVendorCheckResult(Set<ParentAppPreflightChecksResponse> parentAppVendorCheckResponse) {
        return parentAppVendorCheckResponse.stream().collect(Collectors.toMap(ParentAppPreflightChecksResponse::getServerAppKey, eachParentAppVendorCheckResponse -> eachParentAppVendorCheckResponse.getAppPreflightCheckResponse().stream().collect(Collectors.toMap(AppPreflightCheckResponse::getCheckId, appPreflightCheckResponse -> new AppVendorCheckResultDto(appPreflightCheckResponse.getTitle(), appPreflightCheckResponse.getStepsToResolve(), appPreflightCheckResponse.getStatus(), appPreflightCheckResponse.getCsvFileContent() != null, appPreflightCheckResponse.getCheckId(), this.getSerialisedCsvContent(appPreflightCheckResponse.getCsvFileContent()))))));
    }

    private SerializableCsvFileContentDto getSerialisedCsvContent(CsvFileContent csvFileContent) {
        if (csvFileContent != null) {
            return new SerializableCsvFileContentDto(csvFileContent.getColumnHeaders(), csvFileContent.getRows());
        }
        return new SerializableCsvFileContentDto(null, null);
    }
}

