/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.copyspace.watcher;

import com.atlassian.confluence.event.events.content.page.PageCopyEvent;
import com.atlassian.confluence.pages.persistence.dao.bulk.copy.PageCopyOptions;
import com.atlassian.confluence.plugin.copyspace.chain.CopyHandler;
import com.atlassian.confluence.plugin.copyspace.context.CopySpaceContext;
import com.atlassian.confluence.plugin.copyspace.service.ContextHolder;
import com.atlassian.confluence.plugin.copyspace.util.ConfluenceApiUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventListenerRegistrar;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="copyPageEventWatcher")
public class CopyPageEventWatcher {
    private final EventListenerRegistrar eventListenerRegistrar;
    private final List<CopyHandler> copyHandlers;
    private final ContextHolder contextHolder;

    @Autowired
    public CopyPageEventWatcher(@ComponentImport(value="eventPublisher") EventListenerRegistrar eventListenerRegistrar, List<CopyHandler> copyHandlers, ContextHolder contextHolder) {
        this.eventListenerRegistrar = eventListenerRegistrar;
        this.copyHandlers = copyHandlers;
        this.contextHolder = contextHolder;
    }

    @PostConstruct
    public void registerEventListener() {
        this.eventListenerRegistrar.register((Object)this);
    }

    @PreDestroy
    public void unregisterEventListener() {
        this.eventListenerRegistrar.unregister((Object)this);
    }

    @EventListener
    public void onEvent(PageCopyEvent event) {
        boolean isContextUuidEmpty;
        if (!ConfluenceApiUtils.isCallerIdSupported()) {
            return;
        }
        PageCopyOptions pageCopyOptions = event.getPageCopyOptions();
        CopySpaceContext context = this.contextHolder.getContext();
        boolean isRequestIdEmpty = pageCopyOptions == null || StringUtils.isEmpty((CharSequence)pageCopyOptions.getRequestId());
        boolean bl = isContextUuidEmpty = context == null || StringUtils.isEmpty((CharSequence)context.getUuid());
        if (isRequestIdEmpty || isContextUuidEmpty || !context.getUuid().equals(pageCopyOptions.getRequestId())) {
            return;
        }
        for (CopyHandler copyHandler : this.copyHandlers) {
            copyHandler.checkAndCopy(event);
        }
    }
}

