/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.copyspace.task;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.plugin.copyspace.api.event.ExecutionFailureDescriptor;
import com.atlassian.confluence.plugin.copyspace.context.CopySpaceContext;
import com.atlassian.confluence.plugin.copyspace.event.SpaceCopyEvent;
import com.atlassian.confluence.plugin.copyspace.exception.CopySpaceFlowException;
import com.atlassian.confluence.plugin.copyspace.rest.CopySpaceRequest;
import com.atlassian.confluence.plugin.copyspace.service.BlogPostService;
import com.atlassian.confluence.plugin.copyspace.service.ContextHolder;
import com.atlassian.confluence.plugin.copyspace.service.CopySpaceContextService;
import com.atlassian.confluence.plugin.copyspace.service.PageService;
import com.atlassian.confluence.plugin.copyspace.service.SidebarLinkCopier;
import com.atlassian.confluence.plugin.copyspace.service.SpaceService;
import com.atlassian.confluence.plugin.copyspace.util.EventFactory;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.transaction.TransactionTemplate;

public class BulkCopySpaceLongRunningTask
extends ConfluenceAbstractLongRunningTask {
    public static final String TASK_NAME = "Copy space long running task";
    private static final String BANDANA_KEY_COPYING_SPACE_KEY = "copyspace.copier.spacekey";
    private final CopySpaceRequest copySpaceRequest;
    private final TransactionTemplate transactionTemplate;
    private final BlogPostService blogPostService;
    private final PageService pageService;
    private final SpaceService spaceService;
    private final ContextHolder contextHolder;
    private final CopySpaceContextService copySpaceContextService;
    private final EventPublisher eventPublisher;
    private final SidebarLinkCopier sidebarLinkCopier;
    private final I18NBean i18NBean;
    private final BandanaManager bandanaManager;

    public BulkCopySpaceLongRunningTask(CopySpaceRequest copySpaceRequest, TransactionTemplate transactionTemplate, BlogPostService blogPostService, PageService pageService, SpaceService spaceService, ContextHolder contextHolder, CopySpaceContextService copySpaceContextService, EventPublisher eventPublisher, SidebarLinkCopier sidebarLinkCopier, I18NBeanFactory i18nBeanFactory, BandanaManager bandanaManager) {
        this.copySpaceRequest = copySpaceRequest;
        this.transactionTemplate = transactionTemplate;
        this.blogPostService = blogPostService;
        this.pageService = pageService;
        this.spaceService = spaceService;
        this.contextHolder = contextHolder;
        this.copySpaceContextService = copySpaceContextService;
        this.eventPublisher = eventPublisher;
        this.sidebarLinkCopier = sidebarLinkCopier;
        this.i18NBean = i18nBeanFactory.getI18NBean();
        this.bandanaManager = bandanaManager;
    }

    public String getName() {
        return TASK_NAME;
    }

    protected void runInternal() {
        try {
            this.copySpaceContextService.initializeContext(this.copySpaceRequest);
            this.progress = this.contextHolder.getContext().getProgressMeter();
            this.eventPublisher.publish((Object)EventFactory.createCopySpaceStartedEvent(this.contextHolder.getContext()));
            this.execute();
            this.eventPublisher.publish((Object)EventFactory.createCopySpaceSuccessEvent(this.contextHolder.getContext()));
        }
        catch (CopySpaceFlowException e) {
            log.error("Error: ", (Throwable)e);
            this.eventPublisher.publish((Object)EventFactory.createCopySpaceFailedEvent(this.contextHolder.getContext(), e.getFailureDescriptor()));
            this.contextHolder.getContext().getProgressMeter().setCompletedSuccessfully(false);
            throw e;
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
            this.eventPublisher.publish((Object)EventFactory.createCopySpaceFailedEvent(this.contextHolder.getContext(), ExecutionFailureDescriptor.unknown()));
            this.contextHolder.getContext().getProgressMeter().setCompletedSuccessfully(false);
            throw e;
        }
        finally {
            this.contextHolder.cleanUp();
        }
    }

    protected final void execute() {
        this.progress.setPercentage(0);
        this.progress.setStatus(this.i18NBean.getText("copyspace.progress.message.started"));
        CopySpaceContext context = this.contextHolder.getContext();
        this.spaceService.createNewSpace();
        if (context.isCopyPages()) {
            this.progress.setStatus(this.i18NBean.getText("copyspace.progress.message.pages.started"));
            this.pageService.copyPages();
        }
        if (context.isCopyBlogPosts()) {
            this.progress.setStatus(this.i18NBean.getText("copyspace.progress.message.blogpost.started"));
            this.blogPostService.copyBlogPosts();
        }
        this.sidebarLinkCopier.copyNonRewritableLinks(context.getOriginalSpaceKey(), context.getTargetSpaceKey());
        this.transactionTemplate.execute(() -> {
            this.eventPublisher.publish((Object)new SpaceCopyEvent((Object)this, this.spaceService.getTargetSpace(), context.isCopyComments(), context.isCopyLabels(), context.isCopyAttachments(), context.isCopyMetadata(), context.isCopyBlogPosts(), context.isCopyPages()));
            return null;
        });
        this.progress.setStatus(this.i18NBean.getText("copyspace.progress.message.operation.completed"));
        this.progress.setPercentage(100);
        this.progress.setCompletedSuccessfully(true);
        this.recordCopyingSpaceAgainstCopiedSpace(context);
    }

    private void recordCopyingSpaceAgainstCopiedSpace(CopySpaceContext context) {
        this.transactionTemplate.execute(() -> {
            ConfluenceBandanaContext bandanaContext = new ConfluenceBandanaContext(this.spaceService.getTargetSpace());
            this.bandanaManager.setValue((BandanaContext)bandanaContext, BANDANA_KEY_COPYING_SPACE_KEY, (Object)context.getOriginalSpaceKey());
            return null;
        });
    }
}

