/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.copyspace.service.impl;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.labels.SpaceLabelManager;
import com.atlassian.confluence.plugin.copyspace.context.CopySpaceContext;
import com.atlassian.confluence.plugin.copyspace.exception.CopySpaceException;
import com.atlassian.confluence.plugin.copyspace.service.ContextHolder;
import com.atlassian.confluence.plugin.copyspace.service.SpaceService;
import com.atlassian.confluence.plugin.copyspace.util.MetadataCopier;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import java.util.Date;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="spaceServiceImpl")
public class SpaceServiceImpl
implements SpaceService {
    private static final Logger log = LoggerFactory.getLogger(SpaceServiceImpl.class);
    private final SpaceManager spaceManager;
    private final TransactionTemplate transactionTemplate;
    private final ContextHolder contextHolder;
    private final SpacePermissionManager spacePermissionManager;
    private final SpaceLabelManager spaceLabelManager;

    @Autowired
    public SpaceServiceImpl(@ComponentImport SpaceManager spaceManager, @ComponentImport TransactionTemplate transactionTemplate, ContextHolder contextHolder, @ComponentImport SpacePermissionManager spacePermissionManager, @ComponentImport SpaceLabelManager spaceLabelManager) {
        this.spaceManager = spaceManager;
        this.transactionTemplate = transactionTemplate;
        this.contextHolder = contextHolder;
        this.spacePermissionManager = spacePermissionManager;
        this.spaceLabelManager = spaceLabelManager;
    }

    @Override
    public Space createNewSpace() {
        CopySpaceContext context = this.contextHolder.getContext();
        return (Space)this.transactionTemplate.execute(() -> {
            Space originalSpace = this.spaceManager.getSpace(context.getOriginalSpaceKey());
            Space newSpace = this.spaceManager.createPrivateSpace(context.getTargetSpaceKey(), context.getTargetSpaceName(), originalSpace.getDescription().getBodyAsString(), (User)AuthenticatedUserThreadLocal.get());
            newSpace.setSpaceStatus(originalSpace.getSpaceStatus());
            boolean keepMetadata = context.isCopyMetadata();
            this.copySpacePermissions(originalSpace, newSpace, keepMetadata);
            if (keepMetadata) {
                MetadataCopier.copyEntityMetadata((ConfluenceEntityObject)originalSpace, (ConfluenceEntityObject)newSpace);
                newSpace.setClock(() -> ((Space)originalSpace).getLastModificationDate());
            }
            if (!context.isCopyPages()) {
                newSpace.getHomePage().setSpace(null);
                newSpace.setHomePage(null);
            }
            this.spaceManager.saveSpace(newSpace);
            if (context.isCopyLabels()) {
                this.copySpaceLabels(originalSpace, newSpace);
            }
            return newSpace;
        });
    }

    private void copySpaceLabels(Space originalSpace, Space newSpace) {
        originalSpace.getDescription().getLabels().forEach(label -> {
            try {
                this.spaceLabelManager.addLabel(newSpace, label.getName());
            }
            catch (Exception e) {
                log.error("Error copying label: ", (Throwable)e);
            }
        });
    }

    @Override
    public Space getTargetSpace() {
        CopySpaceContext context = this.contextHolder.getContext();
        return this.spaceManager.getSpace(context.getTargetSpaceKey());
    }

    @Override
    public Optional<Long> getSpaceId(String spaceKey) {
        return Optional.ofNullable(this.spaceManager.getSpace(spaceKey)).flatMap(space -> Optional.of(space.getId()));
    }

    private void copySpacePermissions(Space originalSpace, Space newSpace, Boolean keepMetaData) {
        for (SpacePermission originalPermission : originalSpace.getPermissions()) {
            SpacePermission spacePermission;
            if (originalPermission.isUserPermission()) {
                spacePermission = SpacePermission.createUserSpacePermission((String)originalPermission.getType(), (Space)newSpace, (ConfluenceUser)originalPermission.getUserSubject());
            } else if (originalPermission.isGroupPermission()) {
                spacePermission = SpacePermission.createGroupSpacePermission((String)originalPermission.getType(), (Space)newSpace, (String)originalPermission.getGroup());
            } else if (originalPermission.isAnonymousPermission()) {
                spacePermission = SpacePermission.createAnonymousSpacePermission((String)originalPermission.getType(), (Space)newSpace);
            } else if (originalPermission.isAuthenticatedUsersPermission()) {
                spacePermission = SpacePermission.createAuthenticatedUsersSpacePermission((String)originalPermission.getType(), (Space)newSpace);
            } else {
                throw new CopySpaceException("Permission type didn't identify. Permission id:" + originalPermission.getId());
            }
            newSpace.addPermission(spacePermission);
            this.spacePermissionManager.savePermission(spacePermission);
            if (keepMetaData.booleanValue()) {
                MetadataCopier.copyEntityMetadata((ConfluenceEntityObject)originalPermission, (ConfluenceEntityObject)spacePermission);
                continue;
            }
            spacePermission.setCreator(newSpace.getCreator());
            spacePermission.setCreationDate(new Date());
            spacePermission.setLastModifier(newSpace.getCreator());
            spacePermission.setLastModificationDate(new Date());
        }
    }
}

