/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.copyspace.service.impl;

import com.atlassian.confluence.api.model.content.Label;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.content.ContentLabelService;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.plugin.copyspace.service.LabelService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="labelServiceImpl")
public class LabelServiceImpl
implements LabelService {
    private static final Logger log = LoggerFactory.getLogger(LabelServiceImpl.class);
    private final ContentLabelService contentLabelService;

    @Autowired
    public LabelServiceImpl(@ComponentImport @Qualifier(value="apiContentLabelService") ContentLabelService contentLabelService) {
        this.contentLabelService = contentLabelService;
    }

    @Override
    public void copyBlogPostLabels(long originalBlogPostId, BlogPost copy) {
        int offset = 0;
        boolean hasMoreLabels = false;
        do {
            List<Object> originalLabels;
            if ((originalLabels = this.findBatchedLabelsByBlogPostId(originalBlogPostId, offset)).size() == 0) {
                return;
            }
            if (originalLabels.size() > 99) {
                hasMoreLabels = true;
                originalLabels = originalLabels.stream().limit(99L).collect(Collectors.toList());
            }
            this.contentLabelService.addLabels(ContentId.of((long)copy.getId()), originalLabels);
            log.debug("Copy labels operation. Labels batch from {} to {} successfully copied.", (Object)(offset + 1), (Object)(offset + originalLabels.size()));
            offset += 99;
        } while (hasMoreLabels);
    }

    private List<Label> findBatchedLabelsByBlogPostId(long originalBlogPostId, int offset) {
        List<Label.Prefix> labelTypes = Arrays.asList(Label.Prefix.system, Label.Prefix.global, Label.Prefix.team);
        return this.contentLabelService.getLabels(ContentId.of((long)originalBlogPostId), labelTypes, (PageRequest)new SimplePageRequest(offset, 100)).getResults();
    }
}

