/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.copyspace.rest;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.plugin.copyspace.rest.CopySpaceRequest;
import com.atlassian.confluence.plugin.copyspace.service.BlogPostService;
import com.atlassian.confluence.plugin.copyspace.service.ContextHolder;
import com.atlassian.confluence.plugin.copyspace.service.CopySpaceContextService;
import com.atlassian.confluence.plugin.copyspace.service.PageService;
import com.atlassian.confluence.plugin.copyspace.service.SidebarLinkCopier;
import com.atlassian.confluence.plugin.copyspace.service.SpaceService;
import com.atlassian.confluence.plugin.copyspace.service.ValidationService;
import com.atlassian.confluence.plugin.copyspace.task.BulkCopySpaceLongRunningTask;
import com.atlassian.confluence.plugin.copyspace.util.ConfluenceApiUtils;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import com.google.common.collect.ImmutableMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
public class CopySpaceResource {
    private final TransactionTemplate transactionTemplate;
    private final LongRunningTaskManager longRunningTaskManager;
    private final BlogPostService blogPostService;
    private final PageService pageService;
    private final ContextHolder contextHolder;
    private final CopySpaceContextService copySpaceContextService;
    private final EventPublisher eventPublisher;
    private final SidebarLinkCopier sidebarLinkCopier;
    private final SpaceService spaceService;
    private final ValidationService validationService;
    private final I18NBeanFactory i18nBeanFactory;
    private final BandanaManager bandanaManager;

    public CopySpaceResource(@ComponentImport TransactionTemplate transactionTemplate, @ComponentImport LongRunningTaskManager longRunningTaskManager, BlogPostService blogPostService, PageService pageService, ContextHolder contextHolder, CopySpaceContextService copySpaceContextService, @ComponentImport(value="eventPublisher") EventPublisher eventPublisher, SidebarLinkCopier sidebarLinkCopier, SpaceService spaceService, ValidationService validationService, @ComponentImport I18NBeanFactory i18nBeanFactory, @ComponentImport BandanaManager bandanaManager) {
        this.transactionTemplate = transactionTemplate;
        this.longRunningTaskManager = longRunningTaskManager;
        this.blogPostService = blogPostService;
        this.pageService = pageService;
        this.contextHolder = contextHolder;
        this.copySpaceContextService = copySpaceContextService;
        this.eventPublisher = eventPublisher;
        this.sidebarLinkCopier = sidebarLinkCopier;
        this.spaceService = spaceService;
        this.validationService = validationService;
        this.i18nBeanFactory = i18nBeanFactory;
        this.bandanaManager = bandanaManager;
    }

    @POST
    @Path(value="copy")
    public Response copySpace(CopySpaceRequest request) throws ServiceException {
        this.validationService.validate(request);
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        BulkCopySpaceLongRunningTask bulkCopySpaceLongRunningTask = new BulkCopySpaceLongRunningTask(request, this.transactionTemplate, this.blogPostService, this.pageService, this.spaceService, this.contextHolder, this.copySpaceContextService, this.eventPublisher, this.sidebarLinkCopier, this.i18nBeanFactory, this.bandanaManager);
        LongRunningTaskId taskId = this.longRunningTaskManager.startLongRunningTask((User)user, (LongRunningTask)bulkCopySpaceLongRunningTask);
        return Response.ok((Object)ImmutableMap.of((Object)"taskId", (Object)taskId.asLongTaskId())).build();
    }

    @GET
    @Path(value="copy/compatibility")
    public Response isCompatibleWithTheConfluence() {
        return Response.ok((Object)ImmutableMap.of((Object)"isCompatible", (Object)ConfluenceApiUtils.isCallerIdSupported())).build();
    }
}

