/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.copyspace.validator;

import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.plugin.copyspace.rest.CopySpaceRequest;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.johnson.util.StringUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component(value="targetSpaceNameNotEmptyValidator")
@Order(value=8)
public class TargetSpaceNameNotEmptyValidator
implements Consumer<CopySpaceRequest> {
    private final I18NBeanFactory i18nBeanFactory;

    @Autowired
    public TargetSpaceNameNotEmptyValidator(@ComponentImport I18NBeanFactory i18nBeanFactory) {
        this.i18nBeanFactory = i18nBeanFactory;
    }

    @Override
    public void accept(CopySpaceRequest request) {
        if (StringUtils.isBlank((String)request.getNewName())) {
            throw new BadRequestException(this.i18nBeanFactory.getI18NBean().getText("copyspace.validation.space.name.empty"));
        }
    }
}

