/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.copyspace.validator;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.exceptions.ReadOnlyException;
import com.atlassian.confluence.plugin.copyspace.rest.CopySpaceRequest;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component(value="readOnlyModeValidator")
@Order(value=2)
public class ReadOnlyModeValidator
implements Consumer<CopySpaceRequest> {
    private final AccessModeService accessModeService;
    private final I18NBeanFactory i18nBeanFactory;

    @Autowired
    public ReadOnlyModeValidator(@ComponentImport AccessModeService accessModeService, @ComponentImport I18NBeanFactory i18nBeanFactory) {
        this.accessModeService = accessModeService;
        this.i18nBeanFactory = i18nBeanFactory;
    }

    @Override
    public void accept(CopySpaceRequest request) {
        if (this.accessModeService.shouldEnforceReadOnlyAccess()) {
            throw new ReadOnlyException(this.i18nBeanFactory.getI18NBean().getText("read.only.mode.default.error.short.message"));
        }
    }
}

