/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.copyspace.validator;

import com.atlassian.confluence.api.service.exceptions.PermissionException;
import com.atlassian.confluence.plugin.copyspace.rest.CopySpaceRequest;
import com.atlassian.confluence.plugin.copyspace.service.PermissionCheckService;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component(value="permissionValidator")
@Order(value=5)
public class PermissionValidator
implements Consumer<CopySpaceRequest> {
    private final SpaceManager spaceManager;
    private final I18NBeanFactory i18nBeanFactory;
    private final PermissionCheckService permissionCheckService;

    @Autowired
    public PermissionValidator(@ComponentImport SpaceManager spaceManager, @ComponentImport I18NBeanFactory i18nBeanFactory, PermissionCheckService permissionCheckService) {
        this.spaceManager = spaceManager;
        this.i18nBeanFactory = i18nBeanFactory;
        this.permissionCheckService = permissionCheckService;
    }

    @Override
    public void accept(CopySpaceRequest request) {
        Space space;
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.permissionCheckService.canInitiateSpaceCopy((User)user, space = this.spaceManager.getSpace(request.getOldKey()))) {
            throw new PermissionException(this.i18nBeanFactory.getI18NBean().getText("copyspace.validation.permission.violation"));
        }
    }
}

