/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.copyspace.validator;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.plugin.copyspace.rest.CopySpaceRequest;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Optional;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component(value="originalSpaceKeyExistenceValidator")
@Order(value=4)
public class OriginalSpaceKeyExistenceValidator
implements Consumer<CopySpaceRequest> {
    private final SpaceService spaceService;
    private final I18NBeanFactory i18nBeanFactory;

    @Autowired
    public OriginalSpaceKeyExistenceValidator(@ComponentImport @Qualifier(value="apiSpaceService") SpaceService spaceService, @ComponentImport I18NBeanFactory i18nBeanFactory) {
        this.spaceService = spaceService;
        this.i18nBeanFactory = i18nBeanFactory;
    }

    @Override
    public void accept(CopySpaceRequest request) {
        Optional space = this.spaceService.find(new Expansion[0]).withKeys(new String[]{request.getOldKey()}).fetch();
        if (!space.isPresent()) {
            throw new BadRequestException(this.i18nBeanFactory.getI18NBean().getText("copyspace.validation.original.space.key.does.not.exist"));
        }
    }
}

