/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.copyspace.service.impl;

import com.atlassian.confluence.content.render.xhtml.storage.link.StorageLinkConstants;
import com.atlassian.confluence.content.render.xhtml.storage.resource.identifiers.StorageResourceIdentifierConstants;
import com.atlassian.confluence.plugin.copyspace.context.CopySpaceContext;
import com.atlassian.confluence.plugin.copyspace.service.ContentRewriter;
import com.atlassian.confluence.plugin.copyspace.service.impl.AbstractChainedContentRewriter;
import com.atlassian.confluence.plugin.copyspace.util.XmlEventUtils;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang.StringUtils;

public class SpaceReferenceReplacementRewriter
extends AbstractChainedContentRewriter {
    private static final String IS_LINK_PROP = "isLink";
    private static final String IS_ATTACHMENT_PROP = "isAttachment";
    private final String oldSpaceKey;
    private final String newSpaceKey;
    private final XMLEventFactory xmlEventFactory;
    private final CopySpaceContext context;
    private final Set<QName> supportedResources;

    public SpaceReferenceReplacementRewriter(String oldSpaceKey, String newSpaceKey, XMLEventFactory xmlEventFactory, CopySpaceContext context, ContentRewriter nextContentRewriter) {
        super(nextContentRewriter);
        this.oldSpaceKey = oldSpaceKey;
        this.newSpaceKey = newSpaceKey;
        this.xmlEventFactory = xmlEventFactory;
        this.context = context;
        this.supportedResources = this.buildSupportedResourcesSet();
    }

    @Override
    public void updateContextInternal(XMLEvent nextEvent, Properties props) {
        if (nextEvent.isStartElement()) {
            if (StorageLinkConstants.LINK_ELEMENT.equals(nextEvent.asStartElement().getName())) {
                props.put(IS_LINK_PROP, Boolean.TRUE.toString());
            }
            if (StorageResourceIdentifierConstants.ATTACHMENT_RESOURCE_QNAME.equals(nextEvent.asStartElement().getName())) {
                props.put(IS_ATTACHMENT_PROP, Boolean.TRUE.toString());
            }
        }
    }

    @Override
    public XMLEvent updateXmlEventInternal(XMLEvent nextEvent, Properties props) {
        if (nextEvent.isStartElement() && this.isWrappedInLink(props) && this.isWrappedWithAttachment(props) && this.isSupportedResourceWithMatchingSpace(nextEvent.asStartElement())) {
            StartElement nextElement = nextEvent.asStartElement();
            Attribute newAttribute = this.xmlEventFactory.createAttribute(StorageResourceIdentifierConstants.SPACEKEY_ATTRIBUTE_QNAME, this.newSpaceKey);
            List<Attribute> attributesToWrite = XmlEventUtils.getExtendedAttributes(nextElement, newAttribute);
            return this.xmlEventFactory.createStartElement(nextElement.getName(), attributesToWrite.iterator(), null);
        }
        return nextEvent;
    }

    private boolean isWrappedWithAttachment(Properties props) {
        return !Boolean.parseBoolean(props.getProperty(IS_ATTACHMENT_PROP)) || this.context.isCopyAttachments();
    }

    private boolean isWrappedInLink(Properties props) {
        return Boolean.parseBoolean(props.getProperty(IS_LINK_PROP));
    }

    private boolean isSupportedResourceWithMatchingSpace(StartElement startElement) {
        if (!this.supportedResources.contains(startElement.getName())) {
            return false;
        }
        Attribute spaceKeyAttr = startElement.getAttributeByName(StorageResourceIdentifierConstants.SPACEKEY_ATTRIBUTE_QNAME);
        return spaceKeyAttr == null || StringUtils.isEmpty((String)spaceKeyAttr.getValue()) || this.oldSpaceKey.equals(spaceKeyAttr.getValue());
    }

    private Set<QName> buildSupportedResourcesSet() {
        HashSet supportedResources = Sets.newHashSet();
        if (this.context.isCopyBlogPosts()) {
            supportedResources.add(StorageResourceIdentifierConstants.BLOG_POST_RESOURCE_QNAME);
        }
        if (this.context.isCopyPages()) {
            supportedResources.add(StorageResourceIdentifierConstants.PAGE_RESOURCE_QNAME);
        }
        return supportedResources;
    }
}

