/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.copyspace.service.impl;

import com.atlassian.confluence.plugin.copyspace.service.ContextHolder;
import com.atlassian.confluence.plugin.copyspace.service.ProgressMeterFactory;
import com.atlassian.confluence.util.SubProgressMeter;
import com.atlassian.core.util.ProgressMeter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="progressMeterFactoryImpl")
public class ProgressMeterFactoryImpl
implements ProgressMeterFactory {
    private final ContextHolder contextHolder;

    @Autowired
    public ProgressMeterFactoryImpl(ContextHolder contextHolder) {
        this.contextHolder = contextHolder;
    }

    @Override
    public ProgressMeter createSubProgressMeter(int itemsToProcess) {
        ProgressMeter rootProgressMeter = this.contextHolder.getContext().getProgressMeter();
        int totalItemsToProcess = rootProgressMeter.getTotal();
        if (itemsToProcess < 0 || itemsToProcess > totalItemsToProcess || totalItemsToProcess == 0) {
            throw new IllegalArgumentException("Invalid itemsToProcess value passed. Items to process in this batch: " + itemsToProcess + ". Total items to process: " + totalItemsToProcess);
        }
        float outerPercentage = (float)itemsToProcess / (float)totalItemsToProcess;
        return new SubProgressMeter(rootProgressMeter, outerPercentage, itemsToProcess);
    }
}

