/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.copyspace.service.impl;

import com.atlassian.confluence.plugin.copyspace.service.PermissionCheckService;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="permissionCheckServiceImpl")
public class PermissionCheckServiceImpl
implements PermissionCheckService {
    private final PermissionManager permissionManager;

    @Autowired
    public PermissionCheckServiceImpl(@ComponentImport PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    @Override
    public boolean canInitiateSpaceCopy(User user, Space space) {
        boolean canCreateSpaces = this.permissionManager.hasCreatePermission(user, PermissionManager.TARGET_APPLICATION, Space.class);
        boolean canAdministerThisSpace = this.permissionManager.hasPermission(user, Permission.ADMINISTER, (Object)space);
        return canCreateSpaces && canAdministerThisSpace;
    }
}

