/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.copyspace.service.impl;

import com.atlassian.confluence.content.render.xhtml.ResettableXmlEventReader;
import com.atlassian.confluence.content.render.xhtml.StaxUtils;
import com.atlassian.confluence.content.render.xhtml.XmlEventReaderFactory;
import com.atlassian.confluence.content.render.xhtml.XmlOutputFactory;
import com.atlassian.confluence.plugin.copyspace.context.CopySpaceContext;
import com.atlassian.confluence.plugin.copyspace.exception.CopySpaceRelinkException;
import com.atlassian.confluence.plugin.copyspace.service.ContentRewriter;
import com.atlassian.confluence.plugin.copyspace.service.ContextHolder;
import com.atlassian.confluence.plugin.copyspace.service.LinksUpdater;
import com.atlassian.confluence.plugin.copyspace.service.impl.ExpandRelativeReferencesRewriter;
import com.atlassian.confluence.plugin.copyspace.service.impl.SpaceReferenceReplacementRewriter;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="linksUpdaterImpl")
public class LinksUpdaterImpl
implements LinksUpdater {
    private final XmlEventReaderFactory xmlEventReaderFactory;
    private final XmlOutputFactory xmlOutputFactory;
    private final XMLEventFactory xmlEventFactory;
    private final ContextHolder contextHolder;

    @Autowired
    public LinksUpdaterImpl(@ComponentImport XmlEventReaderFactory xmlEventReaderFactory, @ComponentImport @Qualifier(value="xmlFragmentOutputFactory") XmlOutputFactory xmlFragmentOutputFactory, ContextHolder contextHolder) {
        this.xmlEventReaderFactory = xmlEventReaderFactory;
        this.contextHolder = contextHolder;
        this.xmlOutputFactory = xmlFragmentOutputFactory;
        this.xmlEventFactory = XMLEventFactory.newInstance();
    }

    @Override
    public String rewriteLinks(String body) {
        CopySpaceContext context = this.contextHolder.getContext();
        SpaceReferenceReplacementRewriter secondRewriter = new SpaceReferenceReplacementRewriter(context.getOriginalSpaceKey(), context.getTargetSpaceKey(), this.xmlEventFactory, context, null);
        ExpandRelativeReferencesRewriter firstRewriter = new ExpandRelativeReferencesRewriter(context.getOriginalSpaceKey(), this.xmlEventFactory, secondRewriter);
        return this.applyRewriter(body, firstRewriter);
    }

    private String applyRewriter(String content, ContentRewriter rewriter) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        ResettableXmlEventReader xmlEventReader = null;
        XMLEventWriter xmlEventWriter = null;
        try {
            xmlEventReader = new ResettableXmlEventReader(this.xmlEventReaderFactory.createStorageXmlEventReader((Reader)new StringReader(content)));
            xmlEventWriter = this.xmlOutputFactory.createXMLEventWriter((Writer)stringWriter);
            while (xmlEventReader.hasNext()) {
                if (xmlEventReader.peek().isStartElement()) {
                    StartElement startElement = xmlEventReader.peek().asStartElement();
                    Properties properties = new Properties();
                    while (xmlEventReader.hasNext() && this.hasElementsToProcess((XMLEventReader)xmlEventReader, startElement)) {
                        XMLEvent currentEvent = xmlEventReader.nextEvent();
                        rewriter.updateElementContext(currentEvent, properties);
                        currentEvent = rewriter.updateXmlEvent(currentEvent, properties);
                        xmlEventWriter.add(currentEvent);
                    }
                    continue;
                }
                xmlEventWriter.add(xmlEventReader.nextEvent());
            }
        }
        catch (Exception e) {
            try {
                throw new CopySpaceRelinkException(e);
            }
            catch (Throwable throwable) {
                StaxUtils.closeQuietly(xmlEventReader);
                StaxUtils.closeQuietly(xmlEventWriter);
                throw throwable;
            }
        }
        StaxUtils.closeQuietly((XMLEventReader)xmlEventReader);
        StaxUtils.closeQuietly((XMLEventWriter)xmlEventWriter);
        return stringWriter.toString();
    }

    private boolean hasElementsToProcess(XMLEventReader reader, StartElement startElement) throws XMLStreamException {
        return !reader.peek().isEndElement() || !reader.peek().asEndElement().getName().equals(startElement.getName());
    }
}

