/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.copyspace.service.impl;

import com.atlassian.confluence.content.render.xhtml.storage.resource.identifiers.StorageResourceIdentifierConstants;
import com.atlassian.confluence.plugin.copyspace.service.ContentRewriter;
import com.atlassian.confluence.plugin.copyspace.service.impl.AbstractChainedContentRewriter;
import com.atlassian.confluence.plugin.copyspace.util.XmlEventUtils;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang.StringUtils;

public class ExpandRelativeReferencesRewriter
extends AbstractChainedContentRewriter {
    private final String oldSpaceKey;
    private final XMLEventFactory xmlEventFactory;
    private final Set<QName> SUPPORTED_RESOURCES = Sets.newHashSet((Object[])new QName[]{StorageResourceIdentifierConstants.BLOG_POST_RESOURCE_QNAME, StorageResourceIdentifierConstants.PAGE_RESOURCE_QNAME});

    public ExpandRelativeReferencesRewriter(String oldSpaceKey, XMLEventFactory xmlEventFactory, ContentRewriter contentRewriter) {
        super(contentRewriter);
        this.oldSpaceKey = oldSpaceKey;
        this.xmlEventFactory = xmlEventFactory;
    }

    @Override
    public XMLEvent updateXmlEventInternal(XMLEvent nextEvent, Properties context) {
        if (nextEvent.isStartElement() && this.isSupportedResourceWithEmptySpace(nextEvent.asStartElement())) {
            StartElement element = nextEvent.asStartElement();
            Attribute newAttribute = this.xmlEventFactory.createAttribute(StorageResourceIdentifierConstants.SPACEKEY_ATTRIBUTE_QNAME, this.oldSpaceKey);
            List<Attribute> attributesToWrite = XmlEventUtils.getExtendedAttributes(element, newAttribute);
            return this.xmlEventFactory.createStartElement(element.getName(), attributesToWrite.iterator(), null);
        }
        return nextEvent;
    }

    private boolean isSupportedResourceWithEmptySpace(StartElement startElement) {
        if (!this.SUPPORTED_RESOURCES.contains(startElement.getName())) {
            return false;
        }
        Attribute spaceKeyAttr = startElement.getAttributeByName(StorageResourceIdentifierConstants.SPACEKEY_ATTRIBUTE_QNAME);
        return spaceKeyAttr == null || StringUtils.isEmpty((String)spaceKeyAttr.getValue());
    }
}

