/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.copyspace.service.impl;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.links.LinkManager;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.plugin.copyspace.context.CopySpaceContext;
import com.atlassian.confluence.plugin.copyspace.service.AttachmentMetadataService;
import com.atlassian.confluence.plugin.copyspace.service.CommentService;
import com.atlassian.confluence.plugin.copyspace.service.ContextHolder;
import com.atlassian.confluence.plugin.copyspace.service.LinksUpdater;
import com.atlassian.confluence.plugin.copyspace.service.SidebarLinkCopier;
import com.atlassian.confluence.plugin.copyspace.util.Constants;
import com.atlassian.confluence.plugin.copyspace.util.MetadataCopier;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="commentServiceImpl")
public class CommentServiceImpl
implements CommentService {
    private final SidebarLinkCopier sidebarLinkCopier;
    private final CommentManager commentManager;
    private final LinkManager linkManager;
    private final ContextHolder contextHolder;
    private final AttachmentMetadataService attachmentMetadataService;
    private final LinksUpdater linksUpdater;

    @Autowired
    public CommentServiceImpl(SidebarLinkCopier sidebarLinkCopier, @ComponentImport CommentManager commentManager, @ComponentImport LinkManager linkManager, ContextHolder contextHolder, AttachmentMetadataService attachmentMetadataService, LinksUpdater linksUpdater) {
        this.sidebarLinkCopier = sidebarLinkCopier;
        this.commentManager = commentManager;
        this.linkManager = linkManager;
        this.contextHolder = contextHolder;
        this.attachmentMetadataService = attachmentMetadataService;
        this.linksUpdater = linksUpdater;
    }

    @Override
    public void copyComments(ContentEntityObject targetCeo, List<Comment> originalComments) {
        CopySpaceContext context = this.contextHolder.getContext();
        HashMap<Long, Comment> oldIdToCopiedComment = new HashMap<Long, Comment>();
        List orderedComments = originalComments.stream().sorted(Comparator.comparing(EntityObject::getCreationDate)).collect(Collectors.toList());
        for (Comment oldComment : orderedComments) {
            Comment newParent = null;
            if (oldComment.getParent() != null) {
                Long oldId = oldComment.getParent().getId();
                newParent = (Comment)oldIdToCopiedComment.get(oldId);
            }
            Comment comment = this.saveComment(targetCeo, newParent, oldComment);
            oldIdToCopiedComment.put(oldComment.getId(), comment);
            this.sidebarLinkCopier.checkAndCopyRewritableSidebarLink((ContentEntityObject)oldComment, (ContentEntityObject)comment, context.getOriginalSpaceKey(), context.getTargetSpaceKey());
            this.attachmentMetadataService.preserveMetadata((ContentEntityObject)oldComment, (ContentEntityObject)comment);
        }
    }

    private Comment saveComment(ContentEntityObject destination, Comment parent, Comment oldComment) {
        Comment comment = new Comment();
        if (oldComment.isInlineComment()) {
            comment.setContentPropertiesFrom((ContentEntityObject)oldComment);
        }
        comment.setBodyAsString(this.linksUpdater.rewriteLinks(oldComment.getBodyContent().getBody()));
        destination.addComment(comment);
        if (parent != null) {
            parent.addChild(comment);
        }
        this.commentManager.saveContentEntity((ContentEntityObject)comment, Constants.SUPPRESS_EVENT_KEEP_LAST_MODIFIER);
        this.linkManager.updateOutgoingLinks((ContentEntityObject)comment);
        MetadataCopier.copyEntityMetadata((ConfluenceEntityObject)oldComment, (ConfluenceEntityObject)comment);
        return comment;
    }
}

