/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.copyspace.service.impl;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentBody;
import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.Version;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.people.Group;
import com.atlassian.confluence.api.model.people.KnownUser;
import com.atlassian.confluence.api.model.people.Subject;
import com.atlassian.confluence.api.model.permissions.ContentRestriction;
import com.atlassian.confluence.api.model.permissions.OperationKey;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugin.copyspace.api.event.ExecutionFailureDescriptor;
import com.atlassian.confluence.plugin.copyspace.api.event.ExecutionStage;
import com.atlassian.confluence.plugin.copyspace.api.event.FailureReason;
import com.atlassian.confluence.plugin.copyspace.context.CopySpaceContext;
import com.atlassian.confluence.plugin.copyspace.exception.CopySpaceCopyAttachmentException;
import com.atlassian.confluence.plugin.copyspace.service.AttachmentMetadataService;
import com.atlassian.confluence.plugin.copyspace.service.BlogPostService;
import com.atlassian.confluence.plugin.copyspace.service.CommentService;
import com.atlassian.confluence.plugin.copyspace.service.ContextHolder;
import com.atlassian.confluence.plugin.copyspace.service.LabelService;
import com.atlassian.confluence.plugin.copyspace.service.LinksUpdater;
import com.atlassian.confluence.plugin.copyspace.service.ProgressMeterFactory;
import com.atlassian.confluence.plugin.copyspace.util.Constants;
import com.atlassian.confluence.rest.api.model.ExpansionsParser;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.persistence.dao.compatibility.FindUserHelper;
import com.atlassian.core.util.ProgressMeter;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="blogPostServiceImpl")
public class BlogPostServiceImpl
implements BlogPostService {
    static final int BATCH_CONTENT_SIZE = 99;
    static final int NEXT_ITEM_FOR_HAS_MORE_CHECK = 1;
    private static final Logger log = LoggerFactory.getLogger(BlogPostServiceImpl.class);
    private static final Expansion NAME_EXPANSION = new Expansion("name");
    private static final String EXPANSIONS = "restrictions.read.restrictions.user,restrictions.read.restrictions.group,restrictions.update.restrictions.user,restrictions.update.restrictions.group,history.lastUpdated,body.storage";
    private final ContentService contentService;
    private final SpaceService spaceService;
    private final AttachmentManager attachmentManager;
    private final PageManager pageManager;
    private final ContentPermissionManager contentPermissionManager;
    private final CommentManager commentManager;
    private final ProgressMeterFactory progressMeterFactory;
    private final AttachmentMetadataService attachmentMetadataService;
    private final CommentService commentService;
    private final LinksUpdater linksUpdater;
    private final LabelService labelService;
    private final TransactionTemplate transactionTemplate;
    private final SpaceManager spaceManager;
    private final ContextHolder contextHolder;

    @Autowired
    public BlogPostServiceImpl(@ComponentImport @Qualifier(value="apiContentService") ContentService contentService, @ComponentImport @Qualifier(value="apiSpaceService") SpaceService spaceService, @ComponentImport AttachmentManager attachmentManager, @ComponentImport PageManager pageManager, @ComponentImport ContentPermissionManager contentPermissionManager, @ComponentImport CommentManager commentManager, AttachmentMetadataService attachmentMetadataService, ProgressMeterFactory progressMeterFactory, CommentService commentService, LinksUpdater linksUpdater, LabelService labelService, @ComponentImport TransactionTemplate transactionTemplate, @ComponentImport SpaceManager spaceManager, ContextHolder contextHolder) {
        this.contentService = contentService;
        this.spaceService = spaceService;
        this.attachmentManager = attachmentManager;
        this.pageManager = pageManager;
        this.contentPermissionManager = contentPermissionManager;
        this.commentManager = commentManager;
        this.attachmentMetadataService = attachmentMetadataService;
        this.progressMeterFactory = progressMeterFactory;
        this.commentService = commentService;
        this.linksUpdater = linksUpdater;
        this.labelService = labelService;
        this.transactionTemplate = transactionTemplate;
        this.spaceManager = spaceManager;
        this.contextHolder = contextHolder;
    }

    @Override
    public void copyBlogPosts() {
        boolean hasMoreBlogPosts;
        CopySpaceContext context = this.contextHolder.getContext();
        int blogPostsCount = context.getBlogPostsCount();
        if (blogPostsCount == 0) {
            return;
        }
        ProgressMeter copyBlogsProgressMeter = this.progressMeterFactory.createSubProgressMeter(blogPostsCount);
        int offset = 0;
        int itemsProcessed = 0;
        do {
            List<Object> originalBlogPosts;
            hasMoreBlogPosts = (originalBlogPosts = this.findBatchedCurrentBlogPostsForSpace(context.getOriginalSpaceKey(), offset)).size() > 99;
            originalBlogPosts = originalBlogPosts.stream().limit(99L).collect(Collectors.toList());
            this.executeBatchInTransaction(originalBlogPosts);
            copyBlogsProgressMeter.setCurrentCount(itemsProcessed += originalBlogPosts.size());
            log.debug("Copy blogposts operation. Blogs batch from {} to {} successfully copied.", (Object)(offset + 1), (Object)(offset + originalBlogPosts.size()));
            offset += 99;
        } while (hasMoreBlogPosts);
    }

    private void executeBatchInTransaction(List<Content> originalBlogPosts) {
        CopySpaceContext context = this.contextHolder.getContext();
        this.transactionTemplate.execute(() -> {
            Space newSpace = this.spaceManager.getSpace(context.getTargetSpaceKey());
            for (Content originalBlogPost : originalBlogPosts) {
                try {
                    this.copyBlogPost(originalBlogPost, newSpace);
                }
                catch (IOException e) {
                    throw new CopySpaceCopyAttachmentException(new ExecutionFailureDescriptor(ExecutionStage.COPY_BLOG_POST, FailureReason.MISSING_ATTACHMENT), (Throwable)e);
                }
            }
            return null;
        });
    }

    private List<Content> findBatchedCurrentBlogPostsForSpace(String spaceKey, int offset) {
        return this.contentService.find(ExpansionsParser.parse((String)EXPANSIONS)).withSpace(new com.atlassian.confluence.api.model.content.Space[]{(com.atlassian.confluence.api.model.content.Space)this.spaceService.find(new Expansion[]{NAME_EXPANSION}).withKeys(new String[]{spaceKey}).fetch().get()}).fetchMany(ContentType.BLOG_POST, (PageRequest)new SimplePageRequest(offset, 100)).getResults();
    }

    public void copyBlogPost(Content originalBlogPostContent, Space newSpace) throws IOException {
        CopySpaceContext context = this.contextHolder.getContext();
        BlogPost copy = this.getBlogPostFromContent(originalBlogPostContent, newSpace);
        long blogPostId = originalBlogPostContent.getId().asLong();
        this.copyBlogPostContentPermissions(originalBlogPostContent.getRestrictions(), copy);
        if (context.isCopyAttachments()) {
            this.copyBlogPostAttachments(copy, blogPostId);
        }
        if (context.isCopyLabels()) {
            this.labelService.copyBlogPostLabels(blogPostId, copy);
        }
        if (context.isCopyComments()) {
            this.copyBlogPostComments(copy, blogPostId);
        }
    }

    private BlogPost getBlogPostFromContent(Content originalBlogPostContent, Space newSpace) {
        BlogPost copy = new BlogPost();
        String title = originalBlogPostContent.getTitle();
        Date creationDate = originalBlogPostContent.getHistory().getCreatedDate().toDate();
        ConfluenceUser createdBy = FindUserHelper.getUserByUsername((String)originalBlogPostContent.getHistory().getCreatedBy().optionalUsername().orElse(null));
        String contentBody = ((ContentBody)originalBlogPostContent.getBody().get(ContentRepresentation.STORAGE)).getValue();
        Version lastVersion = (Version)originalBlogPostContent.getHistory().getLastUpdatedRef().get();
        Date lastModificationDate = lastVersion.getWhen().toDate();
        copy.setSpace(newSpace);
        copy.setTitle(title);
        copy.setCreationDate(creationDate);
        copy.setCreator(createdBy);
        copy.setBodyAsString(this.linksUpdater.rewriteLinks(contentBody));
        copy.setLastModifier(createdBy);
        copy.setLastModificationDate(lastVersion.getNumber() > 1 ? creationDate : lastModificationDate);
        copy.setSynchronyRevisionSource("restored");
        this.pageManager.saveContentEntity((ContentEntityObject)copy, Constants.SUPPRESS_EVENT_KEEP_LAST_MODIFIER);
        return copy;
    }

    private void copyBlogPostAttachments(BlogPost entity, long blogPostId) throws IOException {
        BlogPost originalBlogPostImitation = new BlogPost();
        originalBlogPostImitation.setId(blogPostId);
        this.attachmentManager.copyAttachments((ContentEntityObject)originalBlogPostImitation, (ContentEntityObject)entity, DefaultSaveContext.BULK_OPERATION);
        List copiedAttachments = this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)originalBlogPostImitation);
        this.attachmentMetadataService.preserveMetadata(copiedAttachments, (ContentEntityObject)entity);
    }

    private void copyBlogPostComments(BlogPost entity, long blogPostId) {
        List blogPostComments = this.commentManager.getPageComments(blogPostId, entity.getCreationDate(), "");
        this.commentService.copyComments((ContentEntityObject)entity, blogPostComments);
    }

    private void copyBlogPostContentPermissions(Map<OperationKey, ContentRestriction> contentRestrictions, BlogPost entity) {
        Set<OperationKey> contentRestrictionsKeys = contentRestrictions.keySet();
        for (OperationKey operationKey : contentRestrictionsKeys) {
            String permissionLevel = this.getContentPermissionType(operationKey);
            List subjects = contentRestrictions.get(operationKey).getRestrictions().values().stream().map(PageResponse::getResults).flatMap(Collection::stream).collect(Collectors.toList());
            for (Subject subject : subjects) {
                ContentPermission newPermission = subject instanceof KnownUser ? ContentPermission.createUserPermission((String)permissionLevel, (ConfluenceUser)FindUserHelper.getUserByUsername((String)((KnownUser)subject).getUsername())) : ContentPermission.createGroupPermission((String)permissionLevel, (String)((Group)subject).getName());
                this.contentPermissionManager.addContentPermission(newPermission, (ContentEntityObject)entity);
            }
        }
    }

    private String getContentPermissionType(OperationKey key) {
        if (key == OperationKey.READ) {
            return "View";
        }
        if (key == OperationKey.UPDATE) {
            return "Edit";
        }
        throw new IllegalArgumentException(String.format("Unexpected operation key: {}", key));
    }
}

