/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.copyspace.chain;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.page.PageCopyEvent;
import com.atlassian.confluence.plugin.copyspace.chain.CopyHandler;
import com.atlassian.confluence.plugin.copyspace.context.CopySpaceContext;
import com.atlassian.confluence.plugin.copyspace.service.CommentService;
import com.atlassian.confluence.plugin.copyspace.service.ContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="commentCopyHandler")
public class CommentCopyHandler
implements CopyHandler {
    private final ContextHolder contextHolder;
    private final CommentService commentService;

    @Autowired
    public CommentCopyHandler(ContextHolder contextHolder, CommentService commentService) {
        this.contextHolder = contextHolder;
        this.commentService = commentService;
    }

    @Override
    public void checkAndCopy(PageCopyEvent event) {
        CopySpaceContext context = this.contextHolder.getContext();
        if (!context.isCopyComments()) {
            return;
        }
        this.commentService.copyComments((ContentEntityObject)event.getDestination(), event.getOrigin().getComments());
    }
}

