/*
 * Copyright (c) 2020, 2021 Appfire Technologies, Inc.
 * All rights reserved.
 *This software is licensed under the provisions of the "Bob Swift Atlassian Apps EULA"
 *(https://bobswift.atlassian.net/wiki/x/WoDXBQ) as well as under the provisions of
 *the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product”
 *(http://www.atlassian.com/licensing/marketplace/termsofuse).
 * 
 * See the LICENSE file for more details.
 * 
 */

if (!window.bobswift) {
    window.bobswift = new Object();
}
if (!window.bobswift.graphviz) {
    window.bobswift.graphviz = new Object();
}
if (!window.bobswift.graphviz.profileconfig) {
    window.bobswift.graphviz.profileconfig = new Object();
}
var VALIDATION_CSS_CLASS = "appfire-gviz-field-validation";

AJS.toInit(function($) {
  //if profile operation added/edited/deleted, the make the profile tab active else default global-config tab will be active
    if(window.location.href.includes('profileActive=true')){
        focusProfileTab();
    }
    
    /**
     * Focus given to clicked tab in the add/edit profile dialog
     */
   function focusProfileTab(){
        $("#global-config-tab").removeClass("active-tab");
        $("#tab-global-config").removeClass("active-pane");
        $("#profiles-config-tab").addClass("active-tab");
        $("#tab-profiles-config").addClass(" active-pane");
    }
    //Create Profile Screen, Add Profile Button
    AJS.$("#gvizAddProfile").click(function(e) {
        var $dialog = $(com.atlassian.confluence.extra.graphviz.config.profiles.profileAddEditorDlg({
            'profileObj' : null
        }));
        $dialog.appendTo("#admin-body-content");
        AJS.dialog2($dialog).show();
        AJS.dialog2("#gviz-config-profile-dialog").on("hide", function() {
            $(this).remove();
            $('.appfire-gviz-profile-help-dialogs').remove(); //On hiding editprofile dialog, remove the help dialogs as well.
        });
        //Save or Update profile button click handler
        AJS.$("#gviz-create-profile-button").click(window.bobswift.graphviz.profileconfig.saveProfile);
        // On Add/Edit profile dialog cancel , on cancel do not reload page, only hide the dialog
        AJS.$(".gviz-add-edit-profile-close").click(function(e) {
            e.preventDefault();
            AJS.dialog2("#gviz-config-profile-dialog").hide();
        });
    });
    AJS.$(".gvizEditProfileLink").click(function(e) {
        var profileRow = $(this).closest("tr");
        var profileObj = typeof $(profileRow).find(".gvizEditProfileLink").data("profile") == "object" ? $(profileRow).find(".gvizEditProfileLink").data("profile") : JSON.parse($(profileRow).find(".gvizEditProfileLink").data("profile"));
        var $dialog = $(com.atlassian.confluence.extra.graphviz.config.profiles.profileAddEditorDlg({
            'profileObj' : profileObj
        }));
        $dialog.appendTo("#admin-body-content");
        AJS.dialog2($dialog).show();
        AJS.dialog2("#gviz-config-profile-dialog").on("hide", function() {
            $(this).remove();
            $('.appfire-gviz-profile-help-dialogs').remove(); //On hiding editprofile dialog, remove the help dialogs as well.
        });
        //Save or Update profile button click handler
        AJS.$("#gviz-create-profile-button").click(window.bobswift.graphviz.profileconfig.saveProfile);
        // On Add/Edit profile dialog cancel , on cancel do not reload page, only hide the dialog
        AJS.$(".gviz-add-edit-profile-close").click(function(e) {
            e.preventDefault();
            AJS.dialog2("#gviz-config-profile-dialog").hide();
        });
    });
    $(document).on("click", ".gvizDeleteProfileLink", function() {
        var profileRow = $(this).closest("tr");
        var profileName = $(profileRow).find(".profileName").text().trim();
        window.bobswift.graphviz.profileconfig.displayDeleteDialog(profileName);
    });
});

    window.bobswift.graphviz.profileconfig.onProfileTypeChange = function() {
        window.bobswift.graphviz.profileconfig.clearFormFields();
        window.bobswift.graphviz.profileconfig.clearAllExistingErrorMessages();
        if (AJS.$("#profileType").val().toLowerCase() == "gitlab") {
            AJS.$("#headerParams").val("Private-Token: $accessToken");
            AJS.$("#url").val("https://gitlab.com/api/v4/projects");
        } else if (AJS.$("#profileType").val().toLowerCase() == "github") {
            AJS.$("#headerParams").val(
                    "Authorization: token  $accessToken , Accept: application/vnd.github.v3.raw");
            AJS.$("#url").val("https://api.github.com/repos");
        }
    }

    window.bobswift.graphviz.profileconfig.clearFormFields = function() {
        //Clear existing value
        AJS.$("#url").val("");
        AJS.$("#urlParams").val("");
        AJS.$("#headerParams").val("");
    }

    window.bobswift.graphviz.profileconfig.saveProfile = function(event) {
        event.preventDefault();
        window.bobswift.graphviz.profileconfig.clearAllExistingErrorMessages();
        validForm = window.bobswift.graphviz.profileconfig.validateFields();
        if (validForm) {
            var profileAction = $("#gviz-create-profile-button").data('profileaction');
            var profileName = $("#gviz-create-profile-button").data('profilename');
            var isEncrypted = $("#gviz-create-profile-button").data('isencrypted');
            
            if(!isEncrypted){
                var $dialog = $(com.atlassian.confluence.extra.graphviz.config.profiles.editOldProfileConfirmationDialog({
                    'profileName' : profileName
                }));
                $dialog.appendTo("#admin-body-content");
                AJS.dialog2($dialog).show();
                AJS.dialog2("#gviz-edit-profile-confirmation-dialog").on("hide", function() {
                    $(this).remove();
                });
                // Confirm button click handler
                $("#gviz-confirm-edit-profile-button").click(function(e) {
                    e.preventDefault();
                    window.bobswift.graphviz.profileconfig.submitProfileForm(profileAction, profileName);
                    AJS.dialog2("#gviz-edit-profile-confirmation-dialog").hide();
                });
    
                // On Delete profile dialog cancel , do not reload page, only hide the dialog
                AJS.$(".confirm-edit-profile-close").click(function(e) {
                    e.preventDefault();
                    AJS.dialog2("#gviz-edit-profile-confirmation-dialog").hide();
                });
            }else{
               window.bobswift.graphviz.profileconfig.submitProfileForm(profileAction, profileName);
            }
        } else {
            return false; //Seems some validation error.
        }
    }

    window.bobswift.graphviz.profileconfig.submitProfileForm = function(profileAction,
            existingProfileName) {
        //send profile data to server
        var profileName = AJS.$("#profileName").val().trim();
        var profileType = AJS.$("#profileType").val().trim();
        var url = AJS.$("#url").val().trim();
        var user = AJS.$("#user").val().trim();
        var password = AJS.$("#password").val().trim();
        var urlParams = AJS.$("#urlParams").val().trim();
        var headerParams = AJS.$("#headerParams").val().trim();
        var accessToken = AJS.$("#accessToken").val().trim();
        var profileId = AJS.$("#profileId").val().trim();
        var profileObj = {
            "profileName" : profileName,
            "profileType" : profileType,
            "url" : url,
            "user" : user,
            "password" : password,
            "urlParams" : urlParams,
            "headerParams" : headerParams,
            "accessToken" : accessToken,
            "ID" : profileId
        };
        var profileData = JSON.stringify(profileObj);
        AJS.$.ajax({
            url : AJS.contextPath() + '/rest/bobswift/graphviz/1.0/profile/profiles/' + existingProfileName,
            type : (profileAction.trim() == "add" ? "POST" : "PUT"),
            contentType : "application/json; charset=utf-8",
            dataType : "json",
            data : profileData,
            success : function(data, textStatus, jqXHR) {
                if (jqXHR.status == 200) {
                    AJS.dialog2("#gviz-config-profile-dialog").hide();
                    window.location.href = "./configure.action?profileActive=true";
                }
            },
            error : function(jqXHR, textStatus, errorThrown) {
                window.bobswift.graphviz.profileconfig.updateStatusField("gviz-config-profiles-status",
                        "error", jqXHR.responseText);
            }
        })
    }
    window.bobswift.graphviz.profileconfig.updateStatusField = function(field, status, error) {
        var successMessage = AJS.I18n
                .getText("com.atlassian.confluence.extra.graphviz.config.profile.save.success");
        var successHtml = "<span class=\"aui-icon aui-icon-small aui-iconfont-approve\"></span>&nbsp;&nbsp;<span id=\"message\">"
                + successMessage + "</span>";
        var errorHtml = "<div class=\"error\"><span class=\"aui-icon  aui-icon-small aui-icon-error aui-iconfont-error\"></span>&nbsp;&nbsp;<span id=\"message\">"
                + error + "</span></div>";
        if (status == "success") {
            $("#" + field).html(successHtml);
        } else if (status == "error") {
            $("#" + field).html(errorHtml);
            $("#" + field)[0].scrollIntoView(); //Scroll down to highlight the error
            
        }
    }
    
    window.bobswift.graphviz.profileconfig.validateFields = function() {
        window.bobswift.graphviz.profileconfig.clearAllExistingErrorMessages();
        var validForm = window.bobswift.graphviz.profileconfig.addValidateClass($("#profileName"));
        if (($("#profileType").val() == "GitHub" || $("#profileType").val() == "GitLab") && $("#accessTokenExists").val() != "yes") {
            validForm = window.bobswift.graphviz.profileconfig.addValidateClass($("#accessToken")) && validForm;
        }
        return validForm;
    }
    window.bobswift.graphviz.profileconfig.clearAllExistingErrorMessages = function(){
        $("#gviz-config-profile-form :input").each(function(index,element){
                $("#"+element.id).removeClass(VALIDATION_CSS_CLASS);
                $("#"+element.id).siblings(".error").css({"display":"none"});
            })
    }
    window.bobswift.graphviz.profileconfig.addValidateClass = function($field) {
        if ($field.prop("disabled"))
            return true;
        if (!$field.val().trim()) {
            if (!$field.hasClass(VALIDATION_CSS_CLASS)) {
                $field.addClass(VALIDATION_CSS_CLASS);
                if($field.attr("name")==='accessToken'){
                    
                    var gitlabURL = AJS.I18n.getText("com.atlassian.confluence.extra.graphviz.config.accessToken.generate.token.gitlab");
                    var githubURL = AJS.I18n.getText("com.atlassian.confluence.extra.graphviz.config.accessToken.generate.token.github");
                    
                    if ($("#profileType").val() == "GitLab"){
                        $("#gvizTokenGeneratingHelpLink").attr('href',gitlabURL);
                    }
                    else if($("#profileType").val() == "GitHub"){
                        $("#gvizTokenGeneratingHelpLink").attr('href',githubURL);
                    }
                }
                $field.siblings(".error").css({"display":"block"});
            }
            return false;
        } else if ($field.attr('name') === "profileName" && $field.val().match(/[/\\]/g) && $field.val().match(/[/\\]/g).length > 0) {
            if (!$field.hasClass(VALIDATION_CSS_CLASS)) {
                $field.addClass(VALIDATION_CSS_CLASS);
                $field.siblings(".error").css({"display":"block"});
            }
            return false;
        }
        else {
            $field.removeClass(VALIDATION_CSS_CLASS);
            $field.siblings(".error").css({"display":"none"});
            return true;
        }
    }
  //For Delete dialog
    window.bobswift.graphviz.profileconfig.displayDeleteDialog = function(profileName) {
        var $dialog = $(com.atlassian.confluence.extra.graphviz.config.profiles.deleteDialog({
            'profileName' : profileName
        }));
        $dialog.appendTo("#admin-body-content");
        AJS.dialog2($dialog).show();
        AJS.dialog2("#gviz-delete-profile-dialog").on("hide", function() {
            $(this).remove();
        });
        // Delete profile button click handler
        $("#gviz-delete-profile-button").click(function(e) {
            e.preventDefault();
            var profileName = $(this).data('profilename');
            window.bobswift.graphviz.profileconfig.deleteProfile(profileName);
        });

        // On Delete profile dialog cancel , do not reload page, only hide the dialog
        AJS.$(".gviz-delete-profile-close").click(function(e) {
            e.preventDefault();
            AJS.dialog2("#gviz-delete-profile-dialog").hide();
        });

    }

    window.bobswift.graphviz.profileconfig.deleteProfile = function(profileName) {
        AJS.$.ajax({
            url : AJS.contextPath() + '/rest/bobswift/graphviz/1.0/profile/profiles/' + encodeURIComponent(profileName),
            type : "DELETE",
            contentType : "application/json; charset=utf-8",
            dataType : "json",
            success : function(data, textStatus, jqXHR) {
                if (jqXHR.status == 200) {
                    AJS.dialog2("#gviz-delete-profile-dialog").hide();
                    window.location.href = "./configure.action?profileActive=true";
                }
            },
            error : function(jqXHR, textStatus, errorThrown) {
                window.bobswift.graphviz.profileconfig.updateStatusField("gviz-config-profiles-status",
                        "error", jqXHR.responseText);
                return false;
            }
        })
    }