/*
 * Copyright (c) 2019 Appfire Technologies, Inc.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Bob Swift Atlassian Add-ons EULA"
 * (https://bobswift.atlassian.net/wiki/x/WoDXBQ) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 

if(!window.bobswift) { window.bobswift=new Object();}
if(!window.bobswift.graphviz) { window.bobswift.graphviz=new Object();}
if(!window.bobswift.graphviz.templateconfig) { window.bobswift.graphviz.templateconfig=new Object();}


AJS.toInit(function($) {

    //Template configuration view Link click
    $(document).on("click", ".viewTemplateLink", function() {
        var templateRow = $(this).closest("tr");
        var macroName =  $(templateRow).find(".macroName").text().trim();
        var templateName =  $(templateRow).find(".templateName").text().trim();
        var templateCell = $(this).closest("td");
        var wikiSyntax = templateCell.attr("data-wikiSyntax");
        var selectedTemplateId = templateCell.attr("data-templateId");
        window.bobswift.graphviz.templateconfig.displayViewConfigDialog(macroName,wikiSyntax,templateName);
    });
    
  //Preview click for Add/Edit
    $(document).on("click", ".previewTemplate", function(event) {
        window.bobswift.graphviz.templateconfig.clearMessage("config-templates-status");
        var macroName =  $("#macroName").val()
        var wikiSyntax = $("#wikiSyntax").val()
        var templateName = $("#templateName").val()
        var image = $(".editor-preview-image");
        image.attr("src",getSrcUrl(macroName,wikiSyntax));
        image.attr("alt", AJS.I18n.getText("com.atlassian.confluence.extra.graphviz.viewtemplates.error"));
        event.preventDefault();
    });

    //Close events for add, edit, delte and view.
    $(document).on("click", ".add-edit-template-close", function(e) {
        AJS.dialog2("#config-template-dialog").remove();
        e.preventDefault();
    });
    
    $(document).on("click", "#view-template-close", function(e) {
        AJS.dialog2("#view-template-dialog").remove();
    });
    
    $(document).on("click", ".delete-template-close", function(e) {
        AJS.dialog2("#delete-template-dialog").remove();
    });
    
    $(document).on("click", "#import-template-close", function(e) {
        AJS.dialog2("#import-template-dialog").remove();
    });
    
    $(document).on("click", ".export-template-close", function(e) {
        AJS.dialog2("#export-template-dialog").remove();
    });
    
    //Template configuration Edit link click.
    $(document).on("click", ".editTemplateLink", function() {
        var templateRow = $(this).closest("tr");
        var macroName =  $(templateRow).find(".macroName").text().trim();
        var templateName =  $(templateRow).find(".templateName").text().trim();
        var templateCell = $(this).closest("td");
        var wikiSyntax = templateCell.attr("data-wikiSyntax");
        var selectedTemplateId = templateCell.attr("data-templateId");
        window.bobswift.graphviz.templateconfig.displayConfigDialog(selectedTemplateId, macroName, templateName, wikiSyntax);
    });
    
  //Template configuration Delete link click.
    $(document).on("click", ".deleteTemplateLink", function() {
        var templateRow = $(this).closest("tr");
        var templateName =  $(templateRow).find(".templateName").text().trim();
        var selectedTemplateId = $(this).closest("td").attr("data-templateId");
        window.bobswift.graphviz.templateconfig.displayDeleteDialog(selectedTemplateId,templateName)
    });
   
    //Templates Configuration Screen Add Template Button
    AJS.$("#addTemplate").click(function(e) {
        window.bobswift.graphviz.templateconfig.displayConfigDialog();
    });
   
    // To import the file and load on to the configure screen
    AJS.$('#importTemplate').on('click', function(event) {
        window.bobswift.graphviz.templateconfig.displayImportDialog();
        AJS.$('#import-templates-submit').on('click', function(event) {
            var importFileInputVal = AJS.$("#templatesFileInput").val();
            if (!importFileInputVal) {
                AJS.$("#importTemplateErrorMessageDiv").text(AJS.I18n.getText("com.atlassian.confluence.extra.graphviz.import-templates-no-file-chosen"));
                event.preventDefault();
            } 
        });
    });
});

*//**
 * Dialogs
 *//*

// For Add and Edit dialogs
window.bobswift.graphviz.templateconfig.displayConfigDialog=function(templateId, macroName, templateName, wikiSyntax){
    var $dialog = $(org.swift.confluence.graphviz.configtemplates.templatePreviewDlg({'templateId': templateId,'macroName': macroName,'templateName': templateName,'wikiSyntax': wikiSyntax}));
    $dialog.appendTo("#admin-body-content");
    if(templateId){
        var image = $(".editor-preview-image");
        image.attr("src",getSrcUrl(macroName,wikiSyntax));
        image.attr("alt", AJS.I18n.getText("com.atlassian.confluence.extra.graphviz.viewtemplates.error"));
    }
    AJS.dialog2($dialog).show();
    
    //Save or Update template button click handler
    AJS.$("#create-template-button").click(function(event){
        event.preventDefault();
        var templateDialog = $(this).closest('#config-template-dialog');
        validForm = window.bobswift.graphviz.templateconfig.validateFields(templateDialog);
        if(validForm){
            var templateAction = $(this).data('templateaction');
            var templateId = $(this).data('templateid');
            window.bobswift.graphviz.templateconfig.addTemplate(templateAction, templateDialog, templateId); 
        } else {
            return false //Seems some validation error.
        }
    });
}

// For Delete dialog
window.bobswift.graphviz.templateconfig.displayDeleteDialog=function(templateId,templateName){
    var $dialog = $(org.swift.confluence.graphviz.configtemplates.deleteDialog({'templateName': templateName,'templateId': templateId}));
    $dialog.appendTo("#admin-body-content");
    AJS.dialog2($dialog).show();

    // Delete template button click handler
    $("#delete-template-button").click(function(e){
        var templateId = $(this).data('templateid');
        window.bobswift.graphviz.templateconfig.deleteTemplate(templateId); 
    });
}

//For View dialog
window.bobswift.graphviz.templateconfig.displayViewConfigDialog=function(macroName,wikiSyntax,templateName){
    var $dialog = $(org.swift.confluence.graphviz.configtemplates.viewDialog({'srcUrl': getSrcUrl(macroName,wikiSyntax),'templateName': templateName}));
    $dialog.appendTo("#admin-body-content");
    AJS.dialog2($dialog).show();
}

//For Import dialog
window.bobswift.graphviz.templateconfig.displayImportDialog=function(){
    var $dialog = $(org.swift.confluence.graphviz.configtemplates.importDialog());
    $dialog.appendTo("#admin-body-content");
    AJS.dialog2($dialog).show();
}

*//**
 * Post form parameters when add or edit templates performed
 *//*
window.bobswift.graphviz.templateconfig.addTemplate=function(action, dialog, templateId)
{
    var templateObj = {
                        "macroName": dialog.find("#macroName").val(),
                        "templateName": dialog.find("#templateName").val(),
                        "type": dialog.find("#userType").val(),
                        "wikiSyntax": dialog.find("#wikiSyntax").val(),
                        "id": templateId
                     };
    var templateData = JSON.stringify(templateObj);
    AJS.$.ajax({
            url: AJS.contextPath()+'/rest/bobswift/graphviz/latest/template',
            type: (action.trim() == "add" ? "POST" : "PUT"),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            data: templateData,
            success: function( data, textStatus, jqXHR)
            {
                if(jqXHR.status == 200) {
                    AJS.dialog2(dialog).hide();
                    location.reload(true);
                } 
                if(jqXHR.status == 304) {
                    jqXHR.responseText= AJS.I18n.getText("com.atlassian.confluence.extra.graphviz.templateexists.error");
                } 
            },
            error: function( jqXHR, textStatus, errorThrown)
            {
                window.bobswift.graphviz.templateconfig.updateStatusField("config-templates-status","error", jqXHR.responseText);
            },
            complete: function( jqXHR, textStatus, errorThrown)
            {
                window.bobswift.graphviz.templateconfig.updateStatusField("config-templates-status","error", jqXHR.responseText);
            }
        })
}

*//**
 * Post form parameters delete template performed
 *//*
window.bobswift.graphviz.templateconfig.deleteTemplate=function(templateId)
{
    var templateObj = {
                        "id": templateId
                     };
    var templateData = JSON.stringify(templateObj);
    AJS.$.ajax({
            url: AJS.contextPath()+'/rest/bobswift/graphviz/latest/deletetemplate',
            type:  "POST",
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            data: templateData,
            success: function( data, textStatus, jqXHR)
            {
                if(jqXHR.status == 200){
                    window.bobswift.graphviz.templateconfig.updateStatusField("config-templates-status","success","");
                    AJS.dialog2(dialog).hide();
                    location.reload(true);
                }
            },
            error: function( jqXHR, textStatus, errorThrown)
            {
                window.bobswift.graphviz.templateconfig.updateStatusField("config-templates-status","error", jqXHR.responseText);
                return false;
            },
            complete: function( jqXHR, textStatus, errorThrown)
            {
                window.bobswift.graphviz.templateconfig.updateStatusField("config-templates-status","error", jqXHR.responseText);
                location.reload(true);
            }
        })
}

*//**
* validating fields on create or edit template button click.
*//*

window.bobswift.graphviz.templateconfig.validateFields=function(templateDialog)
{
    var validForm = true;
    
    validForm = window.bobswift.graphviz.templateconfig.addValidateClass($("#templateName")) && validForm;
    validForm = window.bobswift.graphviz.templateconfig.addValidateClass($("#wikiSyntax")) && validForm;
    
    if (!validForm) {
        window.bobswift.graphviz.templateconfig.updateStatusField("config-templates-status","error", AJS.I18n.getText("com.atlassian.confluence.extra.graphviz.missingfields.error"));
        return false;
    }

    return validForm;
}

*//**
* Add css to highlight or remove highlighting
*//*
window.bobswift.graphviz.templateconfig.addValidateClass=function($field)
{
    if($field.prop("disabled"))
        return true;
    
   if(!$field.val())
   {
       if(!$field.hasClass("appfire-graphviz-field-validation")) {
          $field.addClass("appfire-graphviz-field-validation");
       }
       return false;
   }
   else
   {
       $field.removeClass("appfire-graphviz-field-validation");
       return true;
   }
}

window.bobswift.graphviz.templateconfig.updateStatusField=function(field, status, error)
{
    var successMessage = "Save template successful";
    var successHtml = "<span class=\"aui-icon aui-icon-small aui-iconfont-approve\"></span>&nbsp;&nbsp;<span id=\"message\">"+successMessage+"</span>";
    var errorHtml = "<span class=\"aui-icon  aui-icon-small aui-icon-error\"></span>&nbsp;&nbsp;<span id=\"message\">"+error+"</span>";

     if(status == "success"){
        $("#"+field).html(successHtml);
    }
    else if (status == "error"){
        $("#"+field).html(errorHtml);
    }
}

function getSrcUrl(macroName,wikiSyntax) {
   return Confluence.getBaseUrl() +"/plugins/servlet/graphvizImageRenderer?macroName="+macroName+"&wikiSyntax="+encodeURIComponent(wikiSyntax);
}

window.bobswift.graphviz.templateconfig.viewStatusField=function(field, status, error)
{
    error = AJS.I18n.getText("com.atlassian.confluence.extra.graphviz.viewtemplates.error");
    var successMessage = "Save template successful";
    var successHtml = "<span class=\"aui-icon aui-icon-small aui-iconfont-approve\"></span>&nbsp;&nbsp;<span id=\"message\">"+successMessage+"</span>";
    var errorHtml = "<span class=\"aui-icon  aui-icon-small aui-icon-error\"></span>&nbsp;&nbsp;<span id=\"message\">"+error+"</span>";

     if(status == "success"){
        $("#"+field).html(successHtml);
    }
    else if (status == "error"){
        $("#"+field).html(errorHtml);
    }
}

window.bobswift.graphviz.templateconfig.clearMessage=function(field){
    $("#"+field).html('');
}

*/