/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.graphviz.util;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUserPreferences;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.core.DiagramDescription;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.graphviz.DotRunner;
import org.swift.confluence.graphviz.ao.domain.TemplateBean;
import org.swift.confluence.graphviz.ao.entity.AppfireTemplateEntity;
import org.swift.confluence.graphviz.ao.entity.ProfileEntity;
import org.swift.confluence.graphviz.ao.service.TemplatesService;
import org.swift.confluence.graphviz.bean.ProfileAnalyticsBean;
import org.swift.confluence.graphviz.listener.GraphvizAnalyticsListener;
import org.swift.confluence.scriptutil.EncryptDecryptHelper;
import org.swift.confluence.scriptutil.RunnableStreamReader;
import org.swift.confluence.scriptutil.ScriptUtils;
import org.swift.confluence.scriptutil.bean.ProfileBean;

public class GraphvizUtils {
    private static final Logger log = LoggerFactory.getLogger(GraphvizUtils.class);
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public static ArrayList<TemplateBean> getTemplateBeansFromEntities(List<AppfireTemplateEntity> appfireEntities) throws Exception {
        ArrayList<TemplateBean> templateList = new ArrayList<TemplateBean>();
        if (appfireEntities != null) {
            for (AppfireTemplateEntity appfireTemplatesEntity : appfireEntities) {
                TemplateBean template = GraphvizUtils.appfireEntityToBean(appfireTemplatesEntity);
                templateList.add(template);
            }
        }
        return templateList;
    }

    private static TemplateBean appfireEntityToBean(AppfireTemplateEntity srcTemplate) throws Exception {
        TemplateBean destTemplate = new TemplateBean();
        destTemplate.setTemplateName(srcTemplate.getTemplateName());
        destTemplate.setMacroName(srcTemplate.getMacroName());
        destTemplate.setWikiSyntax(srcTemplate.getWikiSyntax());
        destTemplate.setDescription(srcTemplate.getDescription());
        destTemplate.setLastUpdatedDate(srcTemplate.getLastUpdated());
        destTemplate.setLastUpdated(simpleDateFormat.format(srcTemplate.getLastUpdated()));
        destTemplate.setId(srcTemplate.getID());
        return destTemplate;
    }

    public static String getUpdatedSyntax(String syntax, String macroName) {
        String wikiMarkup;
        if ("digraph".equalsIgnoreCase(macroName)) {
            wikiMarkup = "digraph { \n" + syntax + "\n }";
        } else if ("graph".equalsIgnoreCase(macroName)) {
            wikiMarkup = "graph {\n" + syntax + "\n}";
        } else if ("flowchart".equalsIgnoreCase(macroName)) {
            String defaults = "edge [arrowsize=0.8]; node [shape=rect, style=filled, fillcolor=lightyellow, fontname=\"Verdana\", fontsize=\"9\"];";
            wikiMarkup = "digraph {\n" + defaults + syntax + "\n}";
        } else {
            wikiMarkup = syntax;
        }
        return wikiMarkup;
    }

    public static DotRunner getRunner(String dotCommands, String output, String layout, RunnableStreamReader.Type type) throws Exception {
        long startTime = System.currentTimeMillis();
        DotRunner runner = new DotRunner();
        runner.setContent(dotCommands);
        runner.setUp(output, layout);
        runner.setOutputType(type);
        runner.run();
        log.debug("elapsed time: {}", (Object)(System.currentTimeMillis() - startTime));
        return runner;
    }

    public TemplateBean getTemplateMacroBody(String templateName, TemplatesService templatesService) throws Exception {
        TemplateBean destTemplateBean = null;
        ArrayList<TemplateBean> tempList = GraphvizUtils.getTemplateBeansFromEntities(templatesService.getAppfireTemplates());
        Iterator<TemplateBean> iterator = tempList.iterator();
        while (iterator.hasNext()) {
            TemplateBean templateBean;
            destTemplateBean = templateBean = iterator.next();
            if (!templateBean.getTemplateName().equalsIgnoreCase(templateName)) continue;
            destTemplateBean.setWikiSyntax(templateBean.getWikiSyntax());
            break;
        }
        return destTemplateBean;
    }

    public static String getDateInConfluenceFormat(Date date) throws Exception {
        LocaleManager localeManager = (LocaleManager)ContainerManager.getComponent((String)"localeManager");
        FormatSettingsManager formatSettingsManager = (FormatSettingsManager)ContainerManager.getComponent((String)"formatSettingsManager");
        UserAccessor userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        ConfluenceUserPreferences preferences = userAccessor.getConfluenceUserPreferences((User)AuthenticatedUserThreadLocal.get());
        DateFormatter dateFormatter = preferences.getDateFormatter(formatSettingsManager, localeManager);
        return dateFormatter.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadAppfireTemplates(TemplatesService templatesServiceObj) throws Exception {
        JSONParser parser = new JSONParser();
        InputStreamReader inputStreamReader = null;
        try {
            Object object = null;
            List<AppfireTemplateEntity> templateLists = templatesServiceObj.getAppfireTemplates();
            if (templateLists != null && templateLists.size() > 0) {
                templatesServiceObj.deleteAppfireTemplates();
            }
            inputStreamReader = new InputStreamReader(GraphvizAnalyticsListener.class.getClassLoader().getResourceAsStream("templates.json"));
            object = parser.parse((Reader)inputStreamReader);
            JSONObject jsonObject = (JSONObject)object;
            JSONArray templates = (JSONArray)jsonObject.get((Object)"templates");
            for (JSONObject jsonObj : templates) {
                TemplateBean templateBean = new TemplateBean();
                templateBean.setMacroName(jsonObj.get((Object)"macroname").toString());
                templateBean.setWikiSyntax(jsonObj.get((Object)"wikisyntax").toString());
                templateBean.setDescription(jsonObj.get((Object)"description").toString());
                templateBean.setLastUpdatedDate(simpleDateFormat.parse(jsonObj.get((Object)"lastUpdated").toString()));
                templateBean.setTemplateName(jsonObj.get((Object)"templatename").toString());
                templatesServiceObj.addAppfireTemplate(templateBean);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStreamReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)inputStreamReader);
    }

    public static void validateMacroXss(BandanaManager bandanaManager, I18NBeanFactory i18NBeanFactory, String data) throws MacroExecutionException {
        if (!GraphvizUtils.allowJavascript(bandanaManager) && ScriptUtils.hasXssContent((String)data)) {
            throw new MacroExecutionException(i18NBeanFactory.getI18NBean().getText("com.atlassian.confluence.extra.graphviz.config.info.javascript.disallowed-msg"));
        }
    }

    public static boolean allowJavascript(BandanaManager bandanaManager) {
        try {
            String allowJavascript = (String)bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "com.atlassian.confluence.extra.graphviz.config.allowJavascript");
            return !"off".equalsIgnoreCase(allowJavascript);
        }
        catch (Exception e) {
            log.error("Unable to retrieve previous allowJavascript config settings", (Throwable)e);
            return true;
        }
    }

    public static BufferedImage getUMLImage(String umlStr) {
        try {
            SourceStringReader reader = new SourceStringReader(umlStr);
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            DiagramDescription imageDesc = reader.outputImage((OutputStream)outStream);
            log.debug("Png Image desc {}", (Object)imageDesc.getDescription());
            byte[] bytes = outStream.toByteArray();
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            return ImageIO.read(is);
        }
        catch (IOException e) {
            log.error("I/O Error while processing UML data: {}", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Error while processing UML data : {}", (Throwable)e);
        }
        return null;
    }

    public static String getUMLSvg(String umlStr) {
        try {
            SourceStringReader reader = new SourceStringReader(umlStr);
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            DiagramDescription imageDesc = reader.outputImage((OutputStream)outStream, new FileFormatOption(FileFormat.SVG));
            log.debug("Svg Image desc {}", (Object)imageDesc.getDescription());
            return new String(outStream.toByteArray(), Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            log.error("I/O Error while processing UML data to svg: {}", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Error while processing UML data to svg: {}", (Throwable)e);
        }
        return null;
    }

    public static ProfileAnalyticsBean updateSensitiveProfileParams(ProfileBean profileBean) {
        ProfileAnalyticsBean profileAnalyticsBean = new ProfileAnalyticsBean();
        profileAnalyticsBean.setProfileType(profileBean.getProfileType());
        profileAnalyticsBean.setUser(StringUtils.isNotBlank((String)profileBean.getUser()));
        profileAnalyticsBean.setPassword(StringUtils.isNotBlank((String)profileBean.getPassword()));
        profileAnalyticsBean.setUrl(StringUtils.isNotBlank((String)profileBean.getUrl()));
        profileAnalyticsBean.setAccessToken(StringUtils.isNotBlank((String)profileBean.getAccessToken()));
        profileAnalyticsBean.setUrlParams(StringUtils.isNotBlank((String)profileBean.getUrlParams()));
        profileAnalyticsBean.setHeaderParams(StringUtils.isNotBlank((String)profileBean.getHeaderParams()));
        profileAnalyticsBean.setUserInUrlParams(StringUtils.contains((String)profileBean.getUrlParams(), (String)"$user"));
        profileAnalyticsBean.setPasswordInUrlParams(StringUtils.contains((String)profileBean.getUrlParams(), (String)"$password"));
        profileAnalyticsBean.setAccessTokenInUrlParams(StringUtils.contains((String)profileBean.getUrlParams(), (String)"$accessToken"));
        profileAnalyticsBean.setUserInHeaderParams(StringUtils.contains((String)profileBean.getHeaderParams(), (String)"$user"));
        profileAnalyticsBean.setPasswordInHeaderParams(StringUtils.contains((String)profileBean.getHeaderParams(), (String)"$password"));
        profileAnalyticsBean.setAccessTokenInHeaderParams(StringUtils.contains((String)profileBean.getHeaderParams(), (String)"$accessToken"));
        return profileAnalyticsBean;
    }

    public static ProfileEntity beanToProfileEntity(ProfileBean srcProfile, ProfileEntity destProfile, boolean create) throws Exception {
        if (!GraphvizUtils.shouldUpdate(srcProfile.getProfileName(), create)) {
            throw new MacroExecutionException("PROFILE_NAME cannot be null");
        }
        destProfile.setProfileName(srcProfile.getProfileName());
        if (GraphvizUtils.shouldUpdate(srcProfile.getUrl(), create)) {
            destProfile.setUrl(srcProfile.getUrl());
        }
        if (GraphvizUtils.shouldUpdate(srcProfile.getProfileType(), create)) {
            destProfile.setProfileType(srcProfile.getProfileType());
        }
        if (GraphvizUtils.shouldUpdate(srcProfile.getUser(), create)) {
            destProfile.setUser(srcProfile.getUser());
        }
        if (GraphvizUtils.shouldUpdate(srcProfile.getPassword(), create)) {
            String pwd = EncryptDecryptHelper.encryptText((String)srcProfile.getPassword());
            destProfile.setPassword(pwd);
        }
        if (GraphvizUtils.shouldUpdate(srcProfile.getAccessToken(), create)) {
            destProfile.setAccessToken(EncryptDecryptHelper.encryptText((String)srcProfile.getAccessToken()));
        }
        if (GraphvizUtils.shouldUpdate(srcProfile.getUrlParams(), create)) {
            destProfile.setUrlParams(srcProfile.getUrlParams());
        }
        if (GraphvizUtils.shouldUpdate(srcProfile.getHeaderParams(), create)) {
            destProfile.setHeaderParams(srcProfile.getHeaderParams());
        }
        return destProfile;
    }

    private static boolean shouldUpdate(String value, boolean create) {
        if (create) {
            return !StringUtils.isBlank((String)value);
        }
        return true;
    }

    public static boolean checkForhyperlinkTag(String message) {
        String hyperlinkTagPattern = "(?i)<a([^>]+)>(.+?)</a>";
        Pattern patternTag = Pattern.compile(hyperlinkTagPattern);
        Matcher matcherTag = patternTag.matcher(message);
        return matcherTag.find();
    }

    public static ArrayList<ProfileBean> getProfileBeansFromEntities(List<ProfileEntity> profileEntities) throws Exception {
        ArrayList<ProfileBean> templateList = new ArrayList<ProfileBean>();
        log.debug("profilesList : {}", (Object)profileEntities.size());
        if (profileEntities != null) {
            for (ProfileEntity profileEntity : profileEntities) {
                ProfileBean template = GraphvizUtils.profileEntityToBean(profileEntity);
                templateList.add(template);
            }
        }
        return templateList;
    }

    public static ProfileBean profileEntityToBean(ProfileEntity profileEntity) throws Exception {
        ProfileBean profileBean = new ProfileBean();
        profileBean.setID(profileEntity.getID());
        profileBean.setProfileName(profileEntity.getProfileName());
        profileBean.setUrl(profileEntity.getUrl());
        profileBean.setProfileType(profileEntity.getProfileType());
        profileBean.setUser(profileEntity.getUser());
        if (StringUtils.isNotBlank((String)profileEntity.getAccessToken())) {
            profileBean.setAccessToken(EncryptDecryptHelper.decryptText((String)profileEntity.getAccessToken(), (String)profileEntity.getAccessToken()));
        }
        if (StringUtils.isNotBlank((String)profileEntity.getPassword())) {
            profileBean.setPassword(EncryptDecryptHelper.decryptText((String)profileEntity.getPassword(), (String)profileEntity.getPassword()));
        }
        profileBean.setUrlParams(profileEntity.getUrlParams());
        profileBean.setUrl(profileEntity.getUrl());
        profileBean.setHeaderParams(profileEntity.getHeaderParams());
        return profileBean;
    }

    public static ProfileBean macroProfileEntityToBean(ProfileEntity profileEntity) throws Exception {
        ProfileBean profileBean = new ProfileBean();
        profileBean.setID(profileEntity.getID());
        profileBean.setProfileName(profileEntity.getProfileName());
        profileBean.setUrl(profileEntity.getUrl());
        profileBean.setProfileType(profileEntity.getProfileType());
        profileBean.setUser(profileEntity.getUser());
        profileBean.setPassword(profileEntity.getPassword());
        profileBean.setAccessToken(profileEntity.getAccessToken());
        profileBean.setUrlParams(profileEntity.getUrlParams());
        profileBean.setUrl(profileEntity.getUrl());
        profileBean.setHeaderParams(profileEntity.getHeaderParams());
        return profileBean;
    }

    public static boolean getConfigValue(BandanaManager bandanaManager, String bandanaKey, Boolean defaultValue) {
        String configValue = "";
        try {
            configValue = (String)bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), bandanaKey);
        }
        catch (Exception e) {
            log.error("Unable to retrieve previous config settings.", (Object)e.getMessage());
        }
        if (StringUtils.isBlank((String)configValue)) {
            return defaultValue;
        }
        return configValue.equalsIgnoreCase("on");
    }
}

