/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.graphviz.util;

import com.appfire.common.analytics.util.AnalyticEvent;
import com.appfire.common.analytics.util.AnalyticsHelper;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.datacentercompatibility.HostLicenseInformation;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.graphviz.bean.GlobalConfigBean;
import org.swift.confluence.graphviz.bean.ProfileAnalyticsBean;
import org.swift.confluence.graphviz.util.GraphvizUtils;
import org.swift.confluence.scriptutil.ScriptUtils;
import org.swift.confluence.scriptutil.bean.ProfileBean;

public class GraphvizAnalyticsHelper {
    private AnalyticsHelper analyticsHelper = null;
    private static final String SCRIPT = "script";
    static final Logger log = LoggerFactory.getLogger(GraphvizAnalyticsHelper.class);

    public GraphvizAnalyticsHelper(PluginLicenseManager licenseManager, HostLicenseInformation hostLicenseInformation) {
        this(new AnalyticsHelper(ScriptUtils.getHostInfo((HostLicenseInformation)hostLicenseInformation), ScriptUtils.getPluginInfo((PluginLicenseManager)licenseManager), ScriptUtils.getClientInfo(), GraphvizAnalyticsHelper.class.getClassLoader()));
    }

    public GraphvizAnalyticsHelper(AnalyticsHelper analyticsHelper) {
        this.analyticsHelper = analyticsHelper;
    }

    public void postAnalyticsEvent(AnalyticEvent.Event collectionName, String type) {
        try {
            if (collectionName != null) {
                HashMap<String, String> analyticsEventDataMap = new HashMap<String, String>();
                analyticsEventDataMap.put("type", type == null ? collectionName.getEvent() : type);
                this.analyticsHelper.postAnalyticsEvent(collectionName.getEvent(), analyticsEventDataMap);
            }
        }
        catch (Throwable e) {
            log.debug("Error while posting " + collectionName.getEvent() + " event analytics ", e);
        }
    }

    public void postGlobalConfigAnalyticsEvent(GlobalConfigBean configBean) {
        try {
            if (configBean != null) {
                HashMap<String, Object> analyticsEventDataMap = new HashMap<String, Object>();
                analyticsEventDataMap.put("type", AnalyticEvent.Event.GLOBALCONFIG.getEvent());
                analyticsEventDataMap.put("settings", configBean);
                this.analyticsHelper.postAnalyticsEvent(AnalyticEvent.Event.GLOBALCONFIG.getEvent(), analyticsEventDataMap);
            }
        }
        catch (Throwable e) {
            log.debug("Error while posting globalconfig event analytics", e);
        }
    }

    public void postNewMacroAnalytics(String macroName, Map<String, String> parameters) {
        if (parameters != null) {
            HashMap<String, String> paramMap = new HashMap<String, String>(parameters);
            HashMap<String, Object> analyticsEventDataMap = new HashMap<String, Object>();
            analyticsEventDataMap.put("type", AnalyticEvent.SubEvent.NEWMACRO.getEvent());
            analyticsEventDataMap.put("macroName", macroName);
            this.updateSensitiveParams(paramMap);
            analyticsEventDataMap.put("macroParams", paramMap);
            this.analyticsHelper.postAnalyticsEvent(AnalyticEvent.Event.MACRO.getEvent(), analyticsEventDataMap);
        }
    }

    public void postInstallUninstallEvent(AnalyticEvent.Event eventType) {
        this.postAnalyticsEvent(eventType, null);
    }

    public void postErrorEvent(String errorMessage) {
        try {
            HashMap<String, String> analyticsEventDataMap = new HashMap<String, String>();
            analyticsEventDataMap.put("type", AnalyticEvent.Event.ERROR.getEvent());
            analyticsEventDataMap.put("error", errorMessage);
            this.analyticsHelper.postAnalyticsEvent(AnalyticEvent.Event.ERROR.getEvent(), analyticsEventDataMap);
        }
        catch (Throwable e) {
            log.debug("Error while posting " + AnalyticEvent.Event.ERROR.getEvent() + " event analytics ", e);
        }
    }

    public Map<String, Object> convertToMap(Object bean) {
        ObjectMapper m = new ObjectMapper();
        Map beanMap = (Map)m.convertValue(bean, Map.class);
        return beanMap;
    }

    private void updateSensitiveParams(Map<String, String> parameters) {
        if (parameters.containsKey(SCRIPT)) {
            String scriptParamVal = parameters.get(SCRIPT);
            this.setSourceInutParam(scriptParamVal, parameters, SCRIPT);
        }
        if (parameters.containsKey("url")) {
            parameters.put("url", "true");
        }
        if (parameters.containsKey("user")) {
            parameters.put("user", "true");
        }
        if (parameters.containsKey("password")) {
            parameters.put("password", "true");
        }
    }

    public void setSourceInutParam(String sourceParam, Map<String, String> parameters, String inputSource) {
        try {
            int resourceType = ScriptUtils.getResourceType((String)sourceParam, (boolean)false);
            switch (resourceType) {
                case 1: {
                    parameters.put(inputSource, "file");
                    break;
                }
                case 4: {
                    parameters.put(inputSource, "attachment");
                    break;
                }
                case 3: {
                    parameters.put(inputSource, "template");
                    break;
                }
                case 2: {
                    parameters.put(inputSource, "url");
                }
            }
        }
        catch (MacroExecutionException e) {
            log.debug(e.getMessage());
        }
    }

    public void postProfileAddAnalyticsEvent(ProfileBean profileBean) {
        if (profileBean != null) {
            ProfileAnalyticsBean profileAnalyticsBean = GraphvizUtils.updateSensitiveProfileParams(profileBean);
            HashMap<String, Object> analyticsEventDataMap = new HashMap<String, Object>();
            analyticsEventDataMap.put("type", AnalyticEvent.SubEvent.ADDED.getEvent());
            analyticsEventDataMap.put("settings", profileAnalyticsBean);
            this.analyticsHelper.postAnalyticsEvent(AnalyticEvent.Event.PROFILE.getEvent(), analyticsEventDataMap);
        }
    }

    public void postProfileEditAnalyticsEvent(ProfileBean profileBean) {
        if (profileBean != null) {
            ProfileAnalyticsBean profileAnalyticsBean = GraphvizUtils.updateSensitiveProfileParams(profileBean);
            HashMap<String, Object> analyticsEventDataMap = new HashMap<String, Object>();
            analyticsEventDataMap.put("type", AnalyticEvent.SubEvent.UPDATED.getEvent());
            analyticsEventDataMap.put("settings", profileAnalyticsBean);
            this.analyticsHelper.postAnalyticsEvent(AnalyticEvent.Event.PROFILE.getEvent(), analyticsEventDataMap);
        }
    }

    public void postProfileDeleteAnalyticsEvent(ProfileBean profileBean) {
        if (profileBean != null) {
            ProfileAnalyticsBean profileAnalyticsBean = GraphvizUtils.updateSensitiveProfileParams(profileBean);
            HashMap<String, Object> analyticsEventDataMap = new HashMap<String, Object>();
            analyticsEventDataMap.put("type", AnalyticEvent.SubEvent.REMOVED.getEvent());
            analyticsEventDataMap.put("settings", profileAnalyticsBean);
            this.analyticsHelper.postAnalyticsEvent(AnalyticEvent.Event.PROFILE.getEvent(), analyticsEventDataMap);
        }
    }
}

