/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.graphviz.service;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.migration.app.AccessScope;
import com.atlassian.migration.app.gateway.AppCloudMigrationGateway;
import com.atlassian.migration.app.gateway.MigrationDetailsV1;
import com.atlassian.migration.app.listener.DiscoverableListener;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.swift.confluence.graphviz.service.ManageProfileService;
import org.swift.confluence.scriptutil.ScriptUtils;

@Component
@ExportAsService
public class AppMigrationServiceImpl
implements DiscoverableListener {
    private static final Logger log = LoggerFactory.getLogger(AppMigrationServiceImpl.class);
    private final BandanaManager bandanaManager;
    private final ManageProfileService profileService;

    @Inject
    public AppMigrationServiceImpl(BandanaManager bandanaManager, ManageProfileService profileService) {
        this.bandanaManager = bandanaManager;
        this.profileService = profileService;
    }

    public void onStartAppMigration(AppCloudMigrationGateway gateway, String transferId, MigrationDetailsV1 migrationDetails) {
        try {
            HashMap<String, String> configMap = new HashMap<String, String>();
            configMap.put("allowWhitelistedUrls", "on");
            configMap.put("sendStatistics", "on");
            configMap.put("com.atlassian.confluence.extra.graphviz.config.allowJavascript", "on");
            configMap.put("profiles", ScriptUtils.appDatatoJson((JsonObject)this.profileService.getProfilesForMigration()));
            HashMap<String, String> cloudKeysMap = new HashMap<String, String>();
            cloudKeysMap.put("allowWhitelistedUrls", "allowWhitelistedUrls");
            cloudKeysMap.put("com.atlassian.confluence.extra.graphviz.config.allowJavascript", "allowJavaScript");
            cloudKeysMap.put("sendStatistics", "sendStatistics");
            cloudKeysMap.put("profiles", "profiles");
            String jsonPayload = ScriptUtils.buildAppDataCustomToMigrate((BandanaManager)this.bandanaManager, (String)"com.atlassian.confluence.extra.graphviz.config", configMap, cloudKeysMap);
            log.info("onStartAppMigration GVIZ{}", (Object)jsonPayload);
            OutputStream globalConfigStream = gateway.createAppData(transferId);
            globalConfigStream.write(jsonPayload.getBytes());
            globalConfigStream.close();
        }
        catch (IOException e) {
            log.error("Error uploading graphviz app data to the cloud", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Error uploading graphviz app data to the cloud", (Throwable)e);
        }
    }

    public String getCloudAppKey() {
        return "com.atlassian.confluence.extra.graphviz";
    }

    public String getServerAppKey() {
        return "com.atlassian.confluence.extra.graphviz";
    }

    public Set<AccessScope> getDataAccessScopes() {
        return Stream.of(AccessScope.APP_DATA_OTHER, AccessScope.PRODUCT_DATA_OTHER, AccessScope.MIGRATION_TRACING_IDENTITY, AccessScope.MIGRATION_TRACING_PRODUCT).collect(Collectors.toCollection(HashSet::new));
    }
}

