/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.graphviz.rest;

import com.atlassian.confluence.importexport.resource.WritableDownloadResourceManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.graphviz.ao.domain.TemplateBean;
import org.swift.confluence.graphviz.ao.service.TemplatesService;
import org.swift.confluence.graphviz.util.GraphvizUtils;

@Path(value="/")
public class TemplatesResource {
    private final TemplatesService templatesService;
    private final Logger log = LoggerFactory.getLogger(TemplatesResource.class);
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final LocaleManager localeManager;
    @ComponentImport
    private final I18NBeanFactory i18NBeanFactory;
    GraphvizUtils graphvizUtils = null;

    public TemplatesResource(TemplatesService templatesService, UserManager userManager, I18NBeanFactory i18NBeanFactory, LocaleManager localeManager, WritableDownloadResourceManager writableDownloadResourceManager) {
        this.templatesService = templatesService;
        this.userManager = userManager;
        this.i18NBeanFactory = i18NBeanFactory;
        this.localeManager = localeManager;
        this.graphvizUtils = new GraphvizUtils();
    }

    @GET
    @Path(value="/templates")
    @Produces(value={"application/json"})
    public Response getTemplates(@QueryParam(value="macroName") String macroNameFilter) {
        ArrayList<Object> macroNameFilteredList = new ArrayList();
        try {
            if (this.userManager.getRemoteUserKey() == null) {
                return Response.status((int)403).build();
            }
            macroNameFilteredList = this.getAllTemplatesForMacro(macroNameFilter);
        }
        catch (Exception e) {
            String errorMessage = this.getI18nBean().getText("com.atlassian.confluence.extra.graphviz.config.error-loading-templates");
            this.log.error("Error loading templates ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errorMessage).build();
        }
        return Response.ok(macroNameFilteredList, (String)"application/json").build();
    }

    @GET
    @Path(value="/templatebody")
    @Produces(value={"application/json"})
    public Response getTemplateBody(@QueryParam(value="templateName") String templateName) {
        try {
            if (this.userManager.getRemoteUserKey() == null) {
                return Response.status((int)403).build();
            }
            TemplateBean templateBean = this.graphvizUtils.getTemplateMacroBody(templateName, this.templatesService);
            return Response.ok((Object)templateBean, (String)"application/json").build();
        }
        catch (Exception e) {
            String errorMessage = this.getI18nBean().getText("com.atlassian.confluence.extra.graphviz.config.error-loading-templates");
            this.log.error("Error loading templates ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errorMessage).build();
        }
    }

    @POST
    @Path(value="/template")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response addUserTemplate(TemplateBean templatesBean) throws Exception {
        try {
            if (this.userManager.getRemoteUserKey() == null || !this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
                return Response.status((int)403).build();
            }
            templatesBean.setLastUpdatedDate(new Date());
            return Response.ok(this.getAllTemplates(), (String)"application/json").build();
        }
        catch (Exception e) {
            if (e.getMessage().contains("Duplicate template name found")) {
                return Response.status((Response.Status)Response.Status.NOT_MODIFIED).entity((Object)e.getMessage()).build();
            }
            String errorMessage = this.getI18nBean().getText("com.atlassian.confluence.extra.graphviz.config.error-loading-templates");
            this.log.error("Error loading templates ", (Object)errorMessage);
            return Response.status((Response.Status)Response.Status.NOT_MODIFIED).entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="/template")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateUserTemplate(TemplateBean templatesBean) {
        try {
            if (this.userManager.getRemoteUserKey() == null || !this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
                return Response.status((int)403).build();
            }
            templatesBean.setId(templatesBean.getId());
            templatesBean.setLastUpdatedDate(new Date());
            return Response.ok(this.getAllTemplates(), (String)"application/json").build();
        }
        catch (Exception e) {
            String errorMessage = this.getI18nBean().getText("com.atlassian.confluence.extra.graphviz.config.error-loading-templates");
            this.log.error("Error loading templates ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_MODIFIED).entity((Object)errorMessage).build();
        }
    }

    @POST
    @Path(value="/deletetemplate")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response deleteTemplate(TemplateBean templatesBean) {
        try {
            if (this.userManager.getRemoteUserKey() == null || !this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
                return Response.status((int)403).build();
            }
            return Response.ok(this.getAllTemplates(), (String)"application/json").build();
        }
        catch (Exception e) {
            String errorMessage = this.getI18nBean().getText("com.atlassian.confluence.extra.graphviz.config.error-loading-templates");
            this.log.error("Error loading templates ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_MODIFIED).entity((Object)errorMessage).build();
        }
    }

    private ArrayList<TemplateBean> getAllTemplates() throws Exception {
        ArrayList<TemplateBean> templatesBeans = GraphvizUtils.getTemplateBeansFromEntities(this.templatesService.getAppfireTemplates());
        return templatesBeans;
    }

    private ArrayList<TemplateBean> getAllTemplatesForMacro(String macroNameFilter) throws Exception {
        ArrayList<TemplateBean> templatesList = new ArrayList<TemplateBean>();
        ArrayList<TemplateBean> tempList = GraphvizUtils.getTemplateBeansFromEntities(this.templatesService.getAppfireTemplates());
        for (TemplateBean templateBean : tempList) {
            if (!templateBean.getMacroName().equalsIgnoreCase(macroNameFilter)) continue;
            templatesList.add(templateBean);
        }
        return templatesList;
    }

    protected I18NBean getI18nBean() {
        return this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)AuthenticatedUserThreadLocal.get()));
    }
}

