/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.graphviz.rest;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.datacentercompatibility.HostLicenseInformation;
import com.atlassian.upm.datacentercompatibility.impl.CompatibilityHostLicenseInformation;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.graphviz.service.ManageProfileService;
import org.swift.confluence.graphviz.util.GraphvizAnalyticsHelper;
import org.swift.confluence.graphviz.util.GraphvizUtils;
import org.swift.confluence.scriptutil.EncryptDecryptHelper;
import org.swift.confluence.scriptutil.bean.ProfileBean;

@Path(value="/profile")
public class ProfileResource {
    @ComponentImport
    private final UserManager userManager;
    private final ManageProfileService manageProfileService;
    private final Logger log = LoggerFactory.getLogger(ProfileResource.class);
    private final BandanaManager bandanaManager;
    @ComponentImport
    private final PluginLicenseManager licenseManager;
    @ComponentImport
    private final I18nResolver i18nResolver;
    private final HostLicenseInformation hostLicenseInformation;

    public ProfileResource(UserManager userManager, ManageProfileService manageProfileService, BandanaManager bandanaManager, PluginLicenseManager licenseManager, @ComponentImport com.atlassian.upm.api.license.HostLicenseInformation upmHostLicenseInformation, @ComponentImport LicenseHandler licenseHandler, I18nResolver i18nResolver) {
        this.userManager = userManager;
        this.manageProfileService = manageProfileService;
        this.bandanaManager = bandanaManager;
        this.licenseManager = licenseManager;
        this.i18nResolver = i18nResolver;
        this.hostLicenseInformation = new CompatibilityHostLicenseInformation(upmHostLicenseInformation, licenseHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/profiles")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response addProfile(ProfileBean profileBean) {
        String errorMessage = null;
        try {
            if (this.userManager.getRemoteUserKey() == null || !this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
                Response response = Response.status((Response.Status)Response.Status.FORBIDDEN).build();
                return response;
            }
            boolean profileAlreadyExist = this.manageProfileService.checkProfileExists(profileBean.getProfileName());
            if (profileAlreadyExist) {
                this.log.error("Profile with name " + profileBean.getProfileName() + " already exists, please choose different name");
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.i18nResolver.getText("com.atlassian.confluence.extra.graphviz.profile.with.same.name.already.exists")).build();
                return response;
            }
            this.manageProfileService.addProfile(profileBean);
            Response response = Response.ok().build();
            return response;
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
            this.log.error("Error adding profile: {}", (Object)errorMessage);
            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
            return response;
        }
        finally {
            if (GraphvizUtils.getConfigValue(this.bandanaManager, "com.atlassian.confluence.extra.graphviz.config.sendStatistics", true)) {
                GraphvizAnalyticsHelper analyticsHelper = new GraphvizAnalyticsHelper(this.licenseManager, this.hostLicenseInformation);
                if (errorMessage == null) {
                    analyticsHelper.postProfileAddAnalyticsEvent(profileBean);
                } else {
                    analyticsHelper.postErrorEvent(errorMessage);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Produces(value={"application/json"})
    @Path(value="/profiles/{profileName}")
    public Response updateProfile(ProfileBean profileBean, @PathParam(value="profileName") String profileName) {
        String errorMessage = null;
        try {
            if (this.userManager.getRemoteUserKey() == null || !this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
                Response response = Response.status((Response.Status)Response.Status.FORBIDDEN).build();
                return response;
            }
            boolean profileAlreadyExists = this.manageProfileService.checkProfileExists(profileBean.getProfileName());
            if (profileAlreadyExists && !profileBean.getProfileName().equalsIgnoreCase(profileName)) {
                this.log.error("The profile " + profileBean.getProfileName() + " which is trying to update is already exists, please choose different name");
                Response analyticsHelper = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.i18nResolver.getText("com.atlassian.confluence.extra.graphviz.profile.use.of.existing.profile.name.not.allowed")).build();
                return analyticsHelper;
            }
            ProfileBean dbProfileBean = this.manageProfileService.getProfileBeanForProfileName(profileName);
            this.updateSecureFields(dbProfileBean, profileBean);
            this.manageProfileService.updateProfile(profileName, profileBean);
            Response analyticsHelper = Response.ok().build();
            return analyticsHelper;
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
            this.log.error("Error editing profile: {}", (Object)errorMessage);
            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
            return response;
        }
        finally {
            if (GraphvizUtils.getConfigValue(this.bandanaManager, "com.atlassian.confluence.extra.graphviz.config.sendStatistics", true)) {
                GraphvizAnalyticsHelper analyticsHelper = new GraphvizAnalyticsHelper(this.licenseManager, this.hostLicenseInformation);
                if (errorMessage == null) {
                    analyticsHelper.postProfileEditAnalyticsEvent(profileBean);
                } else {
                    analyticsHelper.postErrorEvent(errorMessage);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/profiles/{profileName}")
    public Response deleteProfile(@PathParam(value="profileName") String profileName) {
        String errorMessage = null;
        try {
            if (this.userManager.getRemoteUserKey() == null || !this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
                Response response = Response.status((Response.Status)Response.Status.FORBIDDEN).build();
                return response;
            }
            this.manageProfileService.deleteProfile(profileName);
            Response response = Response.ok().build();
            return response;
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
            this.log.error("Error deleting profile: {}", (Object)errorMessage);
            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
            return response;
        }
        finally {
            if (GraphvizUtils.getConfigValue(this.bandanaManager, "com.atlassian.confluence.extra.graphviz.config.sendStatistics", true)) {
                GraphvizAnalyticsHelper analyticsHelper = new GraphvizAnalyticsHelper(this.licenseManager, this.hostLicenseInformation);
                if (errorMessage == null) {
                    ProfileBean profileBean = new ProfileBean();
                    profileBean.setProfileName(profileName);
                    analyticsHelper.postProfileDeleteAnalyticsEvent(profileBean);
                } else {
                    analyticsHelper.postErrorEvent(errorMessage);
                }
            }
        }
    }

    @GET
    @Path(value="/macroprofiles")
    @Produces(value={"application/json"})
    public Response getMacroProfiles(@QueryParam(value="macroName") String macroNameFilter) {
        ArrayList<Object> profilesList = new ArrayList();
        try {
            profilesList = GraphvizUtils.getProfileBeansFromEntities(this.manageProfileService.getProfiles());
        }
        catch (Exception exception) {
            this.log.error("Unableto Retrieve Profileslist Please try again", (Object)exception.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exception.getMessage()).build();
        }
        TreeSet<String> sortedKeys = new TreeSet<String>();
        for (ProfileBean profileBean : profilesList) {
            sortedKeys.add(profileBean.getProfileName());
        }
        return Response.ok(sortedKeys, (String)"application/json").build();
    }

    private void updateSecureFields(ProfileBean dbProfileBean, ProfileBean profileBean) throws Exception {
        profileBean.setPassword(StringUtils.isBlank((String)profileBean.getPassword()) ? EncryptDecryptHelper.decryptText((String)dbProfileBean.getPassword()) : profileBean.getPassword());
        profileBean.setAccessToken(StringUtils.isBlank((String)profileBean.getAccessToken()) ? EncryptDecryptHelper.decryptText((String)dbProfileBean.getAccessToken()) : profileBean.getAccessToken());
    }
}

