/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.graphviz.listener;

import com.appfire.common.analytics.util.AnalyticEvent;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.event.events.content.page.async.PageCreatedEvent;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionHandler;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.upm.api.license.PluginLicenseEventRegistry;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.event.PluginLicenseAddedEvent;
import com.atlassian.upm.api.license.event.PluginLicenseUpdatedEvent;
import com.atlassian.upm.datacentercompatibility.HostLicenseInformation;
import com.atlassian.upm.datacentercompatibility.impl.CompatibilityHostLicenseInformation;
import java.io.File;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.swift.confluence.graphviz.ao.service.TemplatesService;
import org.swift.confluence.graphviz.util.GraphvizAnalyticsHelper;
import org.swift.confluence.graphviz.util.GraphvizUtils;
import org.swift.confluence.scriptutil.EncryptDecryptHelper;

@Component
public class GraphvizAnalyticsListener
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(GraphvizAnalyticsListener.class);
    private final EventPublisher eventPublisher;
    private final PageManager pageManager;
    @ComponentImport
    private final BandanaManager bandanaManager;
    @ComponentImport
    private final XhtmlContent xhtmlManager;
    private static final HashSet<String> setOfMacro = new HashSet();
    private final HostLicenseInformation hostLicenseInformation;
    private final TemplatesService templatesService;
    public static final String PLUGIN_KEY = "com.atlassian.confluence.extra.graphviz";
    @ComponentImport
    private final PluginLicenseEventRegistry pluginLicenseEventRegistry;
    private final GraphvizAnalyticsHelper graphvizAnalyticsHelper;
    @ComponentImport
    private final BootstrapManager bootstrapManager;

    @Autowired
    public GraphvizAnalyticsListener(@ComponentImport EventPublisher eventPublisher, @ComponentImport PluginLicenseManager pluginLicenseManager, BandanaManager bandanaManager, XhtmlContent xhtmlManager, PageManager pageManager, @ComponentImport com.atlassian.upm.api.license.HostLicenseInformation upmHostLicenseInformation, @ComponentImport LicenseHandler licenseHandler, TemplatesService templatesService, PluginLicenseEventRegistry pluginLicenseEventRegistry, BootstrapManager bootstrapManager) {
        this.eventPublisher = eventPublisher;
        this.eventPublisher.register((Object)this);
        this.bandanaManager = bandanaManager;
        this.xhtmlManager = xhtmlManager;
        this.pageManager = pageManager;
        this.bootstrapManager = bootstrapManager;
        this.templatesService = templatesService;
        this.pluginLicenseEventRegistry = pluginLicenseEventRegistry;
        this.pluginLicenseEventRegistry.register((Object)this);
        this.hostLicenseInformation = new CompatibilityHostLicenseInformation(upmHostLicenseInformation, licenseHandler);
        this.graphvizAnalyticsHelper = new GraphvizAnalyticsHelper(pluginLicenseManager, this.hostLicenseInformation);
    }

    @PluginEventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        try {
            String filePrefix = PLUGIN_KEY;
            String confluenceSharedHome = this.bootstrapManager.getSharedHome().getAbsolutePath();
            String pluginFolderPath = confluenceSharedHome + File.separator + filePrefix;
            EncryptDecryptHelper.initialize((String)pluginFolderPath, (String)filePrefix);
        }
        catch (Exception e) {
            log.error("Error while generating encryption keys ", (Object)e.getMessage());
        }
        Plugin thisPlugin = event.getPlugin();
        try {
            if (thisPlugin.getKey().equalsIgnoreCase(PLUGIN_KEY)) {
                GraphvizUtils.loadAppfireTemplates(this.templatesService);
                this.graphvizAnalyticsHelper.postInstallUninstallEvent(AnalyticEvent.Event.INSTALL);
            }
        }
        catch (IllegalStateException e) {
            log.error("Hibernate session not yet ready : {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            log.debug("Error in Analytics Listener : {}", (Object)e.getMessage());
        }
    }

    public void destroy() throws Exception {
        this.graphvizAnalyticsHelper.postInstallUninstallEvent(AnalyticEvent.Event.UNINSTALL);
        log.info("destroy called");
        this.eventPublisher.unregister((Object)this);
        this.pluginLicenseEventRegistry.unregister((Object)this);
    }

    @EventListener
    public void onPageCreateEvent(PageCreatedEvent e) {
        if (this.getSendStatistics().equalsIgnoreCase("on")) {
            try {
                this.xhtmlManager.handleMacroDefinitions(this.pageManager.getPage(e.getPageId().longValue()).getBodyAsString(), (ConversionContext)new DefaultConversionContext(new RenderContext()), new MacroDefinitionHandler(){

                    public void handle(MacroDefinition macroDefinition) {
                        String macroName = macroDefinition.getName();
                        try {
                            if (setOfMacro.contains(macroName)) {
                                GraphvizAnalyticsListener.this.graphvizAnalyticsHelper.postNewMacroAnalytics(macroDefinition.getName(), macroDefinition.getParameters());
                            }
                        }
                        catch (Exception ex) {
                            log.debug("Exception while posting analytics event for macro : " + macroName, (Throwable)ex);
                        }
                    }
                });
            }
            catch (Exception ex) {
                log.debug("Exception while handling create macro events for analytics ", (Throwable)ex);
            }
        }
    }

    @EventListener
    public void onEvent(PluginLicenseAddedEvent event) {
        this.graphvizAnalyticsHelper.postAnalyticsEvent(AnalyticEvent.Event.LICENSED, AnalyticEvent.SubEvent.LICENSEADDED.getEvent());
    }

    @EventListener
    public void onEvent(PluginLicenseUpdatedEvent event) {
        this.graphvizAnalyticsHelper.postAnalyticsEvent(AnalyticEvent.Event.LICENSED, AnalyticEvent.SubEvent.LICENSEUPDATED.getEvent());
    }

    public void afterPropertiesSet() throws Exception {
    }

    private String getSendStatistics() {
        String sendStatistics = null;
        try {
            sendStatistics = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "com.atlassian.confluence.extra.graphviz.config.sendStatistics");
        }
        catch (Exception exception) {
            log.debug("Exception while getting sendStatistics", (Throwable)exception);
        }
        if (sendStatistics == null) {
            sendStatistics = "on";
        }
        log.debug("retrieved sendStatistics: {}", (Object)sendStatistics);
        return sendStatistics;
    }

    static {
        setOfMacro.add("graphviz");
        setOfMacro.add("graph-from-table");
        setOfMacro.add("flowchart");
        setOfMacro.add("graph");
        setOfMacro.add("digraph");
        setOfMacro.add("spacegraph");
        setOfMacro.add("plantuml");
    }
}

