/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.graphviz.config;

import com.appfire.common.analytics.util.AnalyticEvent;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.datacentercompatibility.HostLicenseInformation;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.graphviz.ao.domain.TemplateBean;
import org.swift.confluence.graphviz.ao.service.TemplatesService;
import org.swift.confluence.graphviz.bean.GlobalConfigBean;
import org.swift.confluence.graphviz.service.ManageProfileService;
import org.swift.confluence.graphviz.util.GraphvizAnalyticsHelper;
import org.swift.confluence.graphviz.util.GraphvizUtils;
import org.swift.confluence.scriptutil.bean.ProfileBean;

public class ConfigurePluginAction
extends ConfluenceActionSupport {
    private static final long serialVersionUID = 1L;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private HostLicenseInformation hostLicenseInformation;
    public String sendStatistics;
    public String prevSendStatistics;
    public String allowWhitelistedUrls;
    public String allowJavascript;
    public String blacklistDomains;
    public String confirm;
    private String itestAllow;
    private BandanaManager bandanaManager;
    private PluginLicenseManager licenseManager;
    private TemplatesService templatesService;
    private static final ConfluenceBandanaContext bandanaContext = new ConfluenceBandanaContext();
    private ManageProfileService manageProfileService;

    public void setManageProfileService(ManageProfileService manageProfileService) {
        this.manageProfileService = manageProfileService;
    }

    public void setPluginLicenseManager(PluginLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public void setTemplatesService(TemplatesService templatesService) {
        this.templatesService = templatesService;
    }

    public String input() {
        return "input";
    }

    public String save() throws Exception {
        GraphvizAnalyticsHelper helper = new GraphvizAnalyticsHelper(this.licenseManager, this.hostLicenseInformation);
        GlobalConfigBean configBean = null;
        String result = "success";
        HttpServletRequest request = ServletContextThreadLocal.getRequest();
        if (request.getMethod().equalsIgnoreCase("GET") && !"true".equals(this.itestAllow)) {
            this.addActionError(this.getText("com.atlassian.confluence.extra.graphviz.config.operation-not-supported"));
            return "error";
        }
        if (this.confirm != null && this.confirm.equalsIgnoreCase("true")) {
            if (!this.setSendStatistics()) {
                result = "error";
            }
            if (!this.setAllowWhitelistedUrls()) {
                result = "error";
            }
            if (!this.setAllowJavascript()) {
                result = "error";
            }
            if (!this.setBlacklistDomains()) {
                result = "error";
            }
            if (result.equals("success")) {
                this.addActionMessage(this.getText("com.atlassian.confluence.extra.graphviz.config.settings-saved"));
            }
        } else {
            this.addActionError(this.getText("com.atlassian.confluence.extra.graphviz.config.settings-couldnotsave-loginexpired"));
            helper.postErrorEvent(String.join((CharSequence)", ", this.getActionErrors()));
            result = "error";
        }
        AnalyticEvent.SubEvent subType = null;
        boolean firstTimeFlag = this.checkIfFirstTimeConfigSaving();
        if (result.equals("success") && firstTimeFlag) {
            subType = AnalyticEvent.SubEvent.ADDED;
        } else if (result.equals("success") && (this.getSendStatistics().equalsIgnoreCase("on") || this.getSendStatistics().equalsIgnoreCase("off") && this.getPrevSendStatistics().equalsIgnoreCase("on"))) {
            subType = AnalyticEvent.SubEvent.UPDATED;
        }
        if (subType != null) {
            configBean = this.buildConfigBean();
            helper.postGlobalConfigAnalyticsEvent(configBean);
        }
        return result;
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public String restoreDefaults() {
        String result = "success";
        try {
            this.bandanaManager.removeValue((BandanaContext)bandanaContext, this.sendStatistics);
        }
        catch (Exception exception) {
            this.log.debug("Ignore exception restoring default config: {}", (Object)exception.toString());
        }
        return result;
    }

    public void setItestAllow(String str) {
        this.itestAllow = str;
    }

    public String getSendStatistics() {
        try {
            this.sendStatistics = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "com.atlassian.confluence.extra.graphviz.config.sendStatistics");
        }
        catch (Exception exception) {
            this.log.error(exception.getMessage());
            this.addActionError(this.getText("com.atlassian.confluence.extra.graphviz.config.unableto-retrieve-previous-sendstatistics-setting"));
        }
        if (this.sendStatistics == null) {
            this.sendStatistics = "on";
        }
        this.log.debug("retrieved sendStatistics: {}", (Object)this.sendStatistics);
        return this.sendStatistics;
    }

    public boolean setSendStatistics() {
        boolean success = true;
        this.prevSendStatistics = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "com.atlassian.confluence.extra.graphviz.config.sendStatistics");
        this.log.debug("saving: {}", (Object)this.sendStatistics);
        try {
            if (this.sendStatistics == null) {
                this.sendStatistics = "off";
            }
            this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "com.atlassian.confluence.extra.graphviz.config.sendStatistics", (Object)this.sendStatistics);
        }
        catch (Exception exception) {
            this.log.error(exception.getMessage());
            this.addActionError(this.getText("com.atlassian.confluence.extra.graphviz.config.cannot-store-sendstatistics-tryagain", "com.atlassian.confluence.extra.graphviz.config.sendStatistics"));
            success = false;
        }
        finally {
            if (!success) {
                GraphvizAnalyticsHelper helper = new GraphvizAnalyticsHelper(this.licenseManager, this.hostLicenseInformation);
                helper.postErrorEvent(String.join((CharSequence)", ", this.getActionErrors()));
            }
        }
        return success;
    }

    public String getAllowWhitelistedUrls() {
        try {
            this.allowWhitelistedUrls = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "com.atlassian.confluence.extra.graphviz.config.allowWhitelistedUrls");
        }
        catch (Exception exception) {
            this.addActionError(this.getText("com.atlassian.confluence.extra.graphviz.config.unableto-retrieve-previous-allowwhitelistedurls-setting"));
        }
        if (this.allowWhitelistedUrls == null) {
            this.allowWhitelistedUrls = "on";
        }
        this.log.debug("retrieved allowWhitelistedUrls: {}", (Object)this.allowWhitelistedUrls);
        return this.allowWhitelistedUrls;
    }

    public boolean setAllowWhitelistedUrls() {
        boolean success = true;
        this.log.debug("saving: {}", (Object)this.allowWhitelistedUrls);
        try {
            if (this.allowWhitelistedUrls == null) {
                this.allowWhitelistedUrls = "off";
            }
            this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "com.atlassian.confluence.extra.graphviz.config.allowWhitelistedUrls", (Object)this.allowWhitelistedUrls);
        }
        catch (Exception exception) {
            this.addActionError(this.getText("com.atlassian.confluence.extra.graphviz.config.cannot-store-allowwhitelistedurls-tryagain", "com.atlassian.confluence.extra.graphviz.config.allowWhitelistedUrls"));
            success = false;
        }
        finally {
            if (!success) {
                GraphvizAnalyticsHelper helper = new GraphvizAnalyticsHelper(this.licenseManager, this.hostLicenseInformation);
                helper.postErrorEvent(String.join((CharSequence)", ", this.getActionErrors()));
            }
        }
        return success;
    }

    public String getAllowJavascript() {
        try {
            this.allowJavascript = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "com.atlassian.confluence.extra.graphviz.config.allowJavascript");
        }
        catch (Exception exception) {
            this.addActionError(this.getText("com.atlassian.confluence.extra.graphviz.config.unableto-retrieve-previous-allowjavascript-setting"));
        }
        if (this.allowJavascript == null) {
            this.allowJavascript = "on";
        }
        this.log.debug("retrieved allowJavascript: {}", (Object)this.allowJavascript);
        return this.allowJavascript;
    }

    public boolean setAllowJavascript() {
        boolean success = true;
        this.log.debug("saving: {}", (Object)this.allowJavascript);
        try {
            if (this.allowJavascript == null) {
                this.allowJavascript = "off";
            }
            this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "com.atlassian.confluence.extra.graphviz.config.allowJavascript", (Object)this.allowJavascript);
        }
        catch (Exception exception) {
            this.addActionError(this.getText("com.atlassian.confluence.extra.graphviz.config.cannot-store-allowjavascript-tryagain", "com.atlassian.confluence.extra.graphviz.config.allowJavascript"));
            success = false;
        }
        finally {
            if (!success) {
                GraphvizAnalyticsHelper helper = new GraphvizAnalyticsHelper(this.licenseManager, this.hostLicenseInformation);
                helper.postErrorEvent(String.join((CharSequence)", ", this.getActionErrors()));
            }
        }
        return success;
    }

    public String getBlacklistDomains() {
        try {
            this.blacklistDomains = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "com.atlassian.confluence.extra.graphviz.config.blacklistDomains");
        }
        catch (Exception exception) {
            this.addActionError(this.getText("com.atlassian.confluence.extra.graphviz.config.unableto-retrieve-previous-blacklistdomains-setting"));
        }
        if (this.blacklistDomains == null) {
            this.blacklistDomains = "off";
        }
        this.log.debug("retrieved blacklistDomains: {}", (Object)this.blacklistDomains);
        return this.blacklistDomains;
    }

    public boolean setBlacklistDomains() {
        boolean success = true;
        this.log.debug("saving: {}", (Object)this.blacklistDomains);
        try {
            if (this.blacklistDomains == null) {
                this.blacklistDomains = "off";
            }
            this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "com.atlassian.confluence.extra.graphviz.config.blacklistDomains", (Object)this.blacklistDomains);
        }
        catch (Exception exception) {
            this.addActionError(this.getText("com.atlassian.confluence.extra.graphviz.config.cannot-store-blacklistdomains-tryagain", "com.atlassian.confluence.extra.graphviz.config.blacklistDomains"));
            success = false;
        }
        finally {
            if (!success) {
                GraphvizAnalyticsHelper helper = new GraphvizAnalyticsHelper(this.licenseManager, this.hostLicenseInformation);
                helper.postErrorEvent(String.join((CharSequence)", ", this.getActionErrors()));
            }
        }
        return success;
    }

    public boolean checkIfFirstTimeConfigSaving() {
        boolean firstTimeFlag = false;
        try {
            ConfluenceBandanaContext banadanContext = new ConfluenceBandanaContext();
            firstTimeFlag = (String)this.bandanaManager.getValue((BandanaContext)banadanContext, "com.atlassian.confluence.extra.graphviz.config.sendStatistics") == null;
        }
        catch (Exception e) {
            firstTimeFlag = true;
        }
        return firstTimeFlag;
    }

    private GlobalConfigBean buildConfigBean() {
        this.log.debug("building config bean");
        GlobalConfigBean configBean = new GlobalConfigBean();
        configBean.setSendStatistics(this.isSendStatisticsEnabled());
        configBean.setAllowWhitelistedUrls(this.isAllowWhitelistsEnabled());
        configBean.setAllowJavascript(this.isAllowJavascriptEnabled());
        configBean.setBlacklistDomains(this.isBlacklistDomainsEnabled());
        return configBean;
    }

    public boolean isAllowWhitelistsEnabled() {
        return this.getAllowWhitelistedUrls().equalsIgnoreCase("on");
    }

    public boolean isSendStatisticsEnabled() {
        return this.getSendStatistics().equalsIgnoreCase("on");
    }

    public boolean isAllowJavascriptEnabled() {
        return this.getAllowJavascript().equalsIgnoreCase("on");
    }

    public boolean isBlacklistDomainsEnabled() {
        return this.getBlacklistDomains().equalsIgnoreCase("on");
    }

    public String getPrevSendStatistics() {
        if (this.prevSendStatistics == null) {
            this.prevSendStatistics = "on";
        }
        return this.prevSendStatistics;
    }

    public void setHostLicenseInformation(HostLicenseInformation hostLicenseInformation) {
        this.hostLicenseInformation = hostLicenseInformation;
    }

    public ArrayList<TemplateBean> getTemplatesList() {
        ArrayList<TemplateBean> templatesFromAO = new ArrayList();
        try {
            templatesFromAO = GraphvizUtils.getTemplateBeansFromEntities(this.templatesService.getAppfireTemplates());
        }
        catch (Exception e) {
            this.addActionError(this.getText("com.atlassian.confluence.extra.graphviz.config.unableto-retrieve-templateslist-please-tryagain"));
            this.log.error(e.getMessage(), (Throwable)e);
        }
        Collections.sort(templatesFromAO, new Comparator<TemplateBean>(){

            @Override
            public int compare(TemplateBean templateBean1, TemplateBean templateBean2) {
                return templateBean1.getMacroName().compareTo(templateBean2.getMacroName());
            }
        });
        return templatesFromAO;
    }

    public List<ProfileBean> getProfilesList() {
        ArrayList<ProfileBean> profilesList = new ArrayList();
        try {
            profilesList = GraphvizUtils.getProfileBeansFromEntities(this.manageProfileService.getProfiles());
        }
        catch (Exception e) {
            this.addActionError(this.getText("com.atlassian.confluence.extra.graphviz.unableto-retrieve-profileslist-please-tryagain"));
            this.log.error(e.getMessage(), (Throwable)e);
        }
        Collections.sort(profilesList, new Comparator<ProfileBean>(){

            @Override
            public int compare(ProfileBean profileBean1, ProfileBean profileBean2) {
                return profileBean1.getProfileName().compareTo(profileBean2.getProfileName());
            }
        });
        return profilesList;
    }
}

