/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.graphviz.ao.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.java.ao.DBParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.swift.confluence.graphviz.ao.domain.TemplateBean;
import org.swift.confluence.graphviz.ao.entity.AppfireTemplateEntity;
import org.swift.confluence.graphviz.ao.service.TemplatesService;

@Component
public class TemplatesServiceImpl
implements TemplatesService {
    @ComponentImport
    private final LocaleManager localeManager;
    @ComponentImport
    private final I18NBeanFactory i18NBeanFactory;
    private static Logger logger = LoggerFactory.getLogger(TemplatesServiceImpl.class);
    @ComponentImport
    private final ActiveObjects activeObjects;

    @Autowired
    public TemplatesServiceImpl(ActiveObjects activeObjects, LocaleManager localeManager, I18NBeanFactory i18NBeanFactory) {
        this.activeObjects = activeObjects;
        this.localeManager = localeManager;
        this.i18NBeanFactory = i18NBeanFactory;
    }

    @Override
    public List<AppfireTemplateEntity> getAppfireTemplates() {
        List<AppfireTemplateEntity> appfireTemplatesEntities = Collections.emptyList();
        try {
            appfireTemplatesEntities = Arrays.asList((AppfireTemplateEntity[])this.activeObjects.find(AppfireTemplateEntity.class));
        }
        catch (Exception exception) {
            logger.debug("Error while retrieving the details", (Throwable)exception);
        }
        return appfireTemplatesEntities;
    }

    protected I18NBean getI18nBean() {
        return this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)AuthenticatedUserThreadLocal.get()));
    }

    @Override
    public void deleteAppfireTemplates() throws Exception {
        try {
            this.activeObjects.delete(this.activeObjects.find(AppfireTemplateEntity.class));
        }
        catch (Exception exception) {
            logger.error(this.getI18nBean().getText("com.atlassian.confluence.extra.graphviz.config.error-while-deleting-appfire-templates"), (Throwable)exception);
            throw exception;
        }
    }

    @Override
    public void addAppfireTemplate(TemplateBean templatesBean) throws Exception {
        try {
            AppfireTemplateEntity destTemplateEntity = (AppfireTemplateEntity)this.activeObjects.create(AppfireTemplateEntity.class, new DBParam[]{new DBParam("TEMPLATE_NAME", (Object)templatesBean.getTemplateName())});
            destTemplateEntity.setLastUpdated(templatesBean.getLastUpdatedDate());
            destTemplateEntity.setMacroName(templatesBean.getMacroName());
            destTemplateEntity.setTemplateName(templatesBean.getTemplateName());
            destTemplateEntity.setDescription(templatesBean.getDescription());
            destTemplateEntity.setWikiSyntax(templatesBean.getWikiSyntax());
            destTemplateEntity.save();
        }
        catch (Exception exception) {
            logger.error(this.getI18nBean().getText("com.atlassian.confluence.extra.graphviz.config.error-while-adding-appfire-templates"), (Throwable)exception);
            throw exception;
        }
    }
}

