/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.graphviz;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.importexport.resource.WritableDownloadResourceManager;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.links.OutgoingLink;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.pages.thumbnail.ThumbnailManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.graphviz.BaseGraphvizMacro;
import org.swift.confluence.graphviz.ao.service.TemplatesService;
import org.swift.confluence.graphviz.service.ManageProfileService;
import org.swift.confluence.macroutil.MacroInfo;
import org.swift.confluence.scriptutil.ScriptUtils;

public class SpaceGraphMacro
extends BaseGraphvizMacro {
    protected final boolean EXEMPT_DEVELOPER_LICENSE = true;
    private static final Logger log = LoggerFactory.getLogger(SpaceGraphMacro.class);
    protected final int DEPTH_DEFAULT = 3;
    @ComponentImport
    protected LabelManager labelManager;

    public SpaceGraphMacro(SettingsManager settingsManager, BootstrapManager bootstrapManager, PageTemplateManager templateManager, SpaceManager spaceManager, PageManager pageManager, PermissionManager permissionManager, AttachmentManager attachmentManager, LocaleManager localeManager, I18NBeanFactory i18NBeanFactory, PluginLicenseManager licenseManager, XhtmlContent xhtmlContent, SubRenderer subRenderer, WritableDownloadResourceManager downloadResourceManager, ThumbnailManager thumbnailManager, LabelManager labelManager, BandanaManager bandanaManager, TemplatesService templatesService, ManageProfileService manageProfileService, UserAccessor userAccessor, @ComponentImport I18nResolver i18nResolver, PluginAccessor pluginAccessor) {
        super(settingsManager, bootstrapManager, templateManager, spaceManager, pageManager, permissionManager, attachmentManager, localeManager, i18NBeanFactory, licenseManager, xhtmlContent, subRenderer, downloadResourceManager, thumbnailManager, bandanaManager, templatesService, manageProfileService, userAccessor, i18nResolver, pluginAccessor);
        this.labelManager = labelManager;
    }

    @Override
    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public String execute(MacroInfo info) throws MacroExecutionException {
        List<Page> pages;
        String startPage;
        this.validateLicense(this.licenseManager);
        String directionString = "rankdir=" + (info.getMacroParams().getString("direction", "").equalsIgnoreCase("TB") ? "TB; " : "LR; ");
        boolean showOutgoingLinks = ScriptUtils.getBoolean((String)"showoutgoinglinks", (boolean)false, (MacroInfo)info);
        String spaceKey = info.getMacroParams().getString("space", info.getMacroParams().getString("0", info.getConversionContext().getPageContext().getSpaceKey()));
        Space space = this.getSpace(spaceKey);
        String output = info.getMacroParams().getString("output", "png").toLowerCase();
        boolean isSvg = output.equalsIgnoreCase("svg");
        boolean isPdf = output.equalsIgnoreCase("pdf");
        boolean asAttachment = !"".equals(info.getMacroParams().getString("attachment", ""));
        String urlPrefix = this.getUrlPrefix(info, true, !isSvg && !isPdf || !asAttachment);
        ArrayList<Long> labelIdList = null;
        String labels = info.getMacroParams().getString("labels", info.getMacroParams().getString("label", "")).trim();
        if (!labels.equals("")) {
            String[] labelArray;
            labelIdList = new ArrayList<Long>();
            for (String label : labelArray = labels.split("\\s+")) {
                if ((label = label.trim()).equals("")) continue;
                Label theLabel = this.labelManager.getLabel(LabelParser.parse((String)label));
                if (theLabel != null) {
                    labelIdList.add(theLabel.getId());
                    log.debug("label: " + label + ", theLabel: " + theLabel.getName());
                }
                log.debug("label: " + label + ", theLabel: " + theLabel);
            }
        }
        if ((startPage = info.getMacroParams().getString("page", null)) != null) {
            int depth = info.getMacroParams().getInteger("depth", Integer.valueOf(3));
            pages = new ArrayList<Page>();
            Page page = this.getPageWithSpecialValueHandling(startPage, info.getConversionContext().getPageContext(), spaceKey);
            if (depth > 0) {
                pages.add(page);
                this.addChildrenToList(page, pages, depth);
            } else {
                pages = this.pageManager.getDescendents(page);
                pages.add(page);
            }
        } else {
            pages = this.pageManager.getPages(space, true);
        }
        StringBuilder dotCommand = new StringBuilder();
        for (Page page : pages) {
            if (!this.isViewPermitted(page) || !this.includePage(page, labelIdList)) continue;
            this.addPage(dotCommand, page, "", urlPrefix);
            List children = page.getChildren();
            for (Page child : children) {
                if (!pages.contains(child) || !this.includePage(child, labelIdList)) continue;
                dotCommand.append("\"").append(this.escapeString(page.getTitle())).append("\" -> ").append("\"").append(this.escapeString(child.getTitle())).append("\";\n");
            }
            if (!showOutgoingLinks) continue;
            List outgoingLinks = page.getOutgoingLinks();
            for (OutgoingLink link : outgoingLinks) {
                String destPageTitle;
                Page destinationPage;
                String prefix = "";
                String destSpaceKey = link.getDestinationSpaceKey();
                Space destSpace = this.spaceManager.getSpace(destSpaceKey);
                if (destSpace == null) continue;
                if (!link.getDestinationSpaceKey().equals(spaceKey)) {
                    prefix = destSpace.getName() + ": ";
                }
                if ((destinationPage = this.pageManager.getPage(destSpaceKey, destPageTitle = link.getDestinationPageTitle())) == null || !this.isViewPermitted(destinationPage) || !this.includePage(destinationPage, labelIdList)) continue;
                if (!prefix.equals("")) {
                    this.addPage(dotCommand, destinationPage, prefix, urlPrefix);
                }
                dotCommand.append("\"").append(this.escapeString(page.getTitle())).append("\" -> ").append("\"").append(prefix).append(this.escapeString(destinationPage.getTitle())).append("\" [style=dashed];\n");
            }
        }
        String defaults = "pack = \"true\"; edge [arrowsize=0.4]; " + this.getConfluenceNodeAttributes(info, 8);
        return this.processDotCommands(info, "digraph { " + directionString + defaults + "\n" + dotCommand.toString() + "\n}", 1, 1);
    }

    private boolean includePage(Page page, List<Long> labelIdList) {
        boolean result;
        boolean bl = result = labelIdList == null;
        if (!result) {
            Label label;
            List pageLabels = page.getLabels();
            Iterator iterator = pageLabels.iterator();
            while (iterator.hasNext() && !(result = labelIdList.contains((label = (Label)iterator.next()).getId()))) {
            }
            log.debug("result: " + result + ", labelIdList: " + labelIdList);
        }
        return result;
    }

    private void addPage(StringBuilder builder, Page page, String prefix, String urlPrefix) {
        String nodeName = prefix + this.escapeString(page.getTitle());
        String label = nodeName.replaceAll(" +", "\\\\n");
        builder.append("\"").append(nodeName).append("\" [URL=\"").append(this.getUrl(page, urlPrefix)).append("\", label=\"").append(label).append("\" tooltip=\"").append(nodeName).append("\"];\n");
    }

    private String escapeString(String string) {
        return StringUtils.replace((String)StringUtils.replace((String)string, (String)"\\", (String)"\\\\"), (String)"\"", (String)"\\\"");
    }

    private String getUrl(Page page, String urlPrefix) {
        return urlPrefix + "/pages/viewpage.action?pageId=" + page.getId();
    }

    private void addChildrenToList(Page page, List<Page> pages, int depth) {
        if (page != null && depth > 0) {
            log.debug("for page: {}, depth: {}", (Object)page.getTitle(), (Object)depth);
            List children = page.getChildren();
            for (Page child : children) {
                pages.add(child);
                this.addChildrenToList(child, pages, depth - 1);
            }
        }
    }
}

