/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.graphviz;

import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.graphviz.DotRunner;
import org.swift.confluence.graphviz.util.GraphvizUtils;
import org.swift.confluence.scriptutil.RunnableStreamReader;

public class GraphvizImageDownloadResource
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    String markupSyntax;
    String output = "png";
    String urlString = null;
    DotRunner dotRunner;
    private static final Logger log = LoggerFactory.getLogger(GraphvizImageDownloadResource.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String macroName = httpServletRequest.getParameter("macroName");
        String wikiSyntax = httpServletRequest.getParameter("wikiSyntax");
        Image bufferedImage = null;
        log.debug("macroName :" + macroName + "  wikiSyntax " + wikiSyntax);
        this.markupSyntax = GraphvizUtils.getUpdatedSyntax(wikiSyntax, macroName);
        try {
            this.dotRunner = GraphvizUtils.getRunner(this.markupSyntax, this.output, "dot", RunnableStreamReader.Type.IMAGE);
            bufferedImage = this.dotRunner.getImage();
            httpServletResponse.setContentType("image/png");
            ImageIO.write((RenderedImage)((Object)bufferedImage), this.output, (OutputStream)httpServletResponse.getOutputStream());
        }
        catch (Exception exception) {
            log.error("Error while loading an image", (Throwable)exception);
        }
        finally {
            if (bufferedImage != null) {
                bufferedImage.flush();
            }
        }
    }
}

