/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.graphviz;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.swift.confluence.graphviz.GraphData;
import org.swift.confluence.graphviz.util.GraphvizUtils;
import org.swift.confluence.macroutil.MacroInfo;
import org.swift.confluence.scriptutil.LicensedScriptMacroWithLegacyRender;
import org.swift.confluence.scriptutil.ScriptUtils;

public class GraphFromTableMacro
extends LicensedScriptMacroWithLegacyRender {
    protected final boolean ExemptDeveloperLicense = true;
    protected static final RenderMode RENDER_MODE = RenderMode.allow((long)1028L);
    private static final RenderMode RENDER_MODE_WIKI = RenderMode.suppress((long)256L);
    private static final String eolString = System.getProperty("line.separator");
    private static final int columnListLength = 9;
    protected final BandanaManager bandanaManager;

    public GraphFromTableMacro(SettingsManager settingsManager, BootstrapManager bootstrapManager, PageTemplateManager templateManager, SpaceManager spaceManager, PageManager pageManager, PermissionManager permissionManager, AttachmentManager attachmentManager, LocaleManager localeManager, I18NBeanFactory i18NBeanFactory, PluginLicenseManager licenseManager, XhtmlContent xhtmlContent, SubRenderer subRenderer, BandanaManager bandanaManager) {
        super(settingsManager, bootstrapManager, templateManager, spaceManager, pageManager, permissionManager, attachmentManager, localeManager, i18NBeanFactory, licenseManager, xhtmlContent, subRenderer);
        this.bandanaManager = bandanaManager;
    }

    protected boolean exemptDeveloperLicense() {
        return true;
    }

    protected String getMacroName() {
        return "graph-from-table";
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public String execute(MacroInfo info) throws MacroExecutionException {
        this.validateLicense(this.licenseManager);
        String source = "";
        try {
            long startTime = System.currentTimeMillis();
            StringBuilder builder = new StringBuilder(1024);
            String output = info.getMacroParams().getString("output", "png").toLowerCase();
            boolean showData = ScriptUtils.getBoolean((String)"showdata", (boolean)ScriptUtils.getBoolean((String)"displaydata", (boolean)false, (MacroInfo)info), (MacroInfo)info);
            boolean showCode = ScriptUtils.getBoolean((String)"showcode", (boolean)ScriptUtils.getBoolean((String)"showwiki", (boolean)false, (MacroInfo)info), (MacroInfo)info);
            String attachment = info.getMacroParams().getString("attachment", null);
            String attachmentVersion = info.getMacroParams().getString("attachmentversion", null);
            String attachmentComment = info.getMacroParams().getString("attachmentcomment", null);
            GraphvizUtils.validateMacroXss(this.bandanaManager, this.i18NBeanFactory, attachmentComment);
            boolean thumbnail = ScriptUtils.getBoolean((String)"thumbnail", (boolean)false, (MacroInfo)info);
            String node = info.getMacroParams().getString("node", null);
            GraphvizUtils.validateMacroXss(this.bandanaManager, this.i18NBeanFactory, node);
            String nodeString = node == null ? "" : "node [" + node + "]; ";
            String edge = info.getMacroParams().getString("edge", null);
            GraphvizUtils.validateMacroXss(this.bandanaManager, this.i18NBeanFactory, edge);
            String edgeString = edge == null ? "" : "edge [" + edge + "]; ";
            String orientation = "rankdir=" + (info.getMacroParams().getString("direction", "").equalsIgnoreCase("LR") ? "LR; " : "TB; ");
            String replace = info.getMacroParams().getString("replace", "");
            String tables = info.getMacroParams().getString("tables", "");
            String[] tableList = null;
            if (tables != null && !tables.trim().equals("")) {
                tableList = tables.split(",");
            }
            String columns = info.getMacroParams().getString("columns", "1,2,3,4,5,6,7,8,9");
            int[] columnList = this.getColumnList(columns);
            Map<String, String> replaceMap = this.getReplaceMap(replace);
            builder.append("\n{flowchart:").append("output=").append(output);
            builder.append("|showCode=").append(showCode ? "true" : "false");
            builder.append(attachment != null ? "|attachment=" + attachment : "");
            builder.append(attachmentVersion != null ? "|attachmentVersion=" + attachmentVersion : "");
            builder.append(attachmentComment != null ? "|attachmentComment=" + attachmentComment : "");
            builder.append(thumbnail ? "|thumbnail=true" : "");
            builder.append("}\n");
            builder.append(nodeString).append(edgeString).append(orientation);
            for (String key : info.getMacroParamsMap().keySet()) {
                key = key.trim();
                String keyLower = key.toLowerCase();
                if (key.equals("") || keyLower.equals("0") || key.startsWith(":") || key.equals("@body") || keyLower.equals("node") || keyLower.equals("edge") || keyLower.equals("showdata") || keyLower.equals("displaydata") || keyLower.equals("output") || keyLower.equals("showwiki") || keyLower.equals("showcode") || keyLower.equals("direction") || keyLower.equals("tables") || keyLower.equals("columns") || keyLower.equals("replace") || keyLower.equals("attachment") || keyLower.equals("attachmentVersion") || keyLower.equals("attachmentComment") || keyLower.equals("thumbnail")) continue;
                builder.append("\n").append(key).append("=").append((String)info.getMacroParamsMap().get(key));
            }
            builder.append("\n");
            GraphData graphData = new GraphData(info.getMacroBody(), tableList, columnList, replaceMap);
            builder.append(graphData.processData());
            builder.append("{flowchart} ");
            this.log.debug(builder.toString());
            String outputString = this.subRenderer.render(builder.toString(), (RenderContext)info.getConversionContext().getPageContext(), RENDER_MODE_WIKI);
            this.log.debug("Total elapsed time: " + (System.currentTimeMillis() - startTime) + " ms");
            this.appendReadonlyError(info, builder);
            return outputString + (showData ? source : "");
        }
        catch (MacroExecutionException exception) {
            throw exception;
        }
        catch (Exception exception) {
            this.log.error(source, (Throwable)exception);
            throw new MacroExecutionException("Unexpected program error: " + exception.toString());
        }
    }

    private int[] getColumnList(String columns) {
        String[] stringList = columns.split(",");
        int[] columnList = new int[9];
        for (int index = 0; index < 9; ++index) {
            columnList[index] = -1;
            if (index >= stringList.length) continue;
            try {
                columnList[index] = Integer.parseInt(stringList[index].trim()) - 1;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return columnList;
    }

    protected Map<String, String> getReplaceMap(String string) {
        HashMap<String, String> map = new HashMap<String, String>();
        char quote = '\'';
        String quoteAsString = "'";
        String[] list = this.splitCsvData(string, ",", new String(quoteAsString));
        for (int i = 0; i < list.length; ++i) {
            String pair = list[i].trim();
            int findAt = pair.indexOf(":");
            if (findAt <= 0) continue;
            String value = pair.substring(findAt + 1);
            if (value.length() > 1 && value.charAt(0) == quote && value.charAt(value.length() - 1) == quote) {
                value = value.substring(1, value.length() - 1);
            }
            map.put(pair.substring(0, findAt), value);
        }
        return map;
    }

    protected String[] splitCsvData(String data, String delimiter, String quote) {
        Pattern pattern;
        String patternString = "(?:^|" + delimiter + ")(?=(?:[^" + quote + "]*" + quote + "[^" + quote + "]*" + quote + ")*(?![^" + quote + "]*" + quote + "))";
        if (delimiter.length() == 1) {
            pattern = Pattern.compile(eolString + delimiter);
            Matcher matcher = pattern.matcher(data);
            data = matcher.replaceAll(eolString + " " + delimiter);
        }
        pattern = Pattern.compile(patternString, 8);
        String[] values = pattern.split(data);
        return values;
    }

    private StringBuilder appendReadonlyError(MacroInfo info, StringBuilder builder) {
        String attachmentString = info.getMacroParams().getString("attachment", null);
        if (ScriptUtils.isReadOnly() && attachmentString != null) {
            String readOnlyWarning = "<div class=\"aui-message aui-message-warning\">\n    <p>" + this.getText(GraphFromTableMacro.class.getPackage().getName() + ".graphviz-attachment-readonly-warning-message") + "    </p>\n</div>";
            builder.insert(0, readOnlyWarning);
        }
        return builder;
    }
}

