/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.graphviz;

import com.atlassian.confluence.macro.MacroExecutionException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.Text;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphData {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String TABLE = "TABLE";
    private static final String TBODY = "TBODY";
    private static final String THEAD = "THEAD";
    private static final String TFOOT = "TFOOT";
    private static final String LINK = "A";
    private static final String TR = "TR";
    private static final String TH = "TH";
    private static final char NBSP = '\u00a0';
    private static final char QUOTE = '\"';
    private static final String INDENT = "    ";
    private static final int NODE1_INDEX = 0;
    private static final int NODE2_INDEX = 1;
    private static final int RELATIONSHIP_ATTRIBUTE_INDEX = 2;
    private static final int NODE1_ATTRIBUTE_INDEX = 3;
    private static final int NODE2_ATTRIBUTE_INDEX = 4;
    private static final int CLUSTER1_INDEX = 5;
    private static final int CLUSTER1_ATTRIBUTE_INDEX = 6;
    private static final int CLUSTER2_INDEX = 7;
    private static final int CLUSTER2_ATTRIBUTE_INDEX = 8;
    private String[] tableList = null;
    private String rendered = null;
    private Document doc = null;
    private final StringBuilder output = new StringBuilder();
    private Map<String, String> replaceMap = null;
    private int[] columnList = null;
    private int tableDepth = 0;
    private int tableCount = 0;

    public GraphData(String rendered, String[] tableList, int[] columnList, Map<String, String> replaceMap) {
        this.rendered = rendered;
        this.tableList = tableList;
        this.columnList = columnList;
        this.replaceMap = replaceMap;
    }

    public String processData() throws ParseException, MacroExecutionException {
        try {
            this.doc = this.parseBody(this.rendered);
        }
        catch (DocumentException exception) {
            throw new MacroExecutionException((Throwable)exception);
        }
        Element element = this.doc.getRootElement();
        this.lookForTables(element);
        return this.output.toString();
    }

    private Document parseBody(String rendered) throws DocumentException {
        SAXReader saxReader = new SAXReader();
        return saxReader.read((Reader)new StringReader("<data>" + this.cleanHTML(rendered) + "</data>"));
    }

    private String cleanHTML(String rendered) {
        return rendered.replaceAll("\\&nbsp;", " ");
    }

    private void lookForTables(Element startElement) throws ParseException {
        List elements = startElement.elements();
        this.log.debug("elements count: {}", (Object)elements.size());
        this.log.debug("tableDepth: {}, tableCount: {}", (Object)this.tableDepth, (Object)this.tableCount);
        for (Element element : elements) {
            if (TABLE.equalsIgnoreCase(element.getName())) {
                ++this.tableCount;
                ++this.tableDepth;
                if (this.isTableInList(element)) {
                    this.processTableContent(element);
                } else {
                    this.lookForTables(element);
                }
                --this.tableDepth;
                continue;
            }
            if (element.attribute("class") != null && "preformattedContent panelContent".equalsIgnoreCase(element.attribute("class").getValue())) {
                String text = element.element("pre").getText().trim();
                if (this.tableDepth == 0) {
                    this.output.append(text);
                    this.output.append(text.endsWith(";") ? "" : ";").append("\n");
                } else {
                    this.log.debug("ignore as table depth is not 0: {}", (Object)this.tableDepth);
                }
            }
            this.lookForTables(element);
        }
    }

    private Element lookForLink(Element startElement) throws ParseException {
        List elements = startElement.elements();
        Iterator iterator = elements.iterator();
        if (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (LINK.equalsIgnoreCase(element.getName())) {
                return element;
            }
            return this.lookForLink(element);
        }
        return null;
    }

    private boolean isTableInList(Element element) {
        int i;
        int tableListLength = this.tableList == null ? 0 : this.tableList.length;
        boolean found = tableListLength == 0;
        Attribute attribute = element.attribute("id");
        String id = attribute == null ? null : attribute.getValue();
        for (i = 0; !found && i < tableListLength; ++i) {
            found = this.tableList[i].equalsIgnoreCase(id) || this.tableList[i].equals(Integer.toString(this.tableCount));
        }
        this.log.debug("found: " + found + ", i: " + i + ", tableCount: " + this.tableCount + ", id: " + id);
        return found;
    }

    private void processTableContent(Element element) throws ParseException {
        this.processTableElements(element);
    }

    private void processTableElements(Element element) throws ParseException {
        for (Element e : element.elements()) {
            if (THEAD.equalsIgnoreCase(e.getName()) || TBODY.equalsIgnoreCase(e.getName()) || TFOOT.equalsIgnoreCase(e.getName())) {
                this.processTableElements(e);
                continue;
            }
            if (!TR.equalsIgnoreCase(e.getName())) continue;
            this.processRow(e);
        }
    }

    private void processRow(Element row) throws ParseException {
        List list = row.elements();
        if (list.size() > 0 && TH.equalsIgnoreCase(((Element)list.get(0)).getName())) {
            return;
        }
        String node1 = this.getColumn(list, this.columnList[0]);
        String node2 = this.getColumn(list, this.columnList[1]);
        String relationshipAttributes = this.getAttributeColumn(list, this.columnList[2]);
        String node1Attributes = this.getAttributeColumn(list, this.columnList[3], this.columnList[0]);
        String node2Attributes = this.getAttributeColumn(list, this.columnList[4], this.columnList[1]);
        String cluster1Attributes = this.getAttributeColumn(list, this.columnList[6], this.columnList[5]);
        String cluster2Attributes = this.getAttributeColumn(list, this.columnList[8], this.columnList[7]);
        String cluster1Label = this.getColumn(list, this.columnList[5]);
        String cluster2Label = this.getColumn(list, this.columnList[7]);
        long cluster1Number = this.generateClusterNumber(cluster1Label);
        long cluster2Number = this.generateClusterNumber(cluster2Label);
        if (cluster1Number > 0L) {
            this.replaceMap.put("$" + cluster1Label, "cluster" + cluster1Number);
        }
        if (cluster2Number > 0L) {
            this.replaceMap.put("$" + cluster2Label, "cluster" + cluster2Number);
        }
        boolean addLine = false;
        String indent = "";
        if (cluster2Number > 0L) {
            this.output.append("subgraph cluster").append(cluster2Number).append(" { label=").append(GraphData.quoteStringWithEscape(cluster2Label)).append("; ");
            if (!cluster2Attributes.equals("")) {
                this.output.append(cluster2Attributes).append("; ");
                addLine = true;
            }
            indent = indent + INDENT;
        }
        if (cluster1Number > 0L) {
            if (addLine) {
                this.output.append('\n');
                addLine = false;
            }
            this.output.append(indent).append("subgraph cluster").append(cluster1Number).append(" { label=").append(GraphData.quoteStringWithEscape(cluster1Label)).append("; ");
            if (!cluster1Attributes.equals("")) {
                this.output.append(cluster1Attributes).append("; ");
                addLine = true;
            }
            indent = indent + INDENT;
        }
        String node1Quoted = GraphData.quoteStringWithEscape(node1);
        String node2Quoted = GraphData.quoteStringWithEscape(node2);
        if (!(node1.equals("") || node1Attributes.equals("") && !node2.equals(""))) {
            if (addLine) {
                this.output.append('\n');
                addLine = false;
            }
            this.output.append(indent).append(node1Quoted);
            if (!node1Attributes.equals("")) {
                this.output.append(" [").append(node1Attributes).append("]; ");
                addLine = true;
            }
        }
        if (!(node2.equals("") || node2Attributes.equals("") && !node1.equals(""))) {
            if (addLine) {
                this.output.append('\n');
                addLine = false;
            }
            this.output.append(indent).append(node2Quoted);
            if (!node2Attributes.equals("")) {
                this.output.append(" [").append(node2Attributes).append("]; ");
                addLine = true;
            }
        }
        if (!node1.equals("") && !node2.equals("")) {
            if (addLine) {
                this.output.append('\n');
            }
            this.output.append(indent).append(node1Quoted).append(" -> ").append(node2Quoted);
            if (!relationshipAttributes.equals("")) {
                this.output.append(" [").append(relationshipAttributes).append("]; ");
            }
        } else if (cluster1Number > 0L || cluster2Number > 0L) {
            if (!node1.equals("")) {
                this.output.append(node1Quoted).append("; ");
            }
            if (!node2.equals("")) {
                this.output.append(node2Quoted).append("; ");
            }
        }
        if (cluster1Number > 0L) {
            if (indent.length() >= INDENT.length()) {
                indent = indent.substring(0, indent.length() - INDENT.length());
            }
            this.output.append('\n').append(indent).append("} ");
        }
        if (cluster2Number > 0L) {
            this.output.append("\n} ");
        }
        this.output.append("\n");
    }

    private String getColumn(List<Element> list, int index) throws ParseException {
        String value = "";
        if (index >= 0 && list.size() > index) {
            value = this.getFullText(list.get(index));
        }
        return value;
    }

    private String getAttributeColumn(List<Element> list, int index) throws ParseException {
        String value = this.getColumn(list, index);
        if (!value.equals("")) {
            for (String key : this.replaceMap.keySet()) {
                value = StringUtils.replace((String)value, (String)key, (String)this.replaceMap.get(key));
            }
        }
        return value;
    }

    private String getAttributeColumn(List<Element> list, int index, int nodeIndex) throws ParseException {
        Element link;
        String value = this.getAttributeColumn(list, index);
        if (nodeIndex >= 0 && list.size() > nodeIndex && (link = this.lookForLink(list.get(nodeIndex))) != null) {
            value = value + " URL=\"" + link.attribute("href").getStringValue() + "\" ";
            this.log.debug("value: {}", (Object)value);
        }
        return value;
    }

    private long generateClusterNumber(String label) {
        CRC32 crc = new CRC32();
        crc.update(label.getBytes());
        return crc.getValue();
    }

    private String getFullText(Element element) {
        if (element == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Iterator i = element.nodeIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            if (node instanceof Text || node instanceof CDATA) {
                builder.append(node.getText());
                continue;
            }
            if (!(node instanceof Element)) continue;
            builder.append(this.getFullText((Element)node));
        }
        return builder.toString().replace('\u00a0', ' ').trim();
    }

    public static String quoteStringWithEscape(String string) {
        StringBuilder result = new StringBuilder(string.length() + 20);
        result.append('\"');
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\"') {
                result.append('\\');
            }
            result.append(string.charAt(i));
        }
        result.append('\"');
        return result.toString();
    }

    private void logElement(Element element) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("name: {}", (Object)element.getName());
            this.log.debug("node type: {}", (Object)element.getNodeTypeName());
            this.log.debug("string value: {}", (Object)element.getStringValue());
            this.log.debug("class: {}", (Object)element.attribute("class"));
            this.log.debug("href: {}", (Object)element.attribute("href"));
        }
    }
}

