/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.graphviz;

import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.core.util.PropertyUtils;
import java.io.IOException;
import java.util.Properties;
import org.swift.confluence.scriptutil.Runner;

public class DotRunner
extends Runner {
    private String verifiedDotExecutableName = null;

    public void setContent(String content) {
        super.setContent((Object)this.getEscapedCommands(content));
    }

    public void setUp(String output, String layout) throws MacroExecutionException {
        String executableName = this.findValidDotName();
        if (executableName == null) {
            throw new MacroExecutionException("No useable executable name defined in graphviz.properties");
        }
        String[] arguments = new String[]{executableName, "-T" + output, "-K" + layout};
        this.setArgs(arguments);
    }

    public void run() throws MacroExecutionException {
        super.run();
    }

    private String getEscapedCommands(String commands) {
        StringBuilder commandsEscaped = new StringBuilder();
        for (int i = 0; i < commands.length(); ++i) {
            char c = commands.charAt(i);
            if (c > '\u0080') {
                commandsEscaped.append("&#" + c + ";");
                continue;
            }
            commandsEscaped.append(c);
        }
        return commandsEscaped.toString();
    }

    private String findValidDotName() {
        if (this.verifiedDotExecutableName == null) {
            Properties p = PropertyUtils.getProperties((String)"graphviz.properties", DotRunner.class);
            String dotExecutableName = p.getProperty("dot.executable.name");
            if (dotExecutableName != null) {
                this.verifiedDotExecutableName = dotExecutableName;
            } else {
                String namesToTry = p.getProperty("dot.candidate.paths");
                if (namesToTry == null) {
                    return null;
                }
                String[] names = namesToTry.split(",");
                for (int i = 0; i < names.length; ++i) {
                    try {
                        this.log.info("trying path {}", (Object)names[i]);
                        String[] args = new String[]{names[i], "-V"};
                        Process proc = Runtime.getRuntime().exec(args);
                        this.destroyProcess(proc);
                        this.verifiedDotExecutableName = names[i];
                        break;
                    }
                    catch (IOException ioe) {
                        this.log.info("dot path {} failed, trying next path. Exception was: {}", (Object)names[i], (Object)ioe.toString());
                        continue;
                    }
                }
            }
        }
        return this.verifiedDotExecutableName;
    }
}

