/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.graphviz;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.content.render.xhtml.ConversionContextOutputType;
import com.atlassian.confluence.importexport.resource.DownloadResourceWriter;
import com.atlassian.confluence.importexport.resource.WritableDownloadResourceManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.pages.thumbnail.ThumbnailManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.graphviz.DotRunner;
import org.swift.confluence.graphviz.ao.domain.TemplateBean;
import org.swift.confluence.graphviz.ao.service.TemplatesService;
import org.swift.confluence.graphviz.service.ManageProfileService;
import org.swift.confluence.graphviz.util.GraphvizUtils;
import org.swift.confluence.macrosecurity.utils.MacroSecurityUtils;
import org.swift.confluence.macroutil.MacroInfo;
import org.swift.confluence.scriptutil.AttachmentHelper;
import org.swift.confluence.scriptutil.LicensedScriptMacro;
import org.swift.confluence.scriptutil.ProfileHelperAO;
import org.swift.confluence.scriptutil.RunnableStreamReader;
import org.swift.confluence.scriptutil.ScriptLibCommonBean;
import org.swift.confluence.scriptutil.ScriptUtils;
import org.swift.confluence.scriptutil.bean.ProfileBean;

public abstract class BaseGraphvizMacro
extends LicensedScriptMacro {
    protected final boolean EXEMPT_DEVELOPER_LICENSE = false;
    private static final String IMAGE_MAP_PREFIX = "graphviz_";
    protected static final RenderMode RENDER_MODE = RenderMode.allow((long)1028L);
    protected static final RenderMode RENDER_MODE_WIKI = RenderMode.suppress((long)256L);
    static final String SVG_MIME_TYPE = "image/svg+xml";
    static final String PDF_MIME_TYPE = "application/pdf";
    static final String PDF_EXTENSION = ".pdf";
    private static final Logger log = LoggerFactory.getLogger(BaseGraphvizMacro.class);
    private static Pattern sourceWikiLinkPattern = Pattern.compile("()()(\\[[^\\]]+\\])\\s*(-[->])(.*)");
    private static Pattern middleWikiLinkPattern = Pattern.compile("(.*)(-[->])\\s*(\\[[^\\]]+\\])\\s*(-[->])(.*)");
    private static Pattern targetWikiLinkPattern = Pattern.compile("(.*)(-[->])\\s*(\\[[^\\]]+\\])()()");
    private static Pattern wikiLinkPattern = Pattern.compile("((?:(?:edge)|(?:head)|(?:tail)|(?:label)){0,1}((?:URL)|(?:href)))\\s*=\\s*\"(\\[[^\\]]+\\])\"");
    private static Pattern hrefPattern = Pattern.compile("href\\s*=\\s*\"([^\"]+)\"");
    private static Pattern linkNamePattern = Pattern.compile(">([^<]+)<");
    protected final SubRenderer subRenderer;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final I18nResolver i18nResolver;
    @ComponentImport
    private final PluginAccessor pluginAccessor;
    protected final WritableDownloadResourceManager writableDownloadResourceManager;
    protected final ThumbnailManager thumbnailManager;
    protected final BandanaManager bandanaManager;
    private final TemplatesService templatesService;
    private final ManageProfileService manageProfileService;
    private static String script;

    public BaseGraphvizMacro(@ComponentImport SettingsManager settingsManager, @ComponentImport BootstrapManager bootstrapManager, @ComponentImport PageTemplateManager templateManager, @ComponentImport SpaceManager spaceManager, @ComponentImport PageManager pageManager, @ComponentImport PermissionManager permissionManager, @ComponentImport AttachmentManager attachmentManager, @ComponentImport LocaleManager localeManager, @ComponentImport I18NBeanFactory i18NBeanFactory, @ComponentImport PluginLicenseManager licenseManager, @ComponentImport XhtmlContent xhtmlContent, @ComponentImport SubRenderer subRenderer, @ComponentImport WritableDownloadResourceManager writableDownloadResourceManager, @ComponentImport ThumbnailManager thumbnailManager, @ComponentImport BandanaManager bandanaManager, TemplatesService templatesService, ManageProfileService manageProfileService, UserAccessor userAccessor, @ComponentImport I18nResolver i18nResolver, @ComponentImport PluginAccessor pluginAccessor) {
        super(settingsManager, bootstrapManager, templateManager, spaceManager, pageManager, permissionManager, attachmentManager, localeManager, i18NBeanFactory, licenseManager, xhtmlContent);
        this.subRenderer = subRenderer;
        this.userAccessor = userAccessor;
        this.i18nResolver = i18nResolver;
        this.writableDownloadResourceManager = writableDownloadResourceManager;
        this.thumbnailManager = thumbnailManager;
        this.bandanaManager = bandanaManager;
        this.templatesService = templatesService;
        this.manageProfileService = manageProfileService;
        this.pluginAccessor = pluginAccessor;
    }

    protected boolean exemptDeveloperLicense() {
        return false;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.PLAIN_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    protected String getScriptData(MacroInfo info) throws MacroExecutionException {
        boolean bodyAfter = ScriptUtils.getBoolean((String)"bodyafter", (boolean)false, (MacroInfo)info);
        try {
            String url;
            StringBuilder builder = new StringBuilder();
            if (!bodyAfter) {
                String data = info.getMacroBody();
                if (!"plantuml".equals(info.getConversionContext().getProperty("macroName"))) {
                    GraphvizUtils.validateMacroXss(this.bandanaManager, this.i18NBeanFactory, data);
                }
                builder.append(data);
            }
            script = this.getData(info);
            log.debug("getScriptData {}", (Object)script);
            String profileName = info.getMacroParams().getString("profile", "");
            String string = url = StringUtils.isBlank((String)script) ? info.getMacroParams().getString("url", null) : null;
            if (StringUtils.isBlank((String)script)) {
                if (StringUtils.isNotBlank((String)profileName)) {
                    ProfileBean profileBean = this.manageProfileService.getProfileBeanForProfileName(profileName);
                    if (profileBean != null) {
                        MacroSecurityUtils.securityCheck((BandanaManager)this.bandanaManager, (UserAccessor)this.userAccessor, (PluginAccessor)this.pluginAccessor, (String)this.getMacroName(), (MacroInfo)info, (String)"profile", (String)profileName);
                        String profileUrl = ProfileHelperAO.getUrlParameter((ProfileBean)profileBean, (MacroInfo)info, (String)"url", null, (BandanaManager)this.bandanaManager, (String)"com.atlassian.confluence.extra.graphviz.config.allowWhitelistedUrls", (String)"com.atlassian.confluence.extra.graphviz.config.blacklistDomains");
                        script = (String)ProfileHelperAO.retrieveDataFromUrl((MacroInfo)info, (ProfileBean)profileBean, (String)profileUrl, (SettingsManager)this.settingsManager, (I18nResolver)this.i18nResolver, (String)"com.atlassian.confluence.extra.graphviz");
                        log.debug("getScriptData {}", (Object)script);
                    }
                } else if (!StringUtils.isBlank((String)url)) {
                    ScriptUtils.checkUrlIsAllowed((String)url, (boolean)true, (BandanaManager)this.bandanaManager, (String)"com.atlassian.confluence.extra.graphviz.config.allowWhitelistedUrls", (String)"com.atlassian.confluence.extra.graphviz.config.blacklistDomains");
                    String encoding = info.getMacroParams().getString("encoding", null);
                    InputStream inputStream = this.getUrlStream(info, null, url);
                    script = ScriptUtils.getStreamAsString((InputStream)inputStream, (String)encoding);
                    ScriptUtils.closeInputStream((InputStream)inputStream);
                    log.debug("getScriptData {}", (Object)script);
                }
            }
            if (!"plantuml".equals(info.getConversionContext().getProperty("macroName"))) {
                GraphvizUtils.validateMacroXss(this.bandanaManager, this.i18NBeanFactory, script);
            }
            builder.append(script);
            if (bodyAfter) {
                builder.append(' ').append(info.getMacroBody());
            }
            return ScriptUtils.trim((String)this.getDataWithMacroRenderHandling(info, builder.toString()));
        }
        catch (MacroExecutionException exception) {
            throw exception;
        }
        catch (Exception exception) {
            StringBuilder builder = new StringBuilder();
            for (StackTraceElement element : exception.getStackTrace()) {
                builder.append("\n").append(element.toString());
            }
            throw new MacroExecutionException("Unexpected program error: " + exception.toString() + builder.toString());
        }
    }

    private ScriptLibCommonBean getScriptLibCommonBean(MacroInfo info) {
        ScriptLibCommonBean scriptLibCommonBean = new ScriptLibCommonBean();
        scriptLibCommonBean.setMacroInfo(info);
        scriptLibCommonBean.setProfileHelper(null);
        scriptLibCommonBean.setParameterName("script");
        scriptLibCommonBean.setWantJson(false);
        scriptLibCommonBean.setBandanaManager(this.bandanaManager);
        scriptLibCommonBean.setConfigKey("com.atlassian.confluence.extra.graphviz.config.allowWhitelistedUrls");
        scriptLibCommonBean.setBlacklistConfigKey("com.atlassian.confluence.extra.graphviz.config.blacklistDomains");
        scriptLibCommonBean.setBlacklistDomainValues(this.getBlacklistDomains());
        return scriptLibCommonBean;
    }

    protected String[] getBlacklistDomains() {
        String blacklistDomainValues = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "com.atlassian.confluence.extra.graphviz.config.blacklistDomains");
        String[] blacklistdomainArray = null;
        if (StringUtils.isNotBlank((String)blacklistDomainValues)) {
            blacklistdomainArray = blacklistDomainValues.split(",");
        }
        return blacklistdomainArray;
    }

    protected String getData(MacroInfo info) throws MacroExecutionException {
        return this.getData(info, null, "script");
    }

    protected String getDataWithMacroRenderHandling(MacroInfo info, String data) {
        boolean macros = ScriptUtils.getBoolean((String)"macros", (boolean)false, (MacroInfo)info);
        return macros ? this.subRenderer.render(data, (RenderContext)info.getConversionContext().getPageContext(), RENDER_MODE) : data;
    }

    protected String processDotCommands(MacroInfo info) throws MacroExecutionException {
        return this.processDotCommands(info, this.getScriptData(info), 0, 0);
    }

    protected String processDotCommands(MacroInfo info, String dotCommands, int startLine, int endSkip) throws MacroExecutionException {
        boolean useLink;
        StringBuilder builder = new StringBuilder();
        String imageMap = "";
        String imageMapSegment = "";
        String output = info.getMacroParams().getString("output", "png").toLowerCase();
        String layout = info.getMacroParams().getString("layout", "dot");
        boolean skipWikiLinkConversion = info.getMacroParams().getBoolean("skipWikiLinkConversion", false);
        AttachmentHelper attachmentHelper = this.getAttachmentHelper(info, output);
        boolean isSvg = output.equalsIgnoreCase("svg");
        boolean isPdf = output.equalsIgnoreCase("pdf");
        String template = info.getMacroParams().getString("template", "");
        if (isPdf && attachmentHelper == null) {
            throw new MacroExecutionException(this.getText(this.i18nKey + ".error.pdf-requires-attachment"));
        }
        boolean bl = useLink = isSvg && !this.isSvgCapableOutput(info) || isPdf && !this.isPdfCapableOutput(info);
        if (useLink && attachmentHelper == null) {
            builder.append("Graphviz output could not be displayed here.");
        } else {
            String urlPrefix = this.getUrlPrefix(info, false, !isSvg && !isPdf || attachmentHelper == null);
            try {
                if (!skipWikiLinkConversion) {
                    dotCommands = this.convertWikiLinksToUrlLinks(middleWikiLinkPattern, dotCommands, this.subRenderer, (RenderContext)info.getConversionContext().getPageContext(), urlPrefix);
                    dotCommands = this.convertWikiLinksToUrlLinks(sourceWikiLinkPattern, dotCommands, this.subRenderer, (RenderContext)info.getConversionContext().getPageContext(), urlPrefix);
                    dotCommands = this.convertWikiLinksToUrlLinks(targetWikiLinkPattern, dotCommands, this.subRenderer, (RenderContext)info.getConversionContext().getPageContext(), urlPrefix);
                }
                if (!(isSvg || isPdf || dotCommands.indexOf("URL=") == -1 && dotCommands.indexOf("href=") == -1)) {
                    dotCommands = this.evaluateLinks(dotCommands, this.subRenderer, (RenderContext)info.getConversionContext().getPageContext());
                    String imageMapName = IMAGE_MAP_PREFIX + ScriptUtils.getUniqueId((String)((Object)((Object)this)).getClass().getName(), (MacroInfo)info);
                    imageMap = this.generateImageMap(dotCommands, layout);
                    imageMap = imageMap.replaceFirst("<map [^>]+", "<map id=\"" + imageMapName + "\" name=\"" + imageMapName + "\"") + "\n";
                    imageMapSegment = " usemap=\"#" + imageMapName + "\"";
                }
                String attachmentName = attachmentHelper != null ? attachmentHelper.getAttachmentName(info) : null;
                Attachment attachment = attachmentHelper != null ? attachmentHelper.getAttachment() : null;
                log.debug("attachment name: {}, attachment helper: {}", (Object)attachmentName, (Object)attachmentHelper);
                if (attachmentHelper == null || !attachmentHelper.useExistingAttachment()) {
                    List errorList;
                    DownloadResourceWriter downloadResourceWriter = this.writableDownloadResourceManager.getResourceWriter(AuthenticatedUserThreadLocal.getUsername(), "graphviz", '.' + output);
                    DotRunner runner = null;
                    boolean isUml = dotCommands.startsWith("@startuml");
                    if (isSvg) {
                        String svgContent;
                        if (StringUtils.isEmpty((String)info.getMacroBody()) && StringUtils.isNotEmpty((String)template) && StringUtils.isBlank((String)script)) {
                            runner = this.getRunnerTemplates(template, output, layout, RunnableStreamReader.Type.TEXT);
                            this.validateTemplateName(runner);
                            svgContent = runner.getOutputString();
                        } else if (!isUml) {
                            runner = GraphvizUtils.getRunner(dotCommands, output, layout, RunnableStreamReader.Type.TEXT);
                            svgContent = runner.getOutputString();
                        } else {
                            log.debug("UML is getting processed...");
                            svgContent = GraphvizUtils.getUMLSvg(dotCommands);
                        }
                        String content = BaseGraphvizMacro.getSvgMarkup(svgContent);
                        if (attachmentName != null && !ScriptUtils.isReadOnly()) {
                            attachment = attachmentHelper.createAttachmentsWithLimit(info, content.getBytes(), SVG_MIME_TYPE);
                        }
                        if (attachment == null) {
                            builder.append(content);
                        }
                    } else if (isPdf) {
                        if (StringUtils.isEmpty((String)info.getMacroBody()) && StringUtils.isNotEmpty((String)template) && StringUtils.isBlank((String)script)) {
                            runner = this.getRunnerTemplates(template, output, layout, RunnableStreamReader.Type.BYTES);
                            this.validateTemplateName(runner);
                        } else {
                            runner = GraphvizUtils.getRunner(dotCommands, output, layout, RunnableStreamReader.Type.BYTES);
                        }
                        byte[] bytes = runner.getBytes();
                        log.debug("pdf, bytes: {}", (Object)bytes.length);
                        if (attachmentName != null && !ScriptUtils.isReadOnly()) {
                            attachment = attachmentHelper.createAttachmentsWithLimit(info, runner.getBytes(), PDF_MIME_TYPE);
                        }
                        if (attachment == null) {
                            new MacroExecutionException(this.getText(this.i18nKey + ".pdf-requires-attachment"));
                        }
                    } else {
                        if (StringUtils.isBlank((String)info.getMacroBody()) && StringUtils.isNotEmpty((String)template) && StringUtils.isBlank((String)script)) {
                            runner = this.getRunnerTemplates(template, output, layout, RunnableStreamReader.Type.IMAGE);
                            this.validateTemplateName(runner);
                        } else {
                            runner = GraphvizUtils.getRunner(dotCommands, output, layout, RunnableStreamReader.Type.IMAGE);
                        }
                        BufferedImage image = null;
                        if (!isUml) {
                            image = runner.getImage();
                        } else {
                            log.debug("UML is getting processed...");
                            image = GraphvizUtils.getUMLImage(dotCommands);
                        }
                        if (image != null) {
                            log.debug("height: {}, width: {}", (Object)image.getHeight(), (Object)image.getWidth());
                            if (attachmentName != null && !ScriptUtils.isReadOnly()) {
                                attachment = attachmentHelper.createImageAttachment(info, image, output);
                            }
                            if (attachment == null) {
                                OutputStream outputStream = null;
                                try {
                                    outputStream = downloadResourceWriter.getStreamForWriting();
                                    boolean result = ImageIO.write((RenderedImage)image, output, outputStream);
                                    if (!result) {
                                        throw new MacroExecutionException("Error writing image. Result from write operation was: {}");
                                    }
                                }
                                catch (IOException exception) {
                                    throw new MacroExecutionException("Error writing image. Exception is: " + exception.toString(), (Throwable)exception);
                                }
                                finally {
                                    IOUtils.closeQuietly((OutputStream)outputStream);
                                }
                                String urlString = downloadResourceWriter.getResourcePath();
                                builder.append(imageMap).append("<img src='").append(urlString).append("'").append(imageMapSegment).append("/>");
                            }
                        }
                    }
                    if (runner != null && (errorList = runner.getErrorList()) != null && !errorList.isEmpty()) {
                        builder.append("<div class=\"errorBox\">\n").append(BaseGraphvizMacro.generateErrorMessage(errorList, dotCommands, startLine, endSkip)).append("\n</div>");
                    }
                }
                if (attachment != null && !ScriptUtils.isReadOnly()) {
                    if (useLink) {
                        builder.append("<a href=\"").append(this.getAttachmentUrl(attachment)).append("\">").append(attachment.getFileName()).append("</a>");
                    } else if (isPdf) {
                        if (this.isPreview(info)) {
                            builder.append(this.getText(this.i18nKey + ".preview-not-available"));
                        } else {
                            StringBuilder viewfileMacro = new StringBuilder();
                            viewfileMacro.append("{viewfile:").append(attachment.getFileName());
                            if (!info.getConversionContext().getPageContext().getPageTitle().equals(attachmentHelper.getPage().getDisplayTitle())) {
                                viewfileMacro.append("|page=").append(attachmentHelper.getPage().getDisplayTitle());
                            }
                            if (!info.getConversionContext().getPageContext().getSpaceKey().equals(attachmentHelper.getPage().getSpaceKey())) {
                                viewfileMacro.append("|space=").append(attachmentHelper.getPage().getSpaceKey());
                            }
                            viewfileMacro.append("}");
                            log.debug("viewfile markup: {}", (Object)viewfileMacro);
                            builder.append(this.subRenderer.render(viewfileMacro.toString(), (RenderContext)info.getConversionContext().getPageContext(), RENDER_MODE_WIKI));
                        }
                    } else {
                        builder.append(attachmentHelper.getAttachmentHtml(ScriptUtils.getBoolean((String)"thumbnail", (boolean)false, (MacroInfo)info), imageMap, imageMapSegment));
                    }
                }
                this.setScrollBarHeight(info, builder);
                boolean showCode = ScriptUtils.getBoolean((String)"showcode", (boolean)false, (MacroInfo)info);
                if (showCode) {
                    builder.append(this.subRenderer.render(BaseGraphvizMacro.getCodeWiki(dotCommands, "none"), (RenderContext)info.getConversionContext().getPageContext(), RENDER_MODE_WIKI));
                }
            }
            catch (MacroExecutionException exception) {
                throw exception;
            }
            catch (Exception exception) {
                log.error(dotCommands, (Throwable)exception);
                throw new MacroExecutionException("Unexpected error: " + exception.toString());
            }
        }
        this.appendReadonlyError(info, builder).toString();
        return builder.toString();
    }

    private StringBuilder setScrollBarHeight(MacroInfo info, StringBuilder builder) {
        boolean enableScroll = info.getMacroParams().getBoolean("enableScroll", true);
        if (enableScroll) {
            String scrollHeight = info.getMacroParams().getString("scrollHeight", "550px");
            String divForScroll = "<div class='appfire-gviz-div' style='overflow-x: scroll; max-height: " + scrollHeight + ";'>";
            String divForScrollEnd = "</div>";
            builder.insert(0, divForScroll);
            builder.insert(builder.length(), divForScrollEnd);
        }
        return builder;
    }

    private DotRunner getRunnerTemplates(String template, String output, String layout, RunnableStreamReader.Type type) throws Exception {
        DotRunner dotRunner = null;
        ArrayList<TemplateBean> templatesFromAO = null;
        try {
            templatesFromAO = GraphvizUtils.getTemplateBeansFromEntities(this.templatesService.getAppfireTemplates());
        }
        catch (Exception e) {
            log.debug("Error while retrieving the template details, please try again", (Throwable)e);
        }
        if (templatesFromAO != null) {
            for (TemplateBean templates : templatesFromAO) {
                if (!templates.getTemplateName().equals(template)) continue;
                String wikiMarkup = GraphvizUtils.getUpdatedSyntax(templates.getWikiSyntax(), templates.getMacroName());
                dotRunner = GraphvizUtils.getRunner(wikiMarkup, output, layout, type);
                break;
            }
        }
        return dotRunner;
    }

    private String convertWikiLinksToUrlLinks(Pattern pattern, String dotCommands, SubRenderer subRenderer, RenderContext context, String urlPrefix) {
        boolean isSource = pattern == sourceWikiLinkPattern;
        boolean isMiddle = pattern == middleWikiLinkPattern;
        Matcher matcher = pattern.matcher(dotCommands);
        StringBuffer resultBuilder = new StringBuffer();
        boolean changesMade = false;
        while (matcher.find()) {
            String beforePart = matcher.group(1);
            String beforeDashPart = matcher.group(2);
            String wikiLink = matcher.group(3);
            String afterDashPart = matcher.group(4);
            String afterPart = matcher.group(5);
            String linkHtml = subRenderer.render(wikiLink, context, RENDER_MODE_WIKI);
            Matcher matcherRendered = hrefPattern.matcher(linkHtml);
            String replacement = wikiLink;
            if (matcherRendered.find()) {
                String href = matcherRendered.group(1);
                log.debug("href original: {}", (Object)href);
                log.debug("base url without context: {}", (Object)this.getBaseUrlWithoutContextPath());
                if (href.startsWith("/")) {
                    href = urlPrefix + href;
                }
                log.debug("href after: {}", (Object)href);
                matcherRendered = linkNamePattern.matcher(linkHtml);
                if (matcherRendered.find()) {
                    String name = matcherRendered.group(1);
                    log.debug("match found on link name: {}", (Object)name);
                    replacement = name + " [ URL=\"" + href + "\" ] \n";
                    replacement = isSource ? replacement + name + " " + afterDashPart + afterPart : (isMiddle ? replacement + beforePart + beforeDashPart + " " + name + " " + afterDashPart + afterPart : replacement + beforePart + beforeDashPart + " " + name);
                    changesMade = true;
                }
                log.debug("match found on href: {}", (Object)replacement);
            }
            matcher.appendReplacement(resultBuilder, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(resultBuilder);
        String result = resultBuilder.toString();
        if (changesMade && isMiddle) {
            result = this.convertWikiLinksToUrlLinks(pattern, result, subRenderer, context, urlPrefix);
        }
        return result;
    }

    private static String generateErrorMessage(List<String> errorList, String dotCommands, int startLine, int endSkip) {
        Integer lineNoInteger;
        String[] parts;
        String message = ScriptUtils.toSeparatedString(errorList, (String)"\n");
        if (message.indexOf("syntax error") != -1 && (parts = message.split(":")).length > 3 && (lineNoInteger = ScriptUtils.getIntegerOrNull((String)parts[2])) != null) {
            int lineNo = lineNoInteger - 1;
            String[] lines = dotCommands.split("\n");
            message = "Error: " + parts[3] + (parts.length > 4 ? ":" + parts[4] : "") + "<br/>\n";
            for (int i = startLine; i < lines.length - endSkip; ++i) {
                if (i != lineNo) continue;
                message = message + "<span style=\"background-color: #FF8080\">";
                message = message + lines[i];
                message = message + "</span>";
                message = message + "</br>\n";
            }
        }
        return message;
    }

    protected static String getCodeWiki(String code, String language) {
        return " {code:" + language + "|title=Graphviz markup|linenumbers=true|controls=false|firstline=1} " + code + " {code}";
    }

    private String evaluateLinks(String dotCommands, SubRenderer subRenderer, RenderContext context) {
        Matcher matcher = wikiLinkPattern.matcher(dotCommands);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String urlType = matcher.group(1);
            String urlOrHref = matcher.group(2);
            String wikiLink = matcher.group(3);
            String linkHtml = subRenderer.render(wikiLink, context, RENDER_MODE_WIKI);
            log.debug("match found on URL: {}, link: {}", (Object)urlType, (Object)linkHtml);
            Matcher matcherRendered = hrefPattern.matcher(linkHtml);
            String replacement = wikiLink;
            if (matcherRendered.find()) {
                replacement = urlType + "=\"" + matcherRendered.group(1) + "\"";
                matcherRendered = linkNamePattern.matcher(linkHtml);
                if (matcherRendered.find()) {
                    String name = matcherRendered.group(1);
                    log.debug("match found on link name: {}", (Object)name);
                    replacement = urlType.equals(urlOrHref) ? replacement + " label=\"" + name + "\"" : replacement + " " + urlType.replace(urlOrHref, "tooltip") + "=\"" + name + "\"";
                }
                log.debug("match found on href: {}", (Object)replacement);
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private String generateImageMap(String dotCommands, String layout) throws Exception {
        DotRunner dotRunner = GraphvizUtils.getRunner(dotCommands, "cmapx", layout, RunnableStreamReader.Type.TEXT);
        if (dotRunner.getExitCode() != 0) {
            throw new MacroExecutionException("Failed to create image map: " + ScriptUtils.toSeparatedString((Collection)dotRunner.getErrorList(), (String)"\n"));
        }
        return ScriptUtils.toSeparatedString((Collection)dotRunner.getOutput(), (String)"\n");
    }

    public static String getSvgMarkup(String content) {
        int index = content.indexOf("<svg");
        if (index >= 0) {
            return content.substring(index);
        }
        return "";
    }

    protected AttachmentHelper getAttachmentHelper(MacroInfo info, String output) {
        AttachmentHelper attachmentHelper = null;
        String attachmentFilename = info.getMacroParams().getString("attachment", null);
        if (attachmentFilename != null) {
            if (output.equalsIgnoreCase("pdf")) {
                attachmentFilename = attachmentFilename + (!attachmentFilename.endsWith(PDF_EXTENSION) ? PDF_EXTENSION : "");
            }
            attachmentHelper = new AttachmentHelper(attachmentFilename, this.i18nKey, this.getI18nBean(), this.settingsManager, this.spaceManager, this.pageManager, this.permissionManager, this.attachmentManager, this.thumbnailManager);
        }
        return attachmentHelper;
    }

    protected String getUrlPrefix(MacroInfo info, boolean withContext, boolean requestRelative) {
        boolean relative = ScriptUtils.getBoolean((String)"relativeLink", (boolean)requestRelative, (MacroInfo)info);
        return relative ? (withContext ? this.getContextPath() : "") : (withContext ? this.getBaseUrl() : this.getBaseUrlWithoutContextPath());
    }

    protected String getConfluenceNodeAttributes(MacroInfo info, int fontsize) {
        return "node [shape=rect, style=filled, fillcolor=lightyellow, fontname=\"Verdana\", fontsize=" + fontsize + "];";
    }

    protected boolean isPreview(MacroInfo info) {
        return ConversionContextOutputType.PREVIEW.value().equals(info.getConversionContext().getOutputType());
    }

    protected boolean isSvgCapableOutput(MacroInfo info) {
        return ConversionContextOutputType.DISPLAY.value().equals(info.getConversionContext().getOutputType()) || ConversionContextOutputType.PREVIEW.value().equals(info.getConversionContext().getOutputType()) || ConversionContextOutputType.FEED.value().equals(info.getConversionContext().getOutputType()) || ConversionContextOutputType.HTML_EXPORT.value().equals(info.getConversionContext().getOutputType());
    }

    protected boolean isPdfCapableOutput(MacroInfo info) {
        return ConversionContextOutputType.DISPLAY.value().equals(info.getConversionContext().getOutputType());
    }

    private StringBuilder appendReadonlyError(MacroInfo info, StringBuilder builder) {
        String attachmentString = info.getMacroParams().getString("attachment", null);
        if (ScriptUtils.isReadOnly() && attachmentString != null) {
            String readOnlyWarning = "<div class=\"aui-message aui-message-warning\">\n    <p>" + this.getText(BaseGraphvizMacro.class.getPackage().getName() + ".graphviz-attachment-readonly-warning-message") + "    </p>\n</div>";
            builder.insert(0, readOnlyWarning);
        }
        return builder;
    }

    private void validateTemplateName(DotRunner runner) throws MacroExecutionException {
        if (runner == null) {
            throw new MacroExecutionException(this.getText(this.i18nKey + ".choose-valid-template-from-list"));
        }
    }
}

