/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.util;

import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.user.User;
import com.cenotelabs.lockpoint.I;
import com.cenotelabs.lockpoint.L;
import com.cenotelabs.lockpoint.util.NullAcceptingDateFormat;
import jakarta.inject.Inject;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DateHelper {
    private FormatSettingsManager a;
    private LocaleManager b;
    private TimeZoneManager c;
    private I18nResolver d;

    @Inject
    public DateHelper(@ComponentImport FormatSettingsManager formatSettingsManager, @ComponentImport LocaleManager localeManager, @ComponentImport TimeZoneManager timeZoneManager, @ComponentImport I18nResolver i18nResolver) {
        this.a = formatSettingsManager;
        this.b = localeManager;
        this.c = timeZoneManager;
        this.d = i18nResolver;
    }

    public Date getCurrentDate() {
        return new Date();
    }

    private TimeZone a(ConfluenceUser confluenceUser) {
        if (confluenceUser != null) {
            return this.c.getUserTimeZone(confluenceUser.getKey());
        }
        return this.c.getDefaultTimeZone();
    }

    public Locale getLocaleForUser(ConfluenceUser confluenceUser) {
        return this.b.getLocale((User)confluenceUser);
    }

    public NullAcceptingDateFormat getDateTimeFormatForUser(ConfluenceUser object) {
        try (I i2 = L.a("DateHelper#getDateTimeFormatForUser");){
            DateHelper dateHelper = this;
            object = dateHelper.getDateTimeFormat(dateHelper.getLocaleForUser((ConfluenceUser)object), this.a((ConfluenceUser)object));
            return object;
        }
    }

    public NullAcceptingDateFormat getDateTimeFormat(Locale object, TimeZone timeZone) {
        try (I i2 = L.a("DateHelper#getDateTimeFormat");){
            String string = this.a.getDateTimeFormat();
            String string2 = this.d.getText((Locale)object, "com.arsenale.plugins.lockpoint.dateNone");
            object = new NullAcceptingDateFormat(string, (Locale)object, timeZone, string2);
            return object;
        }
    }

    static {
        LoggerFactory.getLogger(DateHelper.class);
    }
}

