/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.settings;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.cenotelabs.lockpoint.activeobjects.models.CustomizableTemplate;
import com.cenotelabs.lockpoint.activeobjects.models.Template;
import com.cenotelabs.lockpoint.activeobjects.models.Timeout;
import com.cenotelabs.lockpoint.activeobjects.services.AttributeService;
import com.cenotelabs.lockpoint.activeobjects.services.TemplateService;
import com.cenotelabs.lockpoint.activeobjects.services.TimeoutService;
import com.cenotelabs.lockpoint.i18n.LanguageHelper;
import com.cenotelabs.lockpoint.model.EmailTemplate;
import com.cenotelabs.lockpoint.rest.transport.SpaceTemplatesTransport;
import com.cenotelabs.lockpoint.rest.transport.SpaceTimeoutsTransport;
import com.cenotelabs.lockpoint.settings.SpaceAttributesManager;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="spaceAttributesManager")
public class DefaultSpaceAttributesManager
implements SpaceAttributesManager {
    private static final Map<String, String> a = new HashMap<String, String>();
    private AttributeService b;
    private TemplateService c;
    private TimeoutService d;
    private LanguageHelper e;

    @Inject
    public DefaultSpaceAttributesManager(AttributeService attributeService, TemplateService templateService, TimeoutService timeoutService, LanguageHelper languageHelper) {
        this.b = attributeService;
        this.c = templateService;
        this.d = timeoutService;
        this.e = languageHelper;
    }

    @Override
    public Boolean getLockpointEnabled(Space space) {
        return this.b.getLockpointEnabled(space);
    }

    @Override
    public void setLockpointEnabled(Space space, Boolean bl) {
        if (space == null && bl == null) {
            throw new IllegalArgumentException("Cannot set tristate value for system-wide space enablement");
        }
        this.b.setLockpointEnabled(space, bl);
    }

    @Override
    public boolean getDefaultLockpointEnabled() {
        return this.b.getLockpointEnabledDefault();
    }

    @Override
    public void setDefaultLockpointEnabled(boolean bl) {
        this.b.setLockpointEnabledDefault(bl);
    }

    @Override
    public boolean isLockpointEnabledInSpace(Space object) {
        return (Boolean)((object = this.b.getLockpointEnabled((Space)object)) != null ? object : this.b.getLockpointEnabledDefault());
    }

    @Override
    public boolean isLockpointEnabledInSpace(ContentEntityObject contentEntityObject) {
        return contentEntityObject instanceof AbstractPage && this.isLockpointEnabledInSpace(((AbstractPage)contentEntityObject).getSpace());
    }

    @Override
    public boolean isLockpointEnabledInSpace(Attachment attachment) {
        return attachment != null && this.isLockpointEnabledInSpace(attachment.getContainer());
    }

    @Override
    public SpaceTimeoutsTransport getTimeoutsForSpace(Space object) {
        object = this.d.get((Space)object);
        Timeout timeout = this.d.getDefault();
        timeout = object != null ? object : timeout;
        return new SpaceTimeoutsTransport(timeout.getWarningTimeout(), timeout.getUnlockTimeout(), object == null);
    }

    @Override
    public SpaceTimeoutsTransport getDefaultTimeouts() {
        Timeout timeout = this.d.getDefault();
        return new SpaceTimeoutsTransport(timeout.getWarningTimeout(), timeout.getUnlockTimeout(), true);
    }

    @Override
    public void setTimeoutsForSpace(Space space, SpaceTimeoutsTransport spaceTimeoutsTransport) {
        if (space != null && spaceTimeoutsTransport.isUseSystemDefaults()) {
            this.d.remove(space);
            return;
        }
        this.d.set(new Timeout(space, spaceTimeoutsTransport.getWarningTimeout(), spaceTimeoutsTransport.getUnlockTimeout()));
    }

    @Override
    public void setDefaultTimeouts(SpaceTimeoutsTransport spaceTimeoutsTransport) {
        this.setTimeoutsForSpace(null, spaceTimeoutsTransport);
    }

    @Override
    public SpaceTemplatesTransport getTemplatesForSpace(Space space, ConfluenceUser confluenceUser) {
        return this.getTemplatesForSpace(space, this.e.getLanguageTagForUser(confluenceUser));
    }

    @Override
    public EmailTemplate getDefaultTemplate(String string, Template.Type type) {
        if (string.equals("GLOBAL")) {
            throw new IllegalArgumentException("Cannot fetch template of type " + String.valueOf((Object)type) + " for global language");
        }
        return this.getTemplateForSpace(null, type, string, null);
    }

    @Override
    public EmailTemplate getTemplateForSpace(Space space, Template.Type type, ConfluenceUser object) {
        String string = (object = this.e.getLanguageTagForUser((ConfluenceUser)object)) != null ? a.get(object) : null;
        return this.getTemplateForSpace(space, type, (String)object, string);
    }

    @Override
    public EmailTemplate getTemplateForSpace(@Nullable Space space, Template.Type type, String object, String string) {
        boolean bl = true;
        Template template = null;
        if (space != null) {
            template = this.c.get(space, type, null);
        }
        if (template == null) {
            if (!((CustomizableTemplate)(object = this.c.getDefault(type, (String)object))).isCustomized() && string != null) {
                object = this.c.getDefault(type, string);
            }
            template = ((CustomizableTemplate)object).getTemplate();
            bl = space == null && ((CustomizableTemplate)object).isCustomized();
        }
        return new EmailTemplate(template, bl);
    }

    @Override
    public SpaceTemplatesTransport getTemplatesForSpace(Space object, String string) {
        EmailTemplate emailTemplate = this.getTemplateForSpace((Space)object, Template.Type.WARNING, string, null);
        EmailTemplate emailTemplate2 = this.getTemplateForSpace((Space)object, Template.Type.UNLOCK, string, null);
        object = this.getTemplateForSpace((Space)object, Template.Type.NOTIFY, string, null);
        return new SpaceTemplatesTransport(emailTemplate, emailTemplate2, (EmailTemplate)object);
    }

    @Override
    public void setTemplatesForSpace(@Nonnull Space space, SpaceTemplatesTransport spaceTemplatesTransport) {
        this.a(space, Template.Type.WARNING, null, spaceTemplatesTransport.getWarning(), spaceTemplatesTransport.getWarning().isCustomized());
        this.a(space, Template.Type.UNLOCK, null, spaceTemplatesTransport.getUnlock(), spaceTemplatesTransport.getUnlock().isCustomized());
        this.a(space, Template.Type.NOTIFY, null, spaceTemplatesTransport.getNotify(), spaceTemplatesTransport.getNotify().isCustomized());
    }

    private List<String> a(String string) {
        if (!string.equals("GLOBAL")) {
            return Collections.singletonList(string);
        }
        return this.e.getSupportedLanguageKeys();
    }

    @Override
    public void setDefaultTemplate(String object, Template.Type type, EmailTemplate emailTemplate) {
        for (String string : this.a((String)object)) {
            this.a(null, type, string, emailTemplate, true);
        }
    }

    @Override
    public void revertDefaultTemplate(String object, Template.Type type) {
        for (String string : this.a((String)object)) {
            this.a(null, type, string, null, false);
        }
    }

    private void a(Space space, Template.Type type, String string, EmailTemplate emailTemplate, boolean bl) {
        if (bl) {
            this.c.set(new Template(space, Template.Format.TEXT, type, string, emailTemplate.getSubject(), emailTemplate.getBody()));
            return;
        }
        this.c.remove(space, type, string);
    }

    static {
        a.put("en-GB", "en-US");
        a.put("en-UK", "en-US");
        a.put("en-US", "en-GB");
        a.put("fr-FR", "fr-CA");
        a.put("fr-CA", "fr-FR");
    }
}

