/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.locks;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.PlainTextToHtmlConverter;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.cenotelabs.lockpoint.F;
import com.cenotelabs.lockpoint.licensing.LicenseManagerReason;
import com.cenotelabs.lockpoint.licensing.SimpleLicenseManager;
import com.cenotelabs.lockpoint.p;
import com.cenotelabs.lockpoint.r;
import com.cenotelabs.lockpoint.s;
import com.cenotelabs.lockpoint.settings.LockpointGlobalSettingsManager;
import com.cenotelabs.lockpoint.settings.SpaceAttributesManager;
import com.cenotelabs.lockpoint.util.DateHelper;
import com.cenotelabs.lockpoint.util.NullAcceptingDateFormat;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LockHelper {
    private static final Logger a = LoggerFactory.getLogger(LockHelper.class);
    private final SpaceAttributesManager b;
    private final UserAccessor c;
    private final LockpointGlobalSettingsManager d;
    private final I18nResolver e;
    private final SimpleLicenseManager f;
    private final DateHelper g;

    @Inject
    public LockHelper(SpaceAttributesManager spaceAttributesManager, UserAccessor userAccessor, LockpointGlobalSettingsManager lockpointGlobalSettingsManager, I18nResolver i18nResolver, SimpleLicenseManager simpleLicenseManager, DateHelper dateHelper) {
        this.b = spaceAttributesManager;
        this.c = userAccessor;
        this.d = lockpointGlobalSettingsManager;
        this.e = i18nResolver;
        this.f = simpleLicenseManager;
        this.g = dateHelper;
    }

    public boolean isActiveInSpace(r r2) {
        return (r2 = r2.e()) != null && this.b.isLockpointEnabledInSpace((Space)r2);
    }

    public boolean isLockedByAnyone(r r2) {
        return r2.h() && this.isActiveInSpace(r2);
    }

    public boolean isLockedWithWebDav(r r2) {
        return r2.h() && r2.b().isLockedWithWebDav() && this.isActiveInSpace(r2);
    }

    public String getLockOwner(r r2) {
        if (r2.h() && this.isActiveInSpace(r2)) {
            return r2.b().getOwner();
        }
        return null;
    }

    public ConfluenceUser getLockOwnerUser(r object) {
        if ((object = this.getLockOwner((r)object)) != null) {
            return this.c.getExistingUserByKey(new UserKey((String)object));
        }
        return null;
    }

    public String getLockOwnerDisplayName(r r2) {
        ConfluenceUser confluenceUser = this.getLockOwnerUser(r2);
        if (confluenceUser != null) {
            return confluenceUser.getFullName();
        }
        return this.getLockOwner(r2);
    }

    public boolean isLockedByCurrentUser(r r2) {
        return this.isLockedByGivenUser(r2, AuthenticatedUserThreadLocal.get());
    }

    public boolean isLockedByGivenUser(r object, ConfluenceUser object2) {
        if (object2 == null) {
            return false;
        }
        if (F.a((String)(object2 = object2.getKey().getStringValue()))) {
            return false;
        }
        object = this.getLockOwner((r)object);
        return ((String)object2).equals(object);
    }

    public boolean isLockedByAnotherUser(r r2) {
        return this.isLockedByAnotherUser(r2, AuthenticatedUserThreadLocal.get());
    }

    public boolean isLockedByAnotherUser(r r2, ConfluenceUser confluenceUser) {
        boolean bl = this.isLockedByGivenUser(r2, confluenceUser);
        return !bl && this.isLockedByAnyone(r2);
    }

    public s isUploadAllowed(r object, ConfluenceUser object2, boolean bl) {
        if (!this.isActiveInSpace((r)object)) {
            return s.a;
        }
        Object object3 = this.getLicenseReason();
        if (object3 != LicenseManagerReason.a) {
            return s.a;
        }
        object3 = ((r)object).d();
        if (!this.isLockedByAnyone((r)object)) {
            if (bl || this.d.getPermitUploadWithoutLock()) {
                return s.a;
            }
            object2 = "com.arsenale.plugins.lockpoint.filemustbecheckedout";
            object = this.e.getText((String)object2, new Serializable[]{PlainTextToHtmlConverter.encodeHtmlEntities((String)object3)});
            String string = this.e.getText((String)object2, new Serializable[]{object3});
            return new s(false, (String)object, string);
        }
        if (!this.isLockedByGivenUser((r)object, (ConfluenceUser)object2)) {
            object2 = "com.arsenale.plugins.lockpoint.filecheckedouttootheruser";
            object = this.getLockOwnerDisplayName((r)object);
            String string = this.e.getText((String)object2, (Serializable[])PlainTextToHtmlConverter.encodeHtmlEntities((String[])new String[]{object3, object}));
            object = this.e.getText((String)object2, new Serializable[]{object3, object});
            return new s(false, string, (String)object);
        }
        return s.a;
    }

    public String renderLockWarningAsHtml(r r2) {
        try {
            String string = r2.d();
            String string2 = this.getUserDisplayStringForLock(r2);
            String string3 = this.getFormattedLockDate(r2);
            string2 = this.e.getText("com.arsenale.plugins.lockpoint.tooltip.lockedbysentence", new Serializable[]{string2, string3});
            return "<div class=\"lockpoint-warning-nof\"><div class=\"lockpointicon lockedbysomeoneelse\">&nbsp;\n</div>\n<div class=\"lpinnerattach\">\n<span><strong>" + HtmlUtil.htmlEncode((String)string) + "</strong> \n" + string2 + "\n</span>\n</div>\n</div><br/>";
        }
        catch (Exception exception) {
            a.error("Could not render attachment warning for " + String.valueOf(r2.a()), (Throwable)exception);
            return "*ERROR*";
        }
    }

    public String getLockedByOtherUserMessage(r r2) {
        return this.e.getText("com.arsenale.plugins.lockpoint.filecheckedouttootheruser", new Serializable[]{r2.d(), this.getLockOwnerDisplayName(r2)});
    }

    public LicenseManagerReason getLicenseReason() {
        return this.f.getLicenseReason(Locale.getDefault(), true);
    }

    public p getLicenseStatus() {
        return this.f.getLicenseStatus(Locale.getDefault(), true);
    }

    public Date getLockDate(r r2) {
        if (r2.b().isLocked()) {
            return new Date(r2.b().getLockedDate());
        }
        return null;
    }

    public String getFormattedLockDate(r object) {
        NullAcceptingDateFormat nullAcceptingDateFormat = this.g.getDateTimeFormatForUser(AuthenticatedUserThreadLocal.get());
        object = nullAcceptingDateFormat.format(this.getLockDate((r)object));
        if (object != null) {
            return object;
        }
        return "";
    }

    public String getUserDisplayStringForLock(r object) {
        if ((object = this.getLockOwnerUser((r)object)) == null) {
            return "";
        }
        String string = HtmlUtil.htmlEncode((String)object.getFullName());
        if (!F.a((String)(object = object.getEmail()))) {
            return "<a href=\"mailto:" + HtmlUtil.htmlEncode((String)object) + "\">" + string + "</a>";
        }
        return string;
    }
}

