/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.background;

import com.cenotelabs.lockpoint.background.BackgroundActionQueue;
import com.cenotelabs.lockpoint.background.BackgroundActionTask;
import com.cenotelabs.lockpoint.background.BackgroundActionType;
import com.cenotelabs.lockpoint.j;
import io.atlassian.util.concurrent.ThreadFactories;
import jakarta.inject.Inject;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class BackgroundActionService
implements DisposableBean,
InitializingBean {
    private static final Logger a = LoggerFactory.getLogger(BackgroundActionService.class);
    private ExecutorService b;
    private BackgroundActionQueue c;
    private BackgroundActionTask d;

    @Inject
    public BackgroundActionService(BackgroundActionQueue backgroundActionQueue, BackgroundActionTask backgroundActionTask) {
        this.c = backgroundActionQueue;
        this.d = backgroundActionTask;
        this.b = new ThreadPoolExecutor(0, 1, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), ThreadFactories.namedThreadFactory((String)"lockpointActionThread", (ThreadFactories.Type)ThreadFactories.Type.DAEMON));
    }

    public void afterPropertiesSet() {
        a.debug("Starting BackgroundActionTask thread");
        this.b.submit(this.d);
    }

    public void destroy() {
        a.debug("Shutting down BackgroundActionTask thread");
        this.c.addAction(new j(BackgroundActionType.b));
        a.debug("Shutting down the thread executor");
        this.b.shutdown();
        a.debug("Executor shutdown");
        try {
            if (!this.b.awaitTermination(5L, TimeUnit.SECONDS)) {
                a.warn("Could not shut down Lockpoint BackgroundActionThread gracefully; now force-stopping it.");
                this.b.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            a.warn("Lockpoint doDestroy received InterruptedException", (Throwable)interruptedException);
            Thread.interrupted();
        }
        a.debug("BackgroundActionTask thread shut down");
    }
}

