/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.activeobjects.services;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.cenotelabs.lockpoint.activeobjects.daos.AttributeDao;
import com.cenotelabs.lockpoint.activeobjects.models.Attribute;
import com.cenotelabs.lockpoint.activeobjects.models.Timeout;
import jakarta.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class TimeoutService {
    private final ActiveObjects a;
    private final AttributeDao b;

    @Inject
    public TimeoutService(@ComponentImport ActiveObjects activeObjects, AttributeDao attributeDao) {
        this.a = activeObjects;
        this.b = attributeDao;
    }

    public Timeout get(Space space) {
        Attribute attribute = this.b.get(this.a, space, Attribute.Type.WARNING_TIMEOUT);
        Attribute attribute2 = this.b.get(this.a, space, Attribute.Type.UNLOCK_TIMEOUT);
        if (attribute != null && attribute2 != null) {
            return new Timeout(space, attribute.getLongValue(), attribute2.getLongValue());
        }
        return null;
    }

    public Timeout getDefault() {
        Timeout timeout = this.get(null);
        if (timeout == null) {
            timeout = new Timeout(null, 24L, 48L);
        }
        return timeout;
    }

    public void set(Timeout timeout) {
        this.b.save(this.a, new Attribute(timeout.getSpace(), Attribute.Type.WARNING_TIMEOUT, timeout.getWarningTimeout()));
        this.b.save(this.a, new Attribute(timeout.getSpace(), Attribute.Type.UNLOCK_TIMEOUT, timeout.getUnlockTimeout()));
    }

    public void remove(Space space) {
        this.b.delete(this.a, space, Attribute.Type.WARNING_TIMEOUT);
        this.b.delete(this.a, space, Attribute.Type.UNLOCK_TIMEOUT);
    }
}

